/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.registry.dragon.ability.entity_effects;

import by.dragonsurvivalteam.dragonsurvival.common.codecs.TargetDirection;
import by.dragonsurvivalteam.dragonsurvival.common.entity.projectiles.GenericArrowEntity;
import by.dragonsurvivalteam.dragonsurvival.common.entity.projectiles.GenericBallEntity;
import by.dragonsurvivalteam.dragonsurvival.registry.datagen.Translation;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.ability.DragonAbilityInstance;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.ability.entity_effects.AbilityEntityEffect;
import by.dragonsurvivalteam.dragonsurvival.registry.projectile.ProjectileData;
import by.dragonsurvivalteam.dragonsurvival.registry.projectile.block_effects.ProjectileBlockEffect;
import by.dragonsurvivalteam.dragonsurvival.registry.projectile.entity_effects.ProjectileEntityEffect;
import by.dragonsurvivalteam.dragonsurvival.registry.projectile.targeting.ProjectileTargeting;
import by.dragonsurvivalteam.dragonsurvival.util.DSColors;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.enchantment.LevelBasedValue;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public record ProjectileEffect(Holder<ProjectileData> projectileData, TargetDirection targetDirection, LevelBasedValue numberOfProjectiles, LevelBasedValue projectileSpread, LevelBasedValue speed) implements AbilityEntityEffect
{
    @Translation(comments={"\u00a76\u25a0 Number of projectiles:\u00a7r %s"})
    private static final String ABILITY_PROJECTILE_COUNT = Translation.Type.GUI.wrap("projectile.count");
    @Translation(comments={"\u00a76\u25a0 Projectile Speed:\u00a7r %s"})
    private static final String ABILITY_PROJECTILE_SPEED = Translation.Type.GUI.wrap("projectile.speed");
    @Translation(comments={"\u00a76\u25a0 Projectile Spread:\u00a7r %s"})
    private static final String ABILITY_PROJECTILE_SPREAD = Translation.Type.GUI.wrap("projectile.spread");
    public static final MapCodec<ProjectileEffect> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ProjectileData.CODEC.fieldOf("projectile_data").forGetter(ProjectileEffect::projectileData), (App)TargetDirection.CODEC.fieldOf("target_direction").forGetter(ProjectileEffect::targetDirection), (App)LevelBasedValue.CODEC.fieldOf("number_of_projectiles").forGetter(ProjectileEffect::numberOfProjectiles), (App)LevelBasedValue.CODEC.optionalFieldOf("projectile_spread", (Object)LevelBasedValue.constant((float)0.0f)).forGetter(ProjectileEffect::projectileSpread), (App)LevelBasedValue.CODEC.fieldOf("speed").forGetter(ProjectileEffect::speed)).apply((Applicative)instance, ProjectileEffect::new));

    @Override
    public void apply(ServerPlayer dragon, DragonAbilityInstance ability, Entity target) {
        ProjectileData projectileData = (ProjectileData)this.projectileData().value();
        Either<ProjectileData.GenericBallData, ProjectileData.GenericArrowData> specificData = projectileData.typeData();
        float speed = this.speed.calculate(ability.level());
        BiConsumer<Projectile, Float> shootLogic = this.getShootLogic(dragon, target, speed);
        boolean useEntityPosition = this.targetDirection.direction().left().orElse(null) != TargetDirection.Type.TOWARDS_ENTITY;
        specificData.ifLeft(data -> {
            int count = 0;
            while ((float)count < this.numberOfProjectiles.calculate(ability.level())) {
                Vec3 launchPosition;
                if (useEntityPosition) {
                    scale = 1;
                    if (target instanceof Player) {
                        Player player = (Player)target;
                        if (player.getAbilities().flying) {
                            scale = 2;
                        }
                    }
                    launchPosition = target.getLookAngle().scale((double)scale).add(target.getEyePosition());
                } else {
                    scale = dragon.getAbilities().flying ? 2 : 1;
                    launchPosition = dragon.getLookAngle().scale((double)scale).add(dragon.getEyePosition());
                }
                GenericBallEntity projectile = new GenericBallEntity(projectileData.generalData(), (ProjectileData.GenericBallData)data, ability.level(), launchPosition, (Level)dragon.serverLevel());
                projectile.setOwner(target);
                projectile.accelerationPower = 0.0;
                float spread = (float)count * this.projectileSpread.calculate(ability.level());
                shootLogic.accept((Projectile)projectile, Float.valueOf(spread));
                target.level().addFreshEntity((Entity)projectile);
                ++count;
            }
        }).ifRight(data -> {
            int i = 0;
            while ((float)i < this.numberOfProjectiles.calculate(ability.level())) {
                Vec3 launchPosition = useEntityPosition ? new Vec3(target.getX(), target.getEyeY() - (double)0.1f, target.getZ()) : new Vec3(dragon.getX(), dragon.getEyeY() - (double)0.1f, dragon.getZ());
                GenericArrowEntity arrow = new GenericArrowEntity(projectileData.generalData(), (ProjectileData.GenericArrowData)data, ability.level(), launchPosition, (Level)dragon.serverLevel());
                arrow.setOwner(target);
                arrow.pickup = AbstractArrow.Pickup.DISALLOWED;
                float spread = (float)i * this.projectileSpread.calculate(ability.level());
                shootLogic.accept((Projectile)arrow, Float.valueOf(spread));
                target.level().addFreshEntity((Entity)arrow);
                ++i;
            }
        });
    }

    private BiConsumer<Projectile, Float> getShootLogic(ServerPlayer dragon, Entity entity, float speed) {
        BiConsumer<Projectile, Float> shootLogic;
        if (this.targetDirection.direction().left().orElse(null) == TargetDirection.Type.LOOKING_AT) {
            shootLogic = (arrow, spread) -> arrow.shootFromRotation(entity, entity.getXRot(), entity.getYRot(), 0.0f, speed, spread.floatValue());
        } else if (this.targetDirection.direction().right().isPresent()) {
            Direction direction = (Direction)this.targetDirection.direction().right().get();
            shootLogic = (arrow, spread) -> arrow.shoot((double)direction.getStepX(), (double)direction.getStepY(), (double)direction.getStepZ(), speed, spread.floatValue());
        } else {
            shootLogic = (arrow, spread) -> {
                Vec3 target = dragon.position().vectorTo(entity.position());
                arrow.shoot(target.x(), target.y(), target.z(), speed, spread.floatValue());
            };
        }
        return shootLogic;
    }

    @Override
    public List<MutableComponent> getDescription(Player dragon, DragonAbilityInstance ability) {
        List<MutableComponent> effectComponents;
        ArrayList<MutableComponent> components = new ArrayList<MutableComponent>();
        for (ProjectileEntityEffect entityHitEffect : ((ProjectileData)this.projectileData().value()).generalData().entityHitEffects()) {
            effectComponents = entityHitEffect.getDescription(dragon, ability.level());
            components.addAll(effectComponents);
        }
        for (ProjectileBlockEffect blockHitEffect : ((ProjectileData)this.projectileData().value()).generalData().blockHitEffects()) {
            effectComponents = blockHitEffect.getDescription(dragon, ability.level());
            components.addAll(effectComponents);
        }
        for (ProjectileTargeting tickingEffect : ((ProjectileData)this.projectileData().value()).generalData().tickingEffects()) {
            effectComponents = tickingEffect.getAllEffectDescriptions(dragon, ability.level());
            components.addAll(effectComponents);
        }
        for (ProjectileTargeting commonEffect : ((ProjectileData)this.projectileData().value()).generalData().commonHitEffects()) {
            effectComponents = commonEffect.getAllEffectDescriptions(dragon, ability.level());
            components.addAll(effectComponents);
        }
        if (((ProjectileData)this.projectileData().value()).typeData().left().isPresent()) {
            for (ProjectileTargeting onDestroyEffect : ((ProjectileData.GenericBallData)((ProjectileData)this.projectileData().value()).typeData().left().get()).onDestroyEffects()) {
                effectComponents = onDestroyEffect.getAllEffectDescriptions(dragon, ability.level());
                components.addAll(effectComponents);
            }
        }
        if (this.numberOfProjectiles.calculate(ability.level()) > 1.0f) {
            components.add(Component.translatable((String)ABILITY_PROJECTILE_COUNT, (Object[])new Object[]{DSColors.dynamicValue(Float.valueOf(this.numberOfProjectiles.calculate(ability.level())))}));
        }
        if (this.projectileSpread.calculate(ability.level()) > 0.0f) {
            components.add(Component.translatable((String)ABILITY_PROJECTILE_SPREAD, (Object[])new Object[]{DSColors.dynamicValue(Float.valueOf(this.projectileSpread.calculate(ability.level())))}));
        }
        components.add(Component.translatable((String)ABILITY_PROJECTILE_SPEED, (Object[])new Object[]{DSColors.dynamicValue(Float.valueOf(this.speed.calculate(ability.level())))}));
        return components;
    }

    @Override
    public MapCodec<? extends AbilityEntityEffect> entityCodec() {
        return CODEC;
    }
}

