/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.registry.dragon.ability.entity_effects;

import by.dragonsurvivalteam.dragonsurvival.common.codecs.ModifierWithDuration;
import by.dragonsurvivalteam.dragonsurvival.registry.datagen.Translation;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.ability.DragonAbilityInstance;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.ability.entity_effects.AbilityEntityEffect;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;

public record ModifierEffect(List<ModifierWithDuration> modifiers) implements AbilityEntityEffect
{
    @Translation(comments={"\u00a76\u25a0 Attribute modifiers:\u00a7r"})
    public static final String ATTRIBUTE_MODIFIERS = Translation.Type.GUI.wrap("general.attribute_modifiers");
    public static final MapCodec<ModifierEffect> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ModifierWithDuration.CODEC.listOf().fieldOf("modifiers").forGetter(ModifierEffect::modifiers)).apply((Applicative)instance, ModifierEffect::new));

    @Override
    public void apply(ServerPlayer dragon, DragonAbilityInstance ability, Entity target) {
        if (target instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)target;
            this.modifiers.forEach(modifier -> modifier.apply(dragon, ability, (Entity)livingEntity));
        }
    }

    @Override
    public void remove(ServerPlayer dragon, DragonAbilityInstance ability, Entity entity, boolean isAutoRemoval) {
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            this.modifiers.forEach(modifier -> {
                if (!isAutoRemoval || modifier.shouldRemoveAutomatically()) {
                    modifier.remove((Entity)livingEntity);
                }
            });
        }
    }

    @Override
    public List<MutableComponent> getDescription(Player dragon, DragonAbilityInstance ability) {
        MutableComponent description = null;
        for (ModifierWithDuration modifier : this.modifiers) {
            MutableComponent modifierDescription = modifier.getDescription(ability.level());
            if (description == null) {
                description = modifierDescription;
                continue;
            }
            if (modifierDescription == null) continue;
            description.append((Component)modifierDescription);
        }
        if (description != null) {
            description = Component.translatable((String)ATTRIBUTE_MODIFIERS).append(description);
        }
        return description == null ? List.of() : List.of(description);
    }

    public static List<AbilityEntityEffect> only(ModifierWithDuration modifier) {
        return List.of(new ModifierEffect(List.of(modifier)));
    }

    public static AbilityEntityEffect single(ModifierWithDuration modifier) {
        return new ModifierEffect(List.of(modifier));
    }

    @Override
    public MapCodec<? extends AbilityEntityEffect> entityCodec() {
        return CODEC;
    }
}

