/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.registry.dragon.ability.entity_effects;

import by.dragonsurvivalteam.dragonsurvival.registry.DSAdvancementTriggers;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.ability.DragonAbilityInstance;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.ability.entity_effects.AbilityEntityEffect;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.random.SimpleWeightedRandomList;
import net.minecraft.util.random.Weight;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.util.random.WeightedRandomList;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.LevelBasedValue;
import org.jetbrains.annotations.NotNull;

public record ItemConversionEffect(List<ItemConversionData> itemConversions, LevelBasedValue probability) implements AbilityEntityEffect
{
    public static final MapCodec<ItemConversionEffect> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ItemConversionData.CODEC.listOf().fieldOf("item_conversions").forGetter(ItemConversionEffect::itemConversions), (App)LevelBasedValue.CODEC.fieldOf("probability").forGetter(ItemConversionEffect::probability)).apply((Applicative)instance, ItemConversionEffect::new));

    @Override
    public void apply(ServerPlayer dragon, DragonAbilityInstance ability, Entity target) {
        if (!(target instanceof ItemEntity)) {
            return;
        }
        ItemEntity itemEntity = (ItemEntity)target;
        if ((double)this.probability.calculate(ability.level()) < dragon.getRandom().nextDouble()) {
            return;
        }
        if (this.itemConversions.isEmpty()) {
            return;
        }
        for (ItemConversionData conversion : this.itemConversions) {
            if (!conversion.predicate().test(itemEntity.getItem())) continue;
            conversion.itemsTo().getRandom(target.getRandom()).ifPresent(item -> {
                DSAdvancementTriggers.CONVERT_ITEM_FROM_ABILITY.get().trigger(dragon, (Holder<Item>)itemEntity.getItem().getItemHolder(), item.item());
                itemEntity.setItem(new ItemStack(item.item(), itemEntity.getItem().getCount()));
            });
            return;
        }
    }

    @Override
    public MapCodec<? extends AbilityEntityEffect> entityCodec() {
        return CODEC;
    }

    public record ItemConversionData(ItemPredicate predicate, WeightedRandomList<ItemTo> itemsTo) {
        public static final Codec<ItemConversionData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ItemPredicate.CODEC.fieldOf("item_predicate").forGetter(ItemConversionData::predicate), (App)SimpleWeightedRandomList.codec(ItemTo.CODEC).fieldOf("items_to").forGetter(ItemConversionData::itemsTo)).apply((Applicative)instance, ItemConversionData::new));
    }

    public record ItemTo(Holder<Item> item, int weight) implements WeightedEntry
    {
        public static final Codec<ItemTo> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BuiltInRegistries.ITEM.holderByNameCodec().fieldOf("item").forGetter(ItemTo::item), (App)Codec.INT.fieldOf("weight").forGetter(ItemTo::weight)).apply((Applicative)instance, ItemTo::new));

        public static ItemTo of(Item item) {
            return ItemTo.of(item, 1);
        }

        public static ItemTo of(Item item, int weight) {
            return new ItemTo((Holder<Item>)item.builtInRegistryHolder(), weight);
        }

        @NotNull
        public Weight getWeight() {
            return Weight.of((int)this.weight);
        }
    }
}

