/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.registry.dragon.ability.entity_effects;

import by.dragonsurvivalteam.dragonsurvival.registry.datagen.Translation;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.ability.DragonAbilityInstance;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.ability.entity_effects.AbilityEntityEffect;
import by.dragonsurvivalteam.dragonsurvival.util.DSColors;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodData;
import net.minecraft.world.item.enchantment.LevelBasedValue;

public record HungerEffect(Optional<LevelBasedValue> hunger, Optional<LevelBasedValue> saturation, Optional<LevelBasedValue> maxSaturation, Optional<LevelBasedValue> conversionRate) implements AbilityEntityEffect
{
    @Translation(comments={"Adds %s food."})
    public static final String ADD_FOOD = Translation.Type.GUI.wrap("hunger.food");
    @Translation(comments={"Adds %s exhaustion."})
    public static final String ADD_EXHAUSTION = Translation.Type.GUI.wrap("hunger.exhaustion");
    @Translation(comments={"Adds %s saturation."})
    public static final String SATURATION = Translation.Type.GUI.wrap("hunger.saturation");
    @Translation(comments={"Converts %s excess hunger to saturation."})
    public static final String CONVERSION_RATE = Translation.Type.GUI.wrap("hunger.conversion_rate");
    @Translation(comments={"You cannot have more than %s saturation from this ability."})
    public static final String MAX_SATURATION = Translation.Type.GUI.wrap("hunger.max_saturation");
    public static final MapCodec<HungerEffect> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)LevelBasedValue.CODEC.optionalFieldOf("hunger_gain").forGetter(HungerEffect::hunger), (App)LevelBasedValue.CODEC.optionalFieldOf("saturation_gain").forGetter(HungerEffect::saturation), (App)LevelBasedValue.CODEC.optionalFieldOf("maximum_saturation").forGetter(HungerEffect::maxSaturation), (App)LevelBasedValue.CODEC.optionalFieldOf("conversion_rate").forGetter(HungerEffect::conversionRate)).apply((Applicative)instance, HungerEffect::new));

    @Override
    public void apply(ServerPlayer dragon, DragonAbilityInstance ability, Entity target) {
        if (target instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)target;
            FoodData foodData = player.getFoodData();
            float hungerValue = this.hunger.map(hun -> Float.valueOf(hun.calculate(ability.level()))).orElse(Float.valueOf(0.0f)).floatValue();
            if (hungerValue > 0.0f) {
                float leftover = (float)foodData.getFoodLevel() + hungerValue - 20.0f;
                foodData.eat((int)hungerValue, 0.0f);
                if (this.conversionRate.isPresent() && leftover > 0.0f) {
                    this.fillSaturationToCap(foodData, ability, foodData.getSaturationLevel() + leftover * this.conversionRate.get().calculate(ability.level()));
                }
            } else if (hungerValue < 0.0f) {
                foodData.addExhaustion(hungerValue * 4.0f);
            }
            this.fillSaturationToCap(foodData, ability, this.saturation.map(sat -> Float.valueOf(sat.calculate(ability.level()))).orElse(Float.valueOf(0.0f)).floatValue());
        }
    }

    private void fillSaturationToCap(FoodData foodData, DragonAbilityInstance ability, float saturation) {
        if (this.maxSaturation.isPresent() && saturation > 0.0f) {
            float cap = this.maxSaturation.get().calculate(ability.level());
            if (foodData.getSaturationLevel() < cap) {
                foodData.setSaturation(Math.min(cap, foodData.getSaturationLevel() + saturation));
            }
        } else {
            foodData.setSaturation(foodData.getSaturationLevel() + saturation);
        }
    }

    @Override
    public List<MutableComponent> getDescription(Player dragon, DragonAbilityInstance ability) {
        MutableComponent description = Component.empty();
        this.hunger.ifPresent(value -> {
            float food = value.calculate(ability.level());
            if (food > 0.0f) {
                description.append((Component)Component.translatable((String)ADD_FOOD, (Object[])new Object[]{DSColors.dynamicValue(Float.valueOf(food))}).append("\n"));
            } else if (food < 0.0f) {
                description.append((Component)Component.translatable((String)ADD_EXHAUSTION, (Object[])new Object[]{DSColors.dynamicValue(Float.valueOf(food * -4.0f))}).append("\n"));
            }
        });
        this.conversionRate.ifPresent(value -> description.append((Component)Component.translatable((String)CONVERSION_RATE, (Object[])new Object[]{DSColors.dynamicValue(Float.valueOf(value.calculate(ability.level())))})).append("\n"));
        this.saturation.ifPresent(value -> description.append((Component)Component.translatable((String)SATURATION, (Object[])new Object[]{DSColors.dynamicValue(Float.valueOf(value.calculate(ability.level())))})).append("\n"));
        this.maxSaturation.ifPresent(value -> description.append((Component)Component.translatable((String)MAX_SATURATION, (Object[])new Object[]{DSColors.dynamicValue(Float.valueOf(value.calculate(ability.level())))})).append("\n"));
        return List.of(description);
    }

    @Override
    public MapCodec<? extends AbilityEntityEffect> entityCodec() {
        return CODEC;
    }
}

