/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.registry.dragon.ability.entity_effects;

import by.dragonsurvivalteam.dragonsurvival.registry.datagen.Translation;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.ability.DragonAbilityInstance;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.ability.entity_effects.AbilityEntityEffect;
import by.dragonsurvivalteam.dragonsurvival.util.DSColors;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.text.NumberFormat;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.enchantment.LevelBasedValue;

public record HealEffect(LevelBasedValue percentage) implements AbilityEntityEffect
{
    @Translation(comments={"\u00a76\u25a0 Heals\u00a7r the target for %s of their maximum health"})
    private static final String HEALS_FOR = Translation.Type.GUI.wrap("heals_for");
    public static final MapCodec<HealEffect> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)LevelBasedValue.CODEC.fieldOf("percentage").forGetter(HealEffect::percentage)).apply((Applicative)instance, HealEffect::new));

    @Override
    public void apply(ServerPlayer dragon, DragonAbilityInstance ability, Entity target) {
        if (!(target instanceof LivingEntity)) {
            return;
        }
        LivingEntity livingTarget = (LivingEntity)target;
        if (livingTarget.getHealth() > 0.0f) {
            livingTarget.heal(livingTarget.getMaxHealth() * this.percentage.calculate(ability.level()));
        } else {
            livingTarget.setHealth(livingTarget.getHealth() + livingTarget.getMaxHealth() * this.percentage.calculate(ability.level()));
        }
    }

    @Override
    public List<MutableComponent> getDescription(Player dragon, DragonAbilityInstance ability) {
        return List.of(Component.translatable((String)HEALS_FOR, (Object[])new Object[]{DSColors.dynamicValue(NumberFormat.getPercentInstance().format(this.percentage.calculate(ability.level())))}));
    }

    @Override
    public MapCodec<? extends AbilityEntityEffect> entityCodec() {
        return CODEC;
    }
}

