/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.registry.dragon.ability.entity_effects;

import by.dragonsurvivalteam.dragonsurvival.common.codecs.HarvestBonus;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.ability.DragonAbilityInstance;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.ability.entity_effects.AbilityEntityEffect;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;

public record HarvestBonusEffect(List<HarvestBonus> bonuses) implements AbilityEntityEffect
{
    public static final MapCodec<HarvestBonusEffect> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)HarvestBonus.CODEC.listOf().fieldOf("harvest_bonuses").forGetter(HarvestBonusEffect::bonuses)).apply((Applicative)instance, HarvestBonusEffect::new));

    @Override
    public void apply(ServerPlayer dragon, DragonAbilityInstance ability, Entity target) {
        if (target instanceof Player) {
            Player player = (Player)target;
            this.bonuses.forEach(bonus -> bonus.apply(dragon, ability, (Entity)player));
        }
    }

    @Override
    public void remove(ServerPlayer dragon, DragonAbilityInstance ability, Entity entity, boolean isAutoRemoval) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            this.bonuses.forEach(bonus -> {
                if (!isAutoRemoval || bonus.shouldRemoveAutomatically()) {
                    bonus.remove((Entity)player);
                }
            });
        }
    }

    @Override
    public List<MutableComponent> getDescription(Player dragon, DragonAbilityInstance ability) {
        ArrayList<MutableComponent> components = new ArrayList<MutableComponent>();
        for (HarvestBonus bonus : this.bonuses) {
            components.add(bonus.getDescription(ability.level()));
        }
        return components;
    }

    public static List<AbilityEntityEffect> only(HarvestBonus bonus) {
        return List.of(new HarvestBonusEffect(List.of(bonus)));
    }

    @Override
    public MapCodec<? extends AbilityEntityEffect> entityCodec() {
        return CODEC;
    }
}

