/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.registry.dragon.ability.entity_effects;

import by.dragonsurvivalteam.dragonsurvival.common.capability.DragonStateProvider;
import by.dragonsurvivalteam.dragonsurvival.network.flight.FlightStatus;
import by.dragonsurvivalteam.dragonsurvival.network.flight.SyncWingIcon;
import by.dragonsurvivalteam.dragonsurvival.registry.attachments.FlightData;
import by.dragonsurvivalteam.dragonsurvival.registry.datagen.Translation;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.ability.DragonAbilityInstance;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.ability.entity_effects.AbilityEntityEffect;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.PacketDistributor;

public record FlightEffect(int levelRequirement, ResourceLocation icon) implements AbilityEntityEffect
{
    @Translation(comments={"\u00a76\u25a0 Can use flight"})
    private static final String FLIGHT = Translation.Type.GUI.wrap("flight_effect.flight");
    public static final MapCodec<FlightEffect> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.INT.fieldOf("level_requirement").forGetter(FlightEffect::levelRequirement), (App)ResourceLocation.CODEC.optionalFieldOf("icon", (Object)FlightData.DEFAULT_ICON).forGetter(FlightEffect::icon)).apply((Applicative)instance, FlightEffect::new));

    @Override
    public void apply(ServerPlayer dragon, DragonAbilityInstance ability, Entity target) {
        ServerPlayer serverTarget;
        if (!(target instanceof ServerPlayer) || !DragonStateProvider.isDragon((Entity)(serverTarget = (ServerPlayer)target))) {
            return;
        }
        FlightData data = FlightData.getData((Player)serverTarget);
        boolean hadFlight = data.hasFlight;
        boolean bl = data.hasFlight = ability.level() >= this.levelRequirement;
        if (hadFlight != data.hasFlight) {
            PacketDistributor.sendToPlayersTrackingEntityAndSelf((Entity)serverTarget, (CustomPacketPayload)new FlightStatus(serverTarget.getId(), data.hasFlight), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
        if (data.icon == null || !data.icon.equals((Object)this.icon)) {
            data.icon = this.icon;
            PacketDistributor.sendToPlayer((ServerPlayer)serverTarget, (CustomPacketPayload)new SyncWingIcon(this.icon), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    @Override
    public void remove(ServerPlayer dragon, DragonAbilityInstance ability, Entity target, boolean isAutoRemoval) {
        ServerPlayer serverTarget;
        if (isAutoRemoval) {
            return;
        }
        if (!(target instanceof ServerPlayer) || !DragonStateProvider.isDragon((Entity)(serverTarget = (ServerPlayer)target))) {
            return;
        }
        FlightData data = FlightData.getData((Player)serverTarget);
        boolean hadFlight = data.hasFlight;
        data.hasFlight = false;
        if (hadFlight != data.hasFlight) {
            PacketDistributor.sendToPlayersTrackingEntityAndSelf((Entity)serverTarget, (CustomPacketPayload)new FlightStatus(serverTarget.getId(), data.hasFlight), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    @Override
    public List<MutableComponent> getDescription(Player dragon, DragonAbilityInstance ability) {
        ArrayList<MutableComponent> components = new ArrayList<MutableComponent>();
        if (ability.level() >= this.levelRequirement) {
            components.add(Component.translatable((String)FLIGHT));
        }
        return components;
    }

    @Override
    public MapCodec<? extends AbilityEntityEffect> entityCodec() {
        return CODEC;
    }
}

