/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.registry.dragon.ability.entity_effects;

import by.dragonsurvivalteam.dragonsurvival.common.capability.DragonStateHandler;
import by.dragonsurvivalteam.dragonsurvival.common.capability.DragonStateProvider;
import by.dragonsurvivalteam.dragonsurvival.common.codecs.MiscCodecs;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.ability.DragonAbilityInstance;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.ability.entity_effects.AbilityEntityEffect;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.stage.DragonStage;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.enchantment.LevelBasedValue;
import org.jetbrains.annotations.NotNull;

public record DragonGrowthEffect(GrowthType growth_type, ActionType action_type, LevelBasedValue amount, LevelBasedValue probability) implements AbilityEntityEffect
{
    public static final MapCodec<DragonGrowthEffect> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)GrowthType.CODEC.fieldOf("growth_type").forGetter(DragonGrowthEffect::growth_type), (App)ActionType.CODEC.fieldOf("action_type").forGetter(DragonGrowthEffect::action_type), (App)LevelBasedValue.CODEC.fieldOf("amount").forGetter(DragonGrowthEffect::amount), (App)LevelBasedValue.CODEC.fieldOf("probability").forGetter(DragonGrowthEffect::probability)).apply((Applicative)instance, DragonGrowthEffect::new));

    @Override
    public void apply(ServerPlayer dragon, DragonAbilityInstance ability, Entity target) {
        if (target instanceof Player) {
            double amount;
            Player player = (Player)target;
            DragonStateHandler handler = DragonStateProvider.getData(player);
            if (!handler.isDragon()) {
                return;
            }
            if (dragon.getRandom().nextDouble() > (double)this.probability().calculate(ability.level())) {
                return;
            }
            double difference = amount = (double)this.amount().calculate(ability.level());
            double base = 0.0;
            if (this.growth_type == GrowthType.ADD) {
                base = handler.getGrowth();
            }
            if (this.action_type == ActionType.PERCENT) {
                MiscCodecs.Bounds growthRange = ((DragonStage)handler.stage().value()).growthRange();
                double maxGrowth = growthRange.max();
                double minGrowth = growthRange.min();
                difference = amount * (maxGrowth - minGrowth);
                if (this.growth_type == GrowthType.SET) {
                    base = minGrowth;
                }
            }
            handler.setDesiredGrowth(player, base + difference);
        }
    }

    @Override
    public MapCodec<? extends AbilityEntityEffect> entityCodec() {
        return CODEC;
    }

    public static enum GrowthType implements StringRepresentable
    {
        SET("set"),
        ADD("add");

        public static final Codec<GrowthType> CODEC;
        private final String name;

        private GrowthType(String name) {
            this.name = name;
        }

        @NotNull
        public String getSerializedName() {
            return this.name;
        }

        static {
            CODEC = StringRepresentable.fromEnum(GrowthType::values);
        }
    }

    public static enum ActionType implements StringRepresentable
    {
        PERCENT("percent"),
        FLAT("flat");

        public static final Codec<ActionType> CODEC;
        private final String name;

        private ActionType(String name) {
            this.name = name;
        }

        @NotNull
        public String getSerializedName() {
            return this.name;
        }

        static {
            CODEC = StringRepresentable.fromEnum(ActionType::values);
        }
    }
}

