/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.registry.dragon.ability.entity_effects;

import by.dragonsurvivalteam.dragonsurvival.registry.DSAttributes;
import by.dragonsurvivalteam.dragonsurvival.registry.datagen.Translation;
import by.dragonsurvivalteam.dragonsurvival.registry.datagen.lang.LangKey;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.ability.DragonAbilityInstance;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.ability.entity_effects.AbilityEntityEffect;
import by.dragonsurvivalteam.dragonsurvival.util.DSColors;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.enchantment.LevelBasedValue;

public record DamageEffect(Holder<DamageType> damageType, LevelBasedValue amount) implements AbilityEntityEffect
{
    public static final MapCodec<DamageEffect> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)DamageType.CODEC.fieldOf("damage_type").forGetter(DamageEffect::damageType), (App)LevelBasedValue.CODEC.fieldOf("amount").forGetter(DamageEffect::amount)).apply((Applicative)instance, DamageEffect::new));

    @Override
    public void apply(ServerPlayer dragon, DragonAbilityInstance ability, Entity target) {
        float damageAmount = this.amount().calculate(ability.level());
        target.hurt(new DamageSource(this.damageType, (Entity)dragon), damageAmount *= (float)dragon.getAttributeValue(DSAttributes.DRAGON_ABILITY_DAMAGE));
        dragon.setLastHurtMob(target);
    }

    @Override
    public List<MutableComponent> getDescription(Player dragon, DragonAbilityInstance ability) {
        MutableComponent damageType = Component.translatable((String)Translation.Type.DAMAGE_TYPE.wrap(this.damageType.getKey().location()));
        float damage = this.amount.calculate(ability.level());
        MutableComponent abilityDamage = Component.translatable((String)LangKey.ABILITY_DAMAGE, (Object[])new Object[]{DSColors.dynamicValue(Float.valueOf(damage)), DSColors.dynamicValue(damageType)});
        float additionalDamage = damage * (float)dragon.getAttributeValue(DSAttributes.DRAGON_ABILITY_DAMAGE) - damage;
        if (additionalDamage != 0.0f) {
            abilityDamage.append((Component)Component.translatable((String)LangKey.ABILITY_ADDITIONAL_DAMAGE, (Object[])new Object[]{DSColors.dynamicValue(Float.valueOf(additionalDamage))}));
        }
        return List.of(abilityDamage);
    }

    @Override
    public MapCodec<? extends AbilityEntityEffect> entityCodec() {
        return CODEC;
    }
}

