/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.registry.dragon.ability.common_effects;

import by.dragonsurvivalteam.dragonsurvival.DragonSurvival;
import by.dragonsurvivalteam.dragonsurvival.common.codecs.ModifierType;
import by.dragonsurvivalteam.dragonsurvival.common.codecs.duration_instance.CommonData;
import by.dragonsurvivalteam.dragonsurvival.common.codecs.duration_instance.DurationInstance;
import by.dragonsurvivalteam.dragonsurvival.common.codecs.duration_instance.DurationInstanceBase;
import by.dragonsurvivalteam.dragonsurvival.common.entity.goals.FollowSummonerGoal;
import by.dragonsurvivalteam.dragonsurvival.common.entity.goals.SummonerHurtByTargetGoal;
import by.dragonsurvivalteam.dragonsurvival.common.entity.goals.SummonerHurtTargetGoal;
import by.dragonsurvivalteam.dragonsurvival.mixins.PrimedTntAccess;
import by.dragonsurvivalteam.dragonsurvival.network.magic.SyncSummonedEntity;
import by.dragonsurvivalteam.dragonsurvival.registry.attachments.DSDataAttachments;
import by.dragonsurvivalteam.dragonsurvival.registry.attachments.SummonData;
import by.dragonsurvivalteam.dragonsurvival.registry.attachments.SummonedEntities;
import by.dragonsurvivalteam.dragonsurvival.registry.datagen.Translation;
import by.dragonsurvivalteam.dragonsurvival.registry.datagen.lang.LangKey;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.ability.DragonAbilityInstance;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.ability.block_effects.AbilityBlockEffect;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.ability.entity_effects.AbilityEntityEffect;
import by.dragonsurvivalteam.dragonsurvival.util.DSColors;
import by.dragonsurvivalteam.dragonsurvival.util.Functions;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.core.UUIDUtil;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.random.SimpleWeightedRandomList;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.util.random.WeightedRandom;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.enchantment.LevelBasedValue;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.network.PacketDistributor;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SummonEntityEffect
extends DurationInstanceBase<SummonedEntities, Instance>
implements AbilityEntityEffect,
AbilityBlockEffect {
    @Translation(comments={"\u00a76\u25a0 Summon\u00a7r up to %s entities:"})
    private static final String SUMMON = Translation.Type.GUI.wrap("summon_entity_effect.summon");
    @Translation(comments={"\n- %s (%s)"})
    private static final String SUMMON_CHANCE = Translation.Type.GUI.wrap("summon_entity_effect.summon_chance");
    @Translation(comments={"Currently summoned: %s / %s"})
    private static final String CURRENT_AMOUNT = Translation.Type.GUI.wrap("summon_entity_effect.current_amount");
    public static final MapCodec<SummonEntityEffect> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)DurationInstanceBase.CODEC.fieldOf("base").forGetter(identity -> identity), (App)Codec.either((Codec)SimpleWeightedRandomList.wrappedCodec((Codec)BuiltInRegistries.ENTITY_TYPE.byNameCodec()), (Codec)RegistryCodecs.homogeneousList((ResourceKey)Registries.ENTITY_TYPE)).fieldOf("entities").forGetter(SummonEntityEffect::entities), (App)LevelBasedValue.CODEC.fieldOf("max_summons").forGetter(SummonEntityEffect::maxSummons), (App)AttributeScale.CODEC.listOf().optionalFieldOf("attribute_scales", List.of()).forGetter(SummonEntityEffect::attributeScales), (App)Codec.BOOL.optionalFieldOf("is_allied", (Object)true).forGetter(SummonEntityEffect::isAllied)).apply((Applicative)instance, SummonEntityEffect::new));
    private final Either<SimpleWeightedRandomList<EntityType<?>>, HolderSet<EntityType<?>>> entities;
    private final LevelBasedValue maxSummons;
    private final List<AttributeScale> attributeScales;
    private final boolean isAllied;

    public SummonEntityEffect(DurationInstanceBase<?, ?> base, Either<SimpleWeightedRandomList<EntityType<?>>, HolderSet<EntityType<?>>> entities, LevelBasedValue maxSummons, List<AttributeScale> attributeScales, boolean isAllied) {
        super(base);
        this.entities = entities;
        this.maxSummons = maxSummons;
        this.attributeScales = attributeScales;
        this.isAllied = isAllied;
    }

    @Override
    public void apply(ServerPlayer dragon, DragonAbilityInstance ability, BlockPos position, @Nullable Direction direction) {
        this.collectPosition(dragon, ability, position);
    }

    @Override
    public void apply(ServerPlayer dragon, DragonAbilityInstance ability, Entity target) {
        this.collectPosition(dragon, ability, target.blockPosition());
    }

    private void collectPosition(ServerPlayer dragon, DragonAbilityInstance ability, BlockPos spawnPosition) {
        SummonedEntities summonData = (SummonedEntities)dragon.getData(DSDataAttachments.SUMMONED_ENTITIES);
        Instance instance = (Instance)summonData.get(this.id());
        if (instance != null && instance.hasEntities()) {
            summonData.remove((Entity)dragon, instance);
            instance = null;
        }
        if (!Level.isInSpawnableBounds((BlockPos)spawnPosition)) {
            return;
        }
        if (instance == null) {
            instance = this.createInstance(dragon, ability, (int)this.duration().calculate(ability.level()));
            summonData.add((Entity)dragon, instance);
        }
        instance.addPosition(spawnPosition.immutable());
    }

    @Override
    public List<MutableComponent> getDescription(Player dragon, DragonAbilityInstance ability) {
        MutableComponent component = Component.translatable((String)SUMMON, (Object[])new Object[]{DSColors.dynamicValue(Float.valueOf(this.maxSummons.calculate(ability.level())))});
        this.entities.ifLeft(list -> {
            int totalWeight = WeightedRandom.getTotalWeight((List)list.unwrap());
            list.unwrap().forEach(wrapper -> {
                MutableComponent entityName = DSColors.dynamicValue(((EntityType)wrapper.data()).getDescription());
                double chance = (double)wrapper.getWeight().asInt() / (double)totalWeight;
                component.append((Component)Component.translatable((String)SUMMON_CHANCE, (Object[])new Object[]{DSColors.dynamicValue(entityName), DSColors.dynamicValue(NumberFormat.getPercentInstance().format(chance))}));
            });
            if (!list.isEmpty()) {
                component.append((Component)Component.literal((String)"\n"));
            }
        }).ifRight(set -> {
            int totalWeight = set.size();
            set.forEach(type -> {
                MutableComponent entityName = DSColors.dynamicValue(((EntityType)type.value()).getDescription());
                double chance = 1.0 / (double)totalWeight;
                component.append((Component)Component.translatable((String)SUMMON_CHANCE, (Object[])new Object[]{DSColors.dynamicValue(entityName), DSColors.dynamicValue(NumberFormat.getPercentInstance().format(chance))}));
            });
            if (set.size() > 0) {
                component.append((Component)Component.literal((String)"\n"));
            }
        });
        float duration = this.duration().calculate(ability.level());
        if (duration != -1.0f) {
            component.append((Component)Component.translatable((String)LangKey.ABILITY_EFFECT_DURATION, (Object[])new Object[]{DSColors.dynamicValue(Functions.ticksToSeconds((int)duration))}));
        }
        return List.of(component);
    }

    @Override
    public Instance createInstance(ServerPlayer dragon, DragonAbilityInstance ability, int currentDuration) {
        return new Instance(this, CommonData.from(this.id(), dragon, ability, this.customIcon(), this.shouldRemoveAutomatically()), currentDuration, new CopyOnWriteArrayList<UUID>());
    }

    @Override
    public AttachmentType<SummonedEntities> type() {
        return (AttachmentType)DSDataAttachments.SUMMONED_ENTITIES.value();
    }

    public Either<SimpleWeightedRandomList<EntityType<?>>, HolderSet<EntityType<?>>> entities() {
        return this.entities;
    }

    public LevelBasedValue maxSummons() {
        return this.maxSummons;
    }

    public List<AttributeScale> attributeScales() {
        return this.attributeScales;
    }

    public boolean isAllied() {
        return this.isAllied;
    }

    @Override
    public MapCodec<? extends AbilityBlockEffect> blockCodec() {
        return CODEC;
    }

    @Override
    public MapCodec<? extends AbilityEntityEffect> entityCodec() {
        return CODEC;
    }

    public static class Instance
    extends DurationInstance<SummonEntityEffect> {
        public static final Codec<Instance> CODEC = RecordCodecBuilder.create(instance -> DurationInstance.codecStart(instance, () -> CODEC.codec()).and((App)UUIDUtil.CODEC.listOf().xmap(CopyOnWriteArrayList::new, Function.identity()).fieldOf("entity_uuid").forGetter(Instance::entityUUIDs)).apply((Applicative)instance, Instance::new));
        private final CopyOnWriteArrayList<UUID> entityUUIDs;
        private List<BlockPos> positions;

        public Instance(SummonEntityEffect baseData, CommonData commonData, int currentDuration, CopyOnWriteArrayList<UUID> entityUUIDs) {
            super(baseData, commonData, currentDuration);
            this.entityUUIDs = entityUUIDs;
        }

        public void addPosition(BlockPos position) {
            if (this.positions == null) {
                this.positions = new ArrayList<BlockPos>();
            }
            this.positions.add(position);
        }

        public boolean hasEntities() {
            return !this.entityUUIDs.isEmpty();
        }

        public boolean removeSummon(Entity summon) {
            boolean removed = this.entityUUIDs.remove(summon.getUUID());
            if (!removed) {
                return false;
            }
            return this.entityUUIDs.isEmpty();
        }

        public boolean initializeSummons(ServerPlayer storageHolder) {
            if (this.positions == null || this.positions.isEmpty()) {
                return false;
            }
            int maxSummons = (int)((SummonEntityEffect)this.baseData()).maxSummons().calculate(this.appliedAbilityLevel());
            if (maxSummons == 0) {
                return false;
            }
            SummonedEntities summonData = (SummonedEntities)storageHolder.getData(DSDataAttachments.SUMMONED_ENTITIES);
            BlockPos spawnPosition = null;
            while (!this.positions.isEmpty() && this.entityUUIDs.size() < maxSummons) {
                spawnPosition = this.positions.remove(storageHolder.getRandom().nextInt(this.positions.size()));
                this.summon(storageHolder, spawnPosition, summonData);
            }
            for (int attempt = 0; attempt < maxSummons - this.entityUUIDs.size(); ++attempt) {
                this.summon(storageHolder, spawnPosition, summonData);
            }
            this.positions = null;
            return !this.entityUUIDs.isEmpty();
        }

        private void summon(ServerPlayer storageHolder, BlockPos spawnPosition, SummonedEntities summonData) {
            EntityType type = (EntityType)((SummonEntityEffect)this.baseData()).entities().map(list -> list.getRandom(storageHolder.getRandom()).map(WeightedEntry.Wrapper::data).orElse(null), set -> set.getRandomElement(storageHolder.getRandom()).map(Holder::value).orElse(null));
            if (type == null) {
                return;
            }
            BlockState state = storageHolder.level().getBlockState(spawnPosition);
            if (!state.blocksMotion()) {
                return;
            }
            int i = 1;
            while ((float)i <= Math.max(1.0f, type.getHeight())) {
                if (!storageHolder.level().getBlockState(spawnPosition.above(i)).isAir()) {
                    return;
                }
                ++i;
            }
            Entity entity = type.spawn(storageHolder.serverLevel(), spawnPosition.above(), MobSpawnType.TRIGGERED);
            if (entity == null) {
                return;
            }
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                ((SummonEntityEffect)this.baseData()).attributeScales().forEach(attributeScale -> attributeScale.apply(livingEntity, this.appliedAbilityLevel()));
            }
            if (entity instanceof Projectile) {
                Projectile projectile = (Projectile)entity;
                projectile.setOwner((Entity)storageHolder);
            }
            if (entity instanceof LightningBolt) {
                LightningBolt bolt = (LightningBolt)entity;
                bolt.setCause(storageHolder);
            }
            if (entity instanceof PrimedTntAccess) {
                PrimedTntAccess access = (PrimedTntAccess)entity;
                access.dragonSurvival$setOwner((LivingEntity)storageHolder);
            }
            this.setAllied(storageHolder, entity);
            SummonData summon = (SummonData)entity.getData(DSDataAttachments.SUMMON);
            summon.setOwnerUUID((LivingEntity)storageHolder);
            summon.isAllied = ((SummonEntityEffect)this.baseData()).isAllied();
            summon.attackBehaviour = summonData.attackBehaviour;
            summon.movementBehaviour = summonData.movementBehaviour;
            this.entityUUIDs.add(entity.getUUID());
        }

        private void setAllied(ServerPlayer dragon, Entity entity) {
            if (!((SummonEntityEffect)this.baseData()).isAllied()) {
                return;
            }
            if (entity instanceof TamableAnimal) {
                TamableAnimal tamable = (TamableAnimal)entity;
                tamable.setOwnerUUID(dragon.getUUID());
                tamable.setTame(true, true);
            }
            if (dragon.getTeam() != null) {
                dragon.level().getScoreboard().addPlayerToTeam(entity.getScoreboardName(), dragon.getTeam());
            }
            if (entity instanceof Mob) {
                Mob mob = (Mob)entity;
                mob.goalSelector.addGoal(1, (Goal)new SummonerHurtByTargetGoal(mob));
                mob.goalSelector.addGoal(2, (Goal)new SummonerHurtTargetGoal(mob));
                mob.goalSelector.addGoal(3, (Goal)new FollowSummonerGoal(mob, 1.0, 10.0f, 2.0f));
            }
        }

        @Override
        public Component getDescription() {
            MutableComponent current = DSColors.dynamicValue(this.entityUUIDs.size());
            MutableComponent max = DSColors.dynamicValue((int)((SummonEntityEffect)this.baseData()).maxSummons().calculate(this.appliedAbilityLevel()));
            return Component.translatable((String)CURRENT_AMOUNT, (Object[])new Object[]{current, max});
        }

        @Override
        public void onAddedToStorage(Entity storageHolder) {
            if (storageHolder instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)storageHolder;
                PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new SyncSummonedEntity(this, false), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }

        @Override
        public void onRemovalFromStorage(Entity storageHolder) {
            Level level = storageHolder.level();
            if (!(level instanceof ServerLevel)) {
                return;
            }
            ServerLevel serverLevel = (ServerLevel)level;
            this.entityUUIDs.forEach(uuid -> {
                for (ServerLevel level : serverLevel.getServer().getAllLevels()) {
                    Entity summonedEntity = level.getEntity(uuid);
                    if (summonedEntity == null) continue;
                    ((SummonData)summonedEntity.getData(DSDataAttachments.SUMMON)).setOwnerUUID(null);
                    summonedEntity.discard();
                    break;
                }
            });
            if (storageHolder instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)storageHolder;
                PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new SyncSummonedEntity(this, true), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }

        public Tag save(@NotNull HolderLookup.Provider provider) {
            return (Tag)CODEC.encodeStart((DynamicOps)provider.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)this).getOrThrow();
        }

        @Nullable
        public static Instance load(@NotNull HolderLookup.Provider provider, CompoundTag nbt) {
            return CODEC.parse((DynamicOps)provider.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)nbt).resultOrPartial(arg_0 -> ((Logger)DragonSurvival.LOGGER).error(arg_0)).orElse(null);
        }

        public CopyOnWriteArrayList<UUID> entityUUIDs() {
            return this.entityUUIDs;
        }
    }

    public record AttributeScale(HolderSet<Attribute> attributes, LevelBasedValue scale) {
        public static final Codec<AttributeScale> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)RegistryCodecs.homogeneousList((ResourceKey)Registries.ATTRIBUTE).fieldOf("attributes").forGetter(AttributeScale::attributes), (App)LevelBasedValue.CODEC.fieldOf("scale").forGetter(AttributeScale::scale)).apply((Applicative)instance, AttributeScale::new));

        public void apply(LivingEntity entity, int abilityLevel) {
            float scale = this.scale.calculate(abilityLevel);
            for (Holder attribute : this.attributes) {
                AttributeInstance instance = entity.getAttribute(attribute);
                if (instance != null) {
                    ResourceLocation id = ModifierType.CUSTOM.randomId((Holder<Attribute>)attribute, AttributeModifier.Operation.ADD_MULTIPLIED_BASE, entity.getRandom());
                    instance.addPermanentModifier(new AttributeModifier(id, (double)scale, AttributeModifier.Operation.ADD_MULTIPLIED_BASE));
                }
                if (attribute != Attributes.MAX_HEALTH) continue;
                entity.setHealth(entity.getMaxHealth());
            }
        }
    }
}

