/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.registry.dragon.ability.activation.trigger;

import by.dragonsurvivalteam.dragonsurvival.common.capability.DragonStateHandler;
import by.dragonsurvivalteam.dragonsurvival.common.capability.DragonStateProvider;
import by.dragonsurvivalteam.dragonsurvival.common.codecs.Condition;
import by.dragonsurvivalteam.dragonsurvival.registry.attachments.MagicData;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.ability.activation.trigger.ActivationTrigger;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;

public record OnTargetHit(Optional<LootItemCondition> condition) implements ActivationTrigger
{
    public static final MapCodec<OnTargetHit> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)LootItemCondition.DIRECT_CODEC.optionalFieldOf("condition").forGetter(OnTargetHit::condition)).apply((Applicative)instance, OnTargetHit::new));

    public static void trigger(LivingDamageEvent.Post event) {
        Entity entity = event.getSource().getEntity();
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            DragonStateHandler handler = DragonStateProvider.getData((Player)player);
            if (!handler.isDragon()) {
                return;
            }
            LootContext context = Condition.damageContext(player.serverLevel(), (Entity)event.getEntity(), event.getSource(), player.getMainHandItem());
            MagicData.getData((Player)player).filterPassiveByTrigger(trigger -> trigger.type() == ActivationTrigger.TriggerType.ON_TARGET_HIT && trigger.test(context)).forEach(ability -> ability.tick((Player)player));
        }
    }

    @Override
    public boolean test(LootContext context) {
        return this.condition.map(condition -> condition.test((Object)context)).orElse(true);
    }

    @Override
    public ActivationTrigger.TriggerType type() {
        return ActivationTrigger.TriggerType.ON_TARGET_HIT;
    }

    @Override
    public MapCodec<? extends ActivationTrigger> codec() {
        return CODEC;
    }
}

