/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.registry.dragon.ability.activation.trigger;

import by.dragonsurvivalteam.dragonsurvival.common.capability.DragonStateHandler;
import by.dragonsurvivalteam.dragonsurvival.common.capability.DragonStateProvider;
import by.dragonsurvivalteam.dragonsurvival.registry.attachments.MagicData;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.ability.activation.trigger.ActivationTrigger;
import com.mojang.serialization.MapCodec;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;

public record OnDeath() implements ActivationTrigger
{
    public static final OnDeath INSTANCE = new OnDeath();
    public static final MapCodec<OnDeath> CODEC = MapCodec.unit((Object)INSTANCE);

    public static void trigger(LivingDeathEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)livingEntity;
            DragonStateHandler handler = DragonStateProvider.getData((Player)player);
            if (!handler.isDragon()) {
                return;
            }
            float previousHealth = player.getHealth();
            MagicData.getData((Player)player).filterPassiveByTrigger(trigger -> trigger.type() == ActivationTrigger.TriggerType.ON_DEATH).forEach(ability -> ability.tick((Player)player));
            if (previousHealth <= 0.0f && player.getHealth() > 0.0f) {
                event.setCanceled(true);
            }
        }
    }

    @Override
    public ActivationTrigger.TriggerType type() {
        return ActivationTrigger.TriggerType.ON_DEATH;
    }

    @Override
    public MapCodec<? extends ActivationTrigger> codec() {
        return CODEC;
    }
}

