/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.registry.dragon.ability.activation.trigger;

import by.dragonsurvivalteam.dragonsurvival.common.capability.DragonStateHandler;
import by.dragonsurvivalteam.dragonsurvival.common.capability.DragonStateProvider;
import by.dragonsurvivalteam.dragonsurvival.common.codecs.Condition;
import by.dragonsurvivalteam.dragonsurvival.registry.attachments.MagicData;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.ability.activation.trigger.ActivationTrigger;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.neoforged.neoforge.common.util.Lazy;
import net.neoforged.neoforge.event.level.BlockEvent;

public record OnBlockBreak(Optional<LootItemCondition> condition) implements ActivationTrigger
{
    public static final MapCodec<OnBlockBreak> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)LootItemCondition.DIRECT_CODEC.optionalFieldOf("condition").forGetter(OnBlockBreak::condition)).apply((Applicative)instance, OnBlockBreak::new));

    public static void trigger(BlockEvent.BreakEvent event) {
        Player player = event.getPlayer();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            DragonStateHandler handler = DragonStateProvider.getData((Player)player2);
            if (!handler.isDragon()) {
                return;
            }
            AtomicBoolean triggeredAbility = new AtomicBoolean(false);
            Lazy context = Lazy.of(() -> Condition.blockContext(player2, event.getPos(), event.getState()));
            MagicData.getData((Player)player2).filterPassiveByTrigger(trigger -> trigger.type() == ActivationTrigger.TriggerType.ON_BLOCK_BREAK && trigger.test((LootContext)context.get())).forEach(ability -> {
                ability.tick((Player)player2);
                triggeredAbility.set(true);
            });
            if (triggeredAbility.get() && player2.level().getBlockState(event.getPos()) != event.getState()) {
                event.setCanceled(true);
            }
        }
    }

    @Override
    public boolean test(LootContext context) {
        return this.condition.map(condition -> condition.test((Object)context)).orElse(true);
    }

    @Override
    public ActivationTrigger.TriggerType type() {
        return ActivationTrigger.TriggerType.ON_BLOCK_BREAK;
    }

    @Override
    public MapCodec<? extends ActivationTrigger> codec() {
        return CODEC;
    }
}

