/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.registry.dragon.ability;

import by.dragonsurvivalteam.dragonsurvival.DragonSurvival;
import by.dragonsurvivalteam.dragonsurvival.client.gui.hud.MagicHUD;
import by.dragonsurvivalteam.dragonsurvival.common.codecs.Condition;
import by.dragonsurvivalteam.dragonsurvival.common.codecs.ability.ManaCost;
import by.dragonsurvivalteam.dragonsurvival.common.handlers.magic.ManaHandler;
import by.dragonsurvivalteam.dragonsurvival.network.magic.SyncDisableAbility;
import by.dragonsurvivalteam.dragonsurvival.registry.attachments.MagicData;
import by.dragonsurvivalteam.dragonsurvival.registry.datagen.Translation;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.ability.DragonAbility;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.ability.activation.Activation;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.ability.activation.PassiveActivation;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.ability.activation.trigger.ActivationTrigger;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.contents.PlainTextContents;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.PacketDistributor;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DragonAbilityInstance {
    public static final int MIN_LEVEL = 0;
    public static final int MIN_LEVEL_FOR_CALCULATIONS = 1;
    public static final int MAX_LEVEL = 255;
    public static final int NO_COOLDOWN = 0;
    public static final Codec<DragonAbilityInstance> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)DragonAbility.CODEC.fieldOf("ability").forGetter(DragonAbilityInstance::ability), (App)Codec.INT.fieldOf("level").forGetter(DragonAbilityInstance::level), (App)Codec.BOOL.optionalFieldOf("is_manually_disabled", (Object)false).forGetter(ability -> ability.isManuallyDisabled)).apply((Applicative)instance, DragonAbilityInstance::new));
    private final Holder<DragonAbility> ability;
    private int level;
    private boolean isManuallyDisabled;
    private boolean isAutomaticallyDisabled;
    private boolean isActive;
    private int currentTick;
    private int cooldown;

    public DragonAbilityInstance(Holder<DragonAbility> ability, int level) {
        this(ability, level, false);
    }

    public DragonAbilityInstance(Holder<DragonAbility> ability, int level, boolean isManuallyDisabled) {
        this.ability = ability;
        this.level = level;
        this.isManuallyDisabled = isManuallyDisabled;
        if (this.isEnabled() && this.isPassive()) {
            this.isActive = true;
        }
    }

    public Tag save(@NotNull HolderLookup.Provider provider) {
        return (Tag)CODEC.encodeStart((DynamicOps)provider.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)this).getOrThrow();
    }

    @Nullable
    public static DragonAbilityInstance load(@NotNull HolderLookup.Provider provider, CompoundTag nbt) {
        return CODEC.parse((DynamicOps)provider.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)nbt).resultOrPartial(arg_0 -> ((Logger)DragonSurvival.LOGGER).error(arg_0)).orElse(null);
    }

    public void tick(Player dragon) {
        if (dragon instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)dragon;
            boolean isAutomaticallyDisabled = this.value().usageBlocked().map(condition -> condition.test((Object)Condition.abilityContext(serverPlayer))).orElse(false);
            if (isAutomaticallyDisabled && !this.isAutomaticallyDisabled) {
                this.setDisabled((Player)serverPlayer, true, false);
                PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new SyncDisableAbility((ResourceKey<DragonAbility>)this.ability.getKey(), true, false), (CustomPacketPayload[])new CustomPacketPayload[0]);
            } else if (!isAutomaticallyDisabled && (this.isAutomaticallyDisabled || this.isPassive() && !this.isActive && !this.isManuallyDisabled)) {
                this.setDisabled((Player)serverPlayer, false, false);
                PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new SyncDisableAbility((ResourceKey<DragonAbility>)this.ability.getKey(), false, false), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }
        if (this.isActive && this.canBeCast()) {
            this.tickActions(dragon);
        }
    }

    public void queueTickingSound(SoundEvent soundEvent, SoundSource soundSource, Player dragon) {
        DragonSurvival.PROXY.queueTickingSound(this.location().withSuffix(dragon.getStringUUID()), soundEvent, soundSource, (Entity)dragon);
    }

    public void stopSound(Player dragon) {
        DragonSurvival.PROXY.stopTickingSound(this.location().withSuffix(dragon.getStringUUID()));
    }

    private void tickActions(Player dragon) {
        int castTime = this.value().activation().getCastTime(this.level);
        ++this.currentTick;
        if (this.currentTick < castTime) {
            if (this.currentTick == 1) {
                this.value().activation().playChargingSound(dragon, this);
                this.value().activation().playStartAndChargingAnimation(dragon);
            }
            return;
        }
        if (this.currentTick == castTime) {
            this.value().activation().playStartAndLoopingSound(dragon, this);
            this.value().activation().playLoopingAnimation(dragon);
        }
        if (this.currentTick < castTime) {
            return;
        }
        if (this.currentTick == castTime) {
            ManaHandler.consumeMana(dragon, this.value().activation().getInitialManaCost(this.level));
        }
        if (this.currentTick > castTime) {
            float manaCost = this.getContinuousManaCost(ManaCost.ManaCostType.TICKING);
            if (ManaHandler.hasEnoughMana(dragon, manaCost)) {
                ManaHandler.consumeMana(dragon, manaCost);
            } else {
                this.stopCasting(dragon);
                return;
            }
        }
        if (dragon instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)dragon;
            ((DragonAbility)this.ability.value()).actions().forEach(action -> action.tick(serverPlayer, this, this.currentTick));
        }
        if (this.value().activation().type() == Activation.Type.SIMPLE || this.isPassive() && this.value().activation().getCooldown(this.level) > 0) {
            this.stopCasting(dragon);
        }
    }

    private void stopCasting(Player dragon) {
        this.value().activation().playEndSound(dragon);
        this.value().activation().playEndAnimation(dragon);
        MagicData magic = MagicData.getData(dragon);
        magic.stopCasting(dragon, this);
    }

    public float getContinuousManaCost(ManaCost.ManaCostType manaCostType) {
        Optional<ManaCost> optional = this.value().activation().continuousManaCost();
        if (optional.isEmpty()) {
            return 0.0f;
        }
        ManaCost manaCost = optional.get();
        if (manaCost.manaCostType() != manaCostType) {
            return 0.0f;
        }
        return manaCost.manaCost().calculate(this.level);
    }

    public boolean hasEnoughMana(Player dragon) {
        float manaCost = this.value().activation().getInitialManaCost(this.level);
        return ManaHandler.hasEnoughMana(dragon, manaCost);
    }

    public void handleNotEnoughMana(Player dragon) {
        this.currentTick = 0;
        if (dragon.level().isClientSide()) {
            MagicData magic = MagicData.getData(dragon);
            magic.setErrorMessageSent(true);
            if (this.value().activation().notification().notEnoughMana().getContents() != PlainTextContents.EMPTY) {
                MagicHUD.castingError(this.value().activation().notification().notEnoughMana());
            }
        }
    }

    public boolean isApplyingEffects() {
        return this.isActive && this.canBeCast() && this.currentTick >= this.value().activation().getCastTime(this.level);
    }

    public boolean hasEndAnimation() {
        return this.value().activation().animations().isPresent() && this.value().activation().animations().get().end().isPresent();
    }

    public boolean canBeCast() {
        return this.isUsable() && this.cooldown == 0;
    }

    public ResourceLocation getIcon() {
        return ((DragonAbility)this.ability.value()).icon().get(this.level);
    }

    public void setActive(Player player, boolean isActive) {
        this.isActive = isActive;
        if (!isActive && player instanceof ServerPlayer) {
            PassiveActivation passive;
            ServerPlayer serverPlayer = (ServerPlayer)player;
            Activation activation = this.value().activation();
            if (activation instanceof PassiveActivation && (passive = (PassiveActivation)activation).trigger().type() == ActivationTrigger.TriggerType.CONSTANT) {
                ((DragonAbility)this.ability.value()).actions().forEach(action -> action.remove(serverPlayer, this));
            }
        }
        if (!isActive) {
            this.currentTick = 0;
        }
    }

    public void release(Player dragon) {
        this.currentTick = 0;
        this.cooldown = dragon.hasInfiniteMaterials() && (!this.isPassive() || this.getCooldown() <= 0) ? 0 : ((DragonAbility)this.ability.value()).activation().getCooldown(this.level);
    }

    public void tickCooldown(Player entity) {
        this.cooldown = entity.hasInfiniteMaterials() && (!this.isPassive() || this.getCooldown() <= 0) ? 0 : Math.max(0, this.cooldown - 1);
    }

    public boolean isPassive() {
        return this.value().activation().type() == Activation.Type.PASSIVE;
    }

    public int getMaxLevel() {
        return this.value().getMaxLevel();
    }

    public int getCurrentCastTime() {
        return this.currentTick;
    }

    public boolean isUsable() {
        return this.isEnabled() && this.level > 0;
    }

    public int getCooldown() {
        return this.cooldown;
    }

    public DragonAbility value() {
        return (DragonAbility)this.ability.value();
    }

    public Component getName() {
        return Component.translatable((String)Translation.Type.ABILITY.wrap(this.location()));
    }

    public ResourceKey<DragonAbility> key() {
        return this.ability.getKey();
    }

    public ResourceLocation location() {
        return this.key().location();
    }

    public String id() {
        return this.location().toString();
    }

    public Holder<DragonAbility> ability() {
        return this.ability;
    }

    public void setLevel(int level) {
        this.level = Mth.clamp((int)level, (int)0, (int)this.getMaxLevel());
    }

    public int level() {
        return this.level;
    }

    public void setDisabled(Player player, boolean isDisabled, boolean isManual) {
        if (isManual) {
            this.isManuallyDisabled = isDisabled;
        } else {
            this.isAutomaticallyDisabled = isDisabled;
        }
        if (this.isActive && !this.isEnabled()) {
            this.setActive(player, false);
        } else if (!this.isActive && this.isEnabled() && this.isPassive()) {
            this.setActive(player, true);
        }
    }

    public boolean isDisabled(boolean isManual) {
        if (isManual) {
            return this.isManuallyDisabled;
        }
        return this.isAutomaticallyDisabled;
    }

    public boolean isEnabled() {
        return !this.isManuallyDisabled && !this.isAutomaticallyDisabled;
    }
}

