/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.registry.dragon.ability;

import by.dragonsurvivalteam.dragonsurvival.DragonSurvival;
import by.dragonsurvivalteam.dragonsurvival.common.codecs.LevelBasedResource;
import by.dragonsurvivalteam.dragonsurvival.common.codecs.ability.ActionContainer;
import by.dragonsurvivalteam.dragonsurvival.registry.datagen.Translation;
import by.dragonsurvivalteam.dragonsurvival.registry.datagen.lang.DSLanguageProvider;
import by.dragonsurvivalteam.dragonsurvival.registry.datagen.lang.LangKey;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.ability.DragonAbilityInstance;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.ability.activation.Activation;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.ability.activation.PassiveActivation;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.ability.upgrade.UpgradeType;
import by.dragonsurvivalteam.dragonsurvival.util.DSColors;
import by.dragonsurvivalteam.dragonsurvival.util.Functions;
import by.dragonsurvivalteam.dragonsurvival.util.ResourceHelper;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.RegistryFixedCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.registries.DataPackRegistryEvent;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public record DragonAbility(Activation activation, Optional<UpgradeType<?>> upgrade, Optional<LootItemCondition> usageBlocked, List<ActionContainer> actions, boolean canBeManuallyDisabled, LevelBasedResource icon) {
    @Translation(comments={"\u00a76\u25a0 Trigger:\u00a7r %s"})
    private static final String ACTIVATION_TRIGGER = Translation.Type.GUI.wrap("ability.activation_trigger");
    public static final ResourceKey<Registry<DragonAbility>> REGISTRY = ResourceKey.createRegistryKey((ResourceLocation)DragonSurvival.res("dragon_ability"));
    public static final Codec<DragonAbility> DIRECT_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Activation.CODEC.fieldOf("activation").forGetter(DragonAbility::activation), (App)UpgradeType.CODEC.optionalFieldOf("upgrade").forGetter(DragonAbility::upgrade), (App)LootItemCondition.DIRECT_CODEC.optionalFieldOf("usage_blocked").forGetter(DragonAbility::usageBlocked), (App)ActionContainer.CODEC.listOf().optionalFieldOf("actions", List.of()).forGetter(DragonAbility::actions), (App)Codec.BOOL.optionalFieldOf("can_be_manually_disabled", (Object)true).forGetter(DragonAbility::canBeManuallyDisabled), (App)LevelBasedResource.CODEC.fieldOf("icon").forGetter(DragonAbility::icon)).apply((Applicative)instance, instance.stable(DragonAbility::new)));
    public static final Codec<Holder<DragonAbility>> CODEC = RegistryFixedCodec.create(REGISTRY);
    public static final StreamCodec<RegistryFriendlyByteBuf, Holder<DragonAbility>> STREAM_CODEC = ByteBufCodecs.holderRegistry(REGISTRY);

    public int getMaxLevel() {
        return this.upgrade.map(UpgradeType::maxLevel).orElse(1);
    }

    public static void validate(RegistryAccess access) {
        StringBuilder validationError = new StringBuilder("The following stages are incorrectly defined:");
        AtomicBoolean areStagesValid = new AtomicBoolean(true);
        ResourceHelper.keys((HolderLookup.Provider)access, REGISTRY).forEach(key -> {});
        if (!areStagesValid.get()) {
            throw new IllegalStateException(validationError.toString());
        }
    }

    public List<Component> getInfo(Player dragon, DragonAbilityInstance instance) {
        float initialManaCost;
        int cooldown;
        int castTime;
        ArrayList<Component> info = new ArrayList<Component>();
        Activation activation = this.activation;
        if (activation instanceof PassiveActivation) {
            PassiveActivation passive = (PassiveActivation)activation;
            info.add((Component)Component.translatable((String)ACTIVATION_TRIGGER, (Object[])new Object[]{DSLanguageProvider.enumValue(passive.trigger().type())}));
        }
        if ((castTime = this.activation.getCastTime(instance.level())) > 0) {
            info.add((Component)Component.translatable((String)LangKey.ABILITY_CAST_TIME, (Object[])new Object[]{DSColors.dynamicValue(Functions.ticksToSeconds(castTime))}));
        }
        if ((cooldown = ((DragonAbility)instance.ability().value()).activation.getCooldown(instance.level())) > 0) {
            info.add((Component)Component.translatable((String)LangKey.ABILITY_COOLDOWN, (Object[])new Object[]{DSColors.dynamicValue(Functions.ticksToSeconds(cooldown))}));
        }
        if ((initialManaCost = ((DragonAbility)instance.ability().value()).activation().getInitialManaCost(instance.level())) > 0.0f) {
            info.add((Component)Component.translatable((String)LangKey.ABILITY_INITIAL_MANA_COST, (Object[])new Object[]{DSColors.dynamicValue(Float.valueOf(initialManaCost))}));
        }
        ((DragonAbility)instance.ability().value()).activation().continuousManaCost().ifPresent(cost -> info.add((Component)Component.translatable((String)LangKey.ABILITY_CONTINUOUS_MANA_COST, (Object[])new Object[]{DSColors.dynamicValue(Float.valueOf(cost.manaCost().calculate(instance.level()))), DSLanguageProvider.enumValue(cost.manaCostType())})));
        for (ActionContainer action : this.actions) {
            List<MutableComponent> descriptions = action.effect().getAllEffectDescriptions(dragon, instance);
            for (MutableComponent description : descriptions) {
                if (!info.isEmpty()) {
                    info.add((Component)Component.empty());
                }
                info.add((Component)description);
            }
        }
        return info;
    }

    @SubscribeEvent
    public static void register(DataPackRegistryEvent.NewRegistry event) {
        event.dataPackRegistry(REGISTRY, DIRECT_CODEC, DIRECT_CODEC);
    }
}

