/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.registry.datagen.loot;

import by.dragonsurvivalteam.dragonsurvival.common.capability.DragonStateProvider;
import by.dragonsurvivalteam.dragonsurvival.config.obj.ConfigOption;
import by.dragonsurvivalteam.dragonsurvival.config.obj.ConfigRange;
import by.dragonsurvivalteam.dragonsurvival.config.obj.ConfigSide;
import by.dragonsurvivalteam.dragonsurvival.registry.DSItems;
import by.dragonsurvivalteam.dragonsurvival.registry.datagen.Translation;
import by.dragonsurvivalteam.dragonsurvival.registry.datagen.tags.DSEntityTypeTags;
import by.dragonsurvivalteam.dragonsurvival.util.EnchantmentUtils;
import com.google.common.base.Suppliers;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.neoforged.neoforge.common.loot.IGlobalLootModifier;
import net.neoforged.neoforge.common.loot.LootModifier;
import org.jetbrains.annotations.NotNull;

public class DragonHeartLootModifier
extends LootModifier {
    @ConfigRange(min=0.0, max=1.0)
    @Translation(key="dragon_heart_shard_chance", type=Translation.Type.CONFIGURATION, comments={"Determines the chance (in %) of dragon heart shards dropping from entities with a maximum health between 14 and 20"})
    @ConfigOption(side=ConfigSide.SERVER, category={"drops"}, key="dragon_heart_shard_chance")
    public static Double DRAGON_HEART_SHARD_CHANCE = 0.03;
    @ConfigRange(min=0.0, max=1.0)
    @Translation(key="weak_dragon_heart_chance", type=Translation.Type.CONFIGURATION, comments={"Determines the chance (in %) of weak dragon hearts dropping from entities with a maximum health between 20 and 50"})
    @ConfigOption(side=ConfigSide.SERVER, category={"drops"}, key="weak_dragon_heart_chance")
    public static Double WEAK_DRAGON_HEART_CHANCE = 0.01;
    @ConfigRange(min=0.0, max=1.0)
    @Translation(key="elder_dragon_heart_chance", type=Translation.Type.CONFIGURATION, comments={"Determines the chance (in %) of elder dragon hearts dropping from entities with a maximum health above 50"})
    @ConfigOption(side=ConfigSide.SERVER, category={"drops"}, key="elder_dragon_heart_chance")
    public static Double ELDER_DRAGON_HEART_CHANCE = 0.01;
    @Translation(key="dragon_heart_white_list", type=Translation.Type.CONFIGURATION, comments={"Should the entity type tag 'drops_dragon_heart_shard' be treated as a whitelist instead of a blacklist?"})
    @ConfigOption(side=ConfigSide.SERVER, category={"drops"}, key="dragon_heart_white_list")
    public static Boolean DRAGON_HEART_SHARD_WHITELIST = false;
    @Translation(key="weak_dragon_heart_white_list", type=Translation.Type.CONFIGURATION, comments={"Should the entity type tag 'drops_weak_dragon_heart' be treated as a whitelist instead of a blacklist?"})
    @ConfigOption(side=ConfigSide.SERVER, category={"drops"}, key="weak_dragon_heart_white_list")
    public static Boolean WEAK_DRAGON_HEART_WHITELIST = false;
    @Translation(key="elder_dragon_heart_white_list", type=Translation.Type.CONFIGURATION, comments={"Should the entity type tag 'drops_elder_dragon_heart' be treated as a whitelist instead of a blacklist?"})
    @ConfigOption(side=ConfigSide.SERVER, category={"drops"}, key="elder_dragon_heart_white_list")
    public static Boolean ELDER_DRAGON_HEART_WHITELIST = false;
    public static final Supplier<MapCodec<DragonHeartLootModifier>> CODEC = Suppliers.memoize(() -> RecordCodecBuilder.mapCodec(inst -> DragonHeartLootModifier.codecStart((RecordCodecBuilder.Instance)inst).apply((Applicative)inst, DragonHeartLootModifier::new)));

    public DragonHeartLootModifier(LootItemCondition[] conditions) {
        super(conditions);
    }

    private static boolean canDropHeart(float health, float min, float max, TagKey<EntityType<?>> tag, Entity entity, boolean isWhiteList) {
        if (health < min || health > max) {
            return false;
        }
        return entity.getType().is(tag) == isWhiteList;
    }

    @NotNull
    protected ObjectArrayList<ItemStack> doApply(@NotNull ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        LivingEntity livingEntity;
        Entity entity;
        block9: {
            block8: {
                entity = (Entity)context.getParamOrNull(LootContextParams.THIS_ENTITY);
                if (!(entity instanceof LivingEntity)) break block8;
                livingEntity = (LivingEntity)entity;
                if (!(entity instanceof Player)) break block9;
            }
            return generatedLoot;
        }
        Player player = (Player)context.getParamOrNull(LootContextParams.LAST_DAMAGE_PLAYER);
        if (player == null) {
            return generatedLoot;
        }
        if (!DragonStateProvider.isDragon((Entity)player)) {
            return generatedLoot;
        }
        float health = livingEntity.getMaxHealth();
        boolean canDropDragonHeartShard = DragonHeartLootModifier.canDropHeart(health, 14.0f, 20.0f, DSEntityTypeTags.DROPS_DRAGON_HEART_SHARD, entity, DRAGON_HEART_SHARD_WHITELIST);
        boolean canDropWeakDragonHeart = DragonHeartLootModifier.canDropHeart(health, 20.0f, 50.0f, DSEntityTypeTags.DROPS_WEAK_DRAGON_HEART, entity, WEAK_DRAGON_HEART_WHITELIST);
        boolean canDropElderDragonHeart = DragonHeartLootModifier.canDropHeart(health, 50.0f, Float.MAX_VALUE, DSEntityTypeTags.DROPS_ELDER_DRAGON_HEART, entity, ELDER_DRAGON_HEART_WHITELIST);
        int lootingLevel = EnchantmentUtils.getLevel((LivingEntity)player, (ResourceKey<Enchantment>)Enchantments.LOOTING);
        if (canDropDragonHeartShard && (double)context.getRandom().nextInt(100) <= DRAGON_HEART_SHARD_CHANCE * 100.0 + (double)lootingLevel * (DRAGON_HEART_SHARD_CHANCE * 100.0 / 4.0)) {
            generatedLoot.add((Object)new ItemStack(DSItems.DRAGON_HEART_SHARD));
        }
        if (canDropWeakDragonHeart && (double)context.getRandom().nextInt(100) <= WEAK_DRAGON_HEART_CHANCE * 100.0 + (double)lootingLevel * (WEAK_DRAGON_HEART_CHANCE * 100.0 / 4.0)) {
            generatedLoot.add((Object)new ItemStack(DSItems.WEAK_DRAGON_HEART));
        }
        if (canDropElderDragonHeart && (double)context.getRandom().nextInt(100) <= ELDER_DRAGON_HEART_CHANCE * 100.0 + (double)lootingLevel * (ELDER_DRAGON_HEART_CHANCE * 100.0 / 4.0)) {
            generatedLoot.add((Object)new ItemStack(DSItems.ELDER_DRAGON_HEART));
        }
        return generatedLoot;
    }

    @NotNull
    public MapCodec<? extends IGlobalLootModifier> codec() {
        return CODEC.get();
    }
}

