/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.registry.datagen;

import by.dragonsurvivalteam.dragonsurvival.common.blocks.PrimordialAnchorBlock;
import by.dragonsurvivalteam.dragonsurvival.common.blocks.TreasureBlock;
import by.dragonsurvivalteam.dragonsurvival.registry.DSItems;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.item.SwordItem;
import net.neoforged.neoforge.client.model.generators.ItemModelBuilder;
import net.neoforged.neoforge.client.model.generators.ItemModelProvider;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import org.jetbrains.annotations.NotNull;

public class DataItemModelProvider
extends ItemModelProvider {
    private static final List<String> BLOCK_MODELS_AS_BASIC = List.of("door", "source", "helmet", "beacon");
    private static final List<String> MANUALLY_AUTHORED = List.of("dragon_hunting_mesh", "hunter_partisan", "hunter_partisan_diamond", "hunter_partisan_netherite", "hunter_key", "dark_key", "light_key", "dragon_soul");

    public DataItemModelProvider(PackOutput output, ExistingFileHelper existingFileHelper) {
        super(output, "dragonsurvival", existingFileHelper);
    }

    protected void registerModels() {
        DSItems.REGISTRY.getEntries().forEach(holder -> {
            Object patt0$temp = holder.get();
            if (patt0$temp instanceof BlockItem) {
                BlockItem blockItem = (BlockItem)patt0$temp;
                if (BLOCK_MODELS_AS_BASIC.stream().noneMatch(blockItem.toString()::contains)) {
                    if (blockItem.toString().contains("skeleton")) {
                        String[] split = holder.getId().getPath().split("_skin");
                        String skin = split[1].substring(split[1].length() - 1);
                        ((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(blockItem.toString())).parent((ModelFile)new ModelFile.UncheckedModelFile(ResourceLocation.fromNamespaceAndPath((String)"dragonsurvival", (String)("block/" + split[0]))))).texture("skeleton_texture", ResourceLocation.fromNamespaceAndPath((String)"dragonsurvival", (String)("block/skeleton_dragon_" + skin)))).transforms().transform(ItemDisplayContext.GUI).rotation(30.0f, 160.0f, 0.0f).scale(0.5f).end();
                        return;
                    }
                    if (blockItem.toString().contains("vault")) {
                        ((ItemModelBuilder)this.getBuilder(blockItem.toString())).parent((ModelFile)new ModelFile.UncheckedModelFile(String.valueOf(ResourceLocation.fromNamespaceAndPath((String)"dragonsurvival", (String)("block/" + holder.getId().getPath()))) + "_inactive"));
                        return;
                    }
                    if (blockItem.getBlock() instanceof TreasureBlock) {
                        ResourceLocation parent = ResourceLocation.fromNamespaceAndPath((String)"dragonsurvival", (String)("block/" + holder.getId().getPath() + "2"));
                        ((ItemModelBuilder)this.getBuilder(blockItem.toString())).parent((ModelFile)new ModelFile.UncheckedModelFile(parent));
                        return;
                    }
                    if (blockItem.getBlock() instanceof PrimordialAnchorBlock) {
                        ((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(blockItem.toString())).parent((ModelFile)new ModelFile.UncheckedModelFile(ResourceLocation.fromNamespaceAndPath((String)"dragonsurvival", (String)("block/" + holder.getId().getPath()))))).texture("1", ResourceLocation.fromNamespaceAndPath((String)"dragonsurvival", (String)"block/primordial_anchor_empty"));
                        return;
                    }
                    ((ItemModelBuilder)this.getBuilder(blockItem.toString())).parent((ModelFile)new ModelFile.UncheckedModelFile(ResourceLocation.fromNamespaceAndPath((String)"dragonsurvival", (String)("block/" + holder.getId().getPath()))));
                    return;
                }
            }
            if (MANUALLY_AUTHORED.stream().anyMatch(holder.getId().getPath()::contains)) {
                return;
            }
            Object patt1$temp = holder.get();
            if (patt1$temp instanceof SpawnEggItem) {
                SpawnEggItem item = (SpawnEggItem)patt1$temp;
                ((ItemModelBuilder)this.getBuilder(item.toString())).parent((ModelFile)new ModelFile.UncheckedModelFile(ResourceLocation.withDefaultNamespace((String)"item/template_spawn_egg")));
                return;
            }
            Object patt2$temp = holder.get();
            if (patt2$temp instanceof SwordItem) {
                SwordItem item = (SwordItem)patt2$temp;
                ResourceLocation itemLoc = Objects.requireNonNull(BuiltInRegistries.ITEM.getKey((Object)item));
                ((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(itemLoc.toString())).parent((ModelFile)new ModelFile.UncheckedModelFile("item/handheld"))).texture("layer0", ResourceLocation.fromNamespaceAndPath((String)"dragonsurvival", (String)("item/" + itemLoc.getPath())));
                return;
            }
            this.basicItem((Item)holder.get());
        });
    }

    @NotNull
    public String getName() {
        return "Dragon Survival Item models";
    }
}

