/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.registry.datagen;

import by.dragonsurvivalteam.dragonsurvival.common.blocks.DragonAltarBlock;
import by.dragonsurvivalteam.dragonsurvival.common.blocks.DragonBeacon;
import by.dragonsurvivalteam.dragonsurvival.common.blocks.DragonDoor;
import by.dragonsurvivalteam.dragonsurvival.common.blocks.DragonPressurePlates;
import by.dragonsurvivalteam.dragonsurvival.common.blocks.DragonRiderWorkbenchBlock;
import by.dragonsurvivalteam.dragonsurvival.common.blocks.HelmetBlock;
import by.dragonsurvivalteam.dragonsurvival.common.blocks.PrimordialAnchorBlock;
import by.dragonsurvivalteam.dragonsurvival.common.blocks.SkeletonPieceBlock;
import by.dragonsurvivalteam.dragonsurvival.common.blocks.SmallDragonDoor;
import by.dragonsurvivalteam.dragonsurvival.common.blocks.SourceOfMagicBlock;
import by.dragonsurvivalteam.dragonsurvival.common.blocks.TreasureBlock;
import by.dragonsurvivalteam.dragonsurvival.registry.DSBlocks;
import java.util.Locale;
import net.minecraft.core.Direction;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.VaultBlock;
import net.minecraft.world.level.block.entity.vault.VaultState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoorHingeSide;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.client.model.generators.BlockModelBuilder;
import net.neoforged.neoforge.client.model.generators.BlockStateProvider;
import net.neoforged.neoforge.client.model.generators.ConfiguredModel;
import net.neoforged.neoforge.client.model.generators.ModelBuilder;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import org.jetbrains.annotations.NotNull;

public class DataBlockStateProvider
extends BlockStateProvider {
    public DataBlockStateProvider(PackOutput output, ExistingFileHelper existingFileHelper) {
        super(output, "dragonsurvival", existingFileHelper);
    }

    protected void registerStatesAndModels() {
        DSBlocks.REGISTRY.getEntries().forEach(holder -> {
            if (holder.get() instanceof DragonDoor) {
                this.getVariantBuilder((Block)holder.get()).forAllStates(state -> {
                    ResourceLocation selected;
                    boolean partTop = state.getValue(DragonDoor.PART) == DragonDoor.Part.TOP;
                    boolean partMiddle = state.getValue(DragonDoor.PART) == DragonDoor.Part.MIDDLE;
                    boolean hingeRight = state.getValue(DragonDoor.HINGE) == DoorHingeSide.RIGHT;
                    boolean open = (Boolean)state.getValue((Property)DragonDoor.OPEN);
                    String name = holder.getId().getPath();
                    String suffix = (partTop ? "_top" : (partMiddle ? "_middle" : "_bottom")) + (hingeRight ? "_hinge" : "") + (open ? "_open" : "");
                    String modelName = "block/" + name + suffix;
                    ResourceLocation bottom = this.modLoc("block/" + name + "_bottom");
                    ResourceLocation center = this.modLoc("block/" + name + "_center");
                    ResourceLocation top = this.modLoc("block/" + name + "_top");
                    ResourceLocation resourceLocation = partTop ? top : (selected = partMiddle ? center : bottom);
                    ModelBuilder door = hingeRight ? (partTop ? (open ? ((BlockModelBuilder)this.models().doorTopRightOpen(modelName, selected, selected)).renderType("cutout") : ((BlockModelBuilder)this.models().doorTopRight(modelName, selected, selected)).renderType("cutout")) : (open ? ((BlockModelBuilder)this.models().doorBottomRightOpen(modelName, selected, selected)).renderType("cutout") : ((BlockModelBuilder)this.models().doorBottomRight(modelName, selected, selected)).renderType("cutout"))) : (partTop ? (open ? ((BlockModelBuilder)this.models().doorTopLeftOpen(modelName, selected, selected)).renderType("cutout") : ((BlockModelBuilder)this.models().doorTopLeft(modelName, selected, selected)).renderType("cutout")) : (open ? ((BlockModelBuilder)this.models().doorBottomLeftOpen(modelName, selected, selected)).renderType("cutout") : ((BlockModelBuilder)this.models().doorBottomLeft(modelName, selected, selected)).renderType("cutout")));
                    int yRot = (int)((Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)).toYRot() + 90;
                    yRot = open && hingeRight ? yRot - 90 : yRot;
                    yRot = open && !hingeRight ? yRot + 90 : yRot;
                    yRot = yRot < 0 ? 360 + yRot : yRot;
                    return ConfiguredModel.builder().modelFile((ModelFile)door).rotationY(yRot %= 360).build();
                });
            } else if (holder.get() instanceof SmallDragonDoor) {
                this.getVariantBuilder((Block)holder.get()).forAllStates(state -> {
                    boolean hingeRight = state.getValue(SmallDragonDoor.HINGE) == DoorHingeSide.RIGHT;
                    boolean open = (Boolean)state.getValue((Property)SmallDragonDoor.OPEN);
                    String name = holder.getId().getPath();
                    String suffix = hingeRight && !open || !hingeRight && open ? "_hinge" : "";
                    ResourceLocation texture = this.modLoc("block/" + name);
                    ModelBuilder door = ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(name + suffix, ResourceLocation.fromNamespaceAndPath((String)"dragonsurvival", (String)("block/small_dragon_door" + (suffix.equals("_hinge") ? "_rh" : ""))))).texture("bottom", texture)).texture("top", texture);
                    int yRot = (int)((Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)).toYRot() + 90;
                    yRot = open && hingeRight ? yRot - 90 : yRot;
                    yRot = open && !hingeRight ? yRot + 90 : yRot;
                    yRot = yRot < 0 ? 360 + yRot : yRot;
                    return ConfiguredModel.builder().modelFile((ModelFile)door).rotationY(yRot %= 360).build();
                });
            } else if (holder.get() instanceof HelmetBlock) {
                String name = holder.getId().getPath();
                this.getVariantBuilder((Block)holder.get()).forAllStates(state -> {
                    BlockModelBuilder builder = (BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(name, "block/skull")).texture("all", this.modLoc("block/" + name));
                    return ConfiguredModel.builder().modelFile((ModelFile)builder).build();
                });
            } else {
                Object patt0$temp = holder.get();
                if (patt0$temp instanceof DragonPressurePlates) {
                    DragonPressurePlates plate = (DragonPressurePlates)((Object)((Object)patt0$temp));
                    name = holder.getId().getPath();
                    ResourceLocation texture = this.modLoc("block/" + name);
                    ModelBuilder pressurePlate = this.models().pressurePlate(name, texture);
                    ModelBuilder pressurePlateDown = this.models().pressurePlateDown(name + "_down", texture);
                    this.horizontalFacingPressurePlate(plate, (ModelFile)pressurePlateDown, (ModelFile)pressurePlate);
                } else if (holder.get() instanceof DragonAltarBlock) {
                    name = holder.getId().getPath();
                    BlockModelBuilder builder = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(name, "orientable")).texture("up", this.modLoc("block/" + name + "_top"))).texture("down", this.modLoc("block/" + name + "_top"))).texture("east", this.modLoc("block/" + name + "_east"))).texture("west", this.modLoc("block/" + name + "_west"))).texture("north", this.modLoc("block/" + name + "_north"))).texture("south", this.modLoc("block/" + name + "_south"))).texture("particle", this.modLoc("block/" + name + "_top"));
                    this.getVariantBuilder((Block)holder.get()).forAllStates(state -> ConfiguredModel.builder().modelFile((ModelFile)builder).rotationY((int)((Direction)state.getValue((Property)DragonAltarBlock.FACING)).toYRot()).build());
                } else {
                    Object patt1$temp = holder.get();
                    if (patt1$temp instanceof TreasureBlock) {
                        TreasureBlock treasureBlock = (TreasureBlock)patt1$temp;
                        this.getVariantBuilder((Block)treasureBlock).forAllStatesExcept(state -> {
                            int layers = (Integer)state.getValue((Property)TreasureBlock.LAYERS);
                            String name = holder.getId().getPath();
                            BlockModelBuilder builder = layers != 8 ? (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(name + layers * 2, "block/snow_height" + layers * 2)).texture("particle", this.modLoc("block/" + name))).texture("texture", this.modLoc("block/" + name)) : (BlockModelBuilder)this.models().cubeAll(name, this.modLoc("block/" + name));
                            return ConfiguredModel.builder().modelFile((ModelFile)builder).build();
                        }, new Property[]{TreasureBlock.WATERLOGGED});
                    } else {
                        Object patt2$temp = holder.get();
                        if (patt2$temp instanceof VaultBlock) {
                            VaultBlock vaultBlock = (VaultBlock)patt2$temp;
                            name = holder.getId().getPath();
                            this.getVariantBuilder((Block)vaultBlock).forAllStates(state -> {
                                int yRot = (int)((Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)).toYRot() - 180;
                                VaultState vaultState = (VaultState)state.getValue(VaultBlock.STATE);
                                String suffix = vaultState.name().toLowerCase(Locale.ENGLISH);
                                if (vaultState == VaultState.EJECTING) {
                                    suffix = "ejecting_reward";
                                }
                                BlockModelBuilder builder = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(name + "_" + suffix, "template_vault")).texture("bottom", this.modLoc("block/" + name + "_bottom"))).texture("front", this.modLoc("block/" + name + "_front" + (vaultState == VaultState.ACTIVE ? "_on" : (vaultState == VaultState.INACTIVE ? "_off" : "_ejecting"))))).texture("side", this.modLoc("block/" + name + "_side" + (vaultState == VaultState.ACTIVE || vaultState == VaultState.EJECTING ? "_on" : "_off")))).texture("top", this.modLoc("block/" + name + "_top" + (vaultState == VaultState.EJECTING ? "_ejecting" : "")))).renderType("cutout");
                                return ConfiguredModel.builder().modelFile((ModelFile)builder).rotationY(yRot).build();
                            });
                        } else if (holder.get() instanceof DragonRiderWorkbenchBlock) {
                            name = holder.getId().getPath();
                            this.getVariantBuilder((Block)holder.get()).forAllStates(state -> {
                                String modelName = "block/" + name;
                                BlockModelBuilder builder = (BlockModelBuilder)((BlockModelBuilder)this.models().cube(modelName, this.modLoc(modelName + "_down"), this.modLoc(modelName + "_up"), this.modLoc(modelName + "_north"), this.modLoc(modelName + "_south"), this.modLoc(modelName + "_east"), this.modLoc(modelName + "_west"))).texture("particle", this.modLoc(modelName + "_down"));
                                return ConfiguredModel.builder().modelFile((ModelFile)builder).rotationY((int)((Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)).toYRot()).build();
                            });
                        } else if (holder.get() instanceof SourceOfMagicBlock) {
                            name = holder.getId().getPath();
                            this.getVariantBuilder((Block)holder.get()).forAllStates(state -> {
                                boolean isEmpty = (Boolean)state.getValue((Property)SourceOfMagicBlock.FILLED) == false;
                                ModelFile.ExistingModelFile modelFile = this.models().getExistingFile(ResourceLocation.fromNamespaceAndPath((String)"dragonsurvival", (String)("block/" + name + (isEmpty ? "_empty" : ""))));
                                return ConfiguredModel.builder().modelFile((ModelFile)modelFile).rotationY((int)(((Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)).toYRot() + 180.0f) % 360).build();
                            });
                        } else if (holder.get() instanceof RotatedPillarBlock) {
                            this.getVariantBuilder((Block)holder.get()).forAllStates(state -> {
                                BlockModelBuilder builder = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(holder.getId().getPath(), "block/cube_column")).texture("side", ResourceLocation.fromNamespaceAndPath((String)"dragonsurvival", (String)"block/dragons_memory_side"))).texture("end", ResourceLocation.fromNamespaceAndPath((String)"dragonsurvival", (String)"block/dragons_memory_top"));
                                return ConfiguredModel.builder().modelFile((ModelFile)builder).build();
                            });
                        } else if (holder.get() instanceof DragonBeacon) {
                            this.getVariantBuilder((Block)holder.get()).forAllStates(state -> {
                                ModelFile.ExistingModelFile modelFile = this.models().getExistingFile(ResourceLocation.fromNamespaceAndPath((String)"dragonsurvival", (String)"block/empty"));
                                return ConfiguredModel.builder().modelFile((ModelFile)modelFile).build();
                            });
                        } else if (holder.get() instanceof SkeletonPieceBlock) {
                            String[] split = holder.getId().getPath().split("_skin");
                            String skin = split[1].substring(split[1].length() - 1);
                            this.getVariantBuilder((Block)holder.get()).forAllStates(state -> {
                                BlockModelBuilder builder = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(holder.getId().getPath(), ResourceLocation.fromNamespaceAndPath((String)"dragonsurvival", (String)("block/" + split[0])))).texture("skeleton_texture", ResourceLocation.fromNamespaceAndPath((String)"dragonsurvival", (String)("block/skeleton_dragon_" + skin)))).texture("particle", ResourceLocation.fromNamespaceAndPath((String)"dragonsurvival", (String)("block/placeholder_" + skin)));
                                return ConfiguredModel.builder().modelFile((ModelFile)builder).rotationY((int)((Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)).toYRot()).build();
                            });
                        } else if (holder.get() instanceof PrimordialAnchorBlock) {
                            this.getVariantBuilder((Block)holder.get()).forAllStates(state -> {
                                String suffix = (Boolean)state.getValue((Property)PrimordialAnchorBlock.BLOODY) != false ? "_bloody" : ((Boolean)state.getValue((Property)PrimordialAnchorBlock.CHARGED) != false ? "_charge" : "_empty");
                                BlockModelBuilder builder = (BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(holder.getId().getPath() + suffix, ResourceLocation.fromNamespaceAndPath((String)"dragonsurvival", (String)"block/primordial_anchor"))).texture("2", ResourceLocation.fromNamespaceAndPath((String)"dragonsurvival", (String)("block/primordial_anchor" + suffix)));
                                return ConfiguredModel.builder().modelFile((ModelFile)builder).build();
                            });
                        }
                    }
                }
            }
        });
    }

    public void horizontalFacingPressurePlate(DragonPressurePlates plate, ModelFile poweredModel, ModelFile unpoweredModel) {
        this.getVariantBuilder((Block)plate).forAllStatesExcept(state -> ConfiguredModel.builder().modelFile((Boolean)state.getValue((Property)DragonPressurePlates.POWERED) != false ? poweredModel : unpoweredModel).rotationY(((int)((Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)).toYRot() + 180) % 360).build(), new Property[]{DragonPressurePlates.WATERLOGGED});
    }

    @NotNull
    public String getName() {
        return "Dragon Survival Block states";
    }
}

