/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.registry.datagen;

import by.dragonsurvivalteam.dragonsurvival.common.blocks.DragonBeacon;
import by.dragonsurvivalteam.dragonsurvival.common.blocks.DragonDoor;
import by.dragonsurvivalteam.dragonsurvival.common.blocks.ModCompat;
import by.dragonsurvivalteam.dragonsurvival.common.blocks.PrimordialAnchorBlock;
import by.dragonsurvivalteam.dragonsurvival.common.blocks.SkeletonPieceBlock;
import by.dragonsurvivalteam.dragonsurvival.common.blocks.SourceOfMagicBlock;
import by.dragonsurvivalteam.dragonsurvival.common.blocks.TreasureBlock;
import by.dragonsurvivalteam.dragonsurvival.registry.DSBlocks;
import by.dragonsurvivalteam.dragonsurvival.registry.DSItems;
import java.util.ArrayList;
import java.util.Collections;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.loot.BlockLootSubProvider;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.VaultBlock;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.AlternativesEntry;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.predicates.ConditionUserBuilder;
import net.minecraft.world.level.storage.loot.predicates.LootItemBlockStatePropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemEntityPropertyCondition;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import net.neoforged.neoforge.registries.DeferredHolder;
import org.jetbrains.annotations.NotNull;

public class BlockLootTableSubProvider
extends BlockLootSubProvider {
    public BlockLootTableSubProvider(HolderLookup.Provider provider) {
        super(Collections.emptySet(), FeatureFlags.REGISTRY.allFlags(), provider);
    }

    protected void generate() {
        DSBlocks.REGISTRY.getEntries().forEach(key -> {
            ModCompat compat;
            Object patt0$temp = key.get();
            if (patt0$temp instanceof ModCompat && (compat = (ModCompat)patt0$temp).getCompatId() != null) {
                return;
            }
            Function<Block, LootTable.Builder> builder = block -> {
                if (block instanceof DragonDoor) {
                    return this.createSinglePropConditionTable((Block)block, (Property)DragonDoor.PART, (Comparable)((Object)DragonDoor.Part.BOTTOM));
                }
                if (block instanceof SourceOfMagicBlock) {
                    return LootTable.lootTable().withPool((LootPool.Builder)this.applyExplosionCondition((ItemLike)block, (ConditionUserBuilder)LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add(LootItem.lootTableItem((ItemLike)block).when((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)block).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)SourceOfMagicBlock.PRIMARY_BLOCK, true))))));
                }
                if (block instanceof TreasureBlock) {
                    return BlockLootTableSubProvider.createTreasureBlockLoot(block);
                }
                if (block instanceof SkeletonPieceBlock) {
                    SkeletonPieceBlock skeleton = (SkeletonPieceBlock)((Object)((Object)block));
                    return switch (skeleton.type()) {
                        case SkeletonPieceBlock.Type.CHEST -> this.createSingleItemTable((ItemLike)DSItems.STAR_BONE.value(), (NumberProvider)UniformGenerator.between((float)3.0f, (float)6.0f));
                        case SkeletonPieceBlock.Type.LEG_1, SkeletonPieceBlock.Type.NECK_2 -> this.createSingleItemTable((ItemLike)DSItems.STAR_BONE.value(), (NumberProvider)UniformGenerator.between((float)1.0f, (float)3.0f));
                        case SkeletonPieceBlock.Type.LEG_2, SkeletonPieceBlock.Type.NECK_1 -> this.createSingleItemTable((ItemLike)DSItems.STAR_BONE.value(), (NumberProvider)UniformGenerator.between((float)1.0f, (float)2.0f));
                        case SkeletonPieceBlock.Type.LEG_3 -> this.createSingleItemTable((ItemLike)DSItems.STAR_BONE.value(), (NumberProvider)ConstantValue.exactly((float)1.0f));
                        case SkeletonPieceBlock.Type.NECK_3 -> this.createSingleItemTable((ItemLike)DSItems.STAR_BONE.value(), (NumberProvider)UniformGenerator.between((float)1.0f, (float)4.0f));
                        case SkeletonPieceBlock.Type.PELVIS -> this.createSingleItemTable((ItemLike)DSItems.STAR_BONE.value(), (NumberProvider)UniformGenerator.between((float)2.0f, (float)4.0f));
                        case SkeletonPieceBlock.Type.SKULL_1, SkeletonPieceBlock.Type.SKULL_2 -> this.createSingleItemTable((ItemLike)DSItems.STAR_BONE.value(), (NumberProvider)UniformGenerator.between((float)1.0f, (float)5.0f));
                        default -> this.createSingleItemTable((ItemLike)DSItems.STAR_BONE.value());
                    };
                }
                if (block instanceof DragonBeacon) {
                    return this.createSingleItemTable((ItemLike)DSBlocks.DRAGON_BEACON.value());
                }
                if (block instanceof VaultBlock || block instanceof PrimordialAnchorBlock) {
                    return LootTable.lootTable();
                }
                return this.createSingleItemTable((ItemLike)((Block)key.get()).asItem());
            };
            this.add((Block)key.get(), builder);
        });
    }

    public static LootTable.Builder createTreasureBlockLoot(Block block) {
        ArrayList<LootPoolSingletonContainer.Builder> list = new ArrayList<LootPoolSingletonContainer.Builder>();
        for (Integer possibleValue : TreasureBlock.LAYERS.getPossibleValues()) {
            LootPoolSingletonContainer.Builder entry = ((LootPoolSingletonContainer.Builder)LootItem.lootTableItem((ItemLike)block).when((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)block).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)TreasureBlock.LAYERS, possibleValue.intValue())))).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)ConstantValue.exactly((float)possibleValue.intValue())));
            list.add(entry);
        }
        LootPoolSingletonContainer.Builder[] arr = list.toArray(new LootPoolSingletonContainer.Builder[0]);
        return LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).when(LootItemEntityPropertyCondition.entityPresent((LootContext.EntityTarget)LootContext.EntityTarget.THIS)).add(AlternativesEntry.alternatives((LootPoolEntryContainer.Builder[])new LootPoolEntryContainer.Builder[]{AlternativesEntry.alternatives((LootPoolEntryContainer.Builder[])arr)}).when((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)block))));
    }

    @NotNull
    protected Iterable<Block> getKnownBlocks() {
        return DSBlocks.REGISTRY.getEntries().stream().map(DeferredHolder::get).filter(block -> {
            ModCompat compat;
            return !(block instanceof ModCompat) || (compat = (ModCompat)block).getCompatId() == null;
        }).collect(Collectors.toList());
    }
}

