/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.registry.attachments;

import by.dragonsurvivalteam.dragonsurvival.common.codecs.OxygenBonus;
import by.dragonsurvivalteam.dragonsurvival.registry.attachments.DSDataAttachments;
import by.dragonsurvivalteam.dragonsurvival.registry.attachments.Storage;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.event.tick.EntityTickEvent;
import net.neoforged.neoforge.fluids.FluidType;
import net.neoforged.neoforge.registries.NeoForgeRegistries;
import org.jetbrains.annotations.NotNull;

@EventBusSubscriber
public class OxygenBonuses
extends Storage<OxygenBonus.Instance> {
    public float getBonus(ResourceKey<FluidType> fluidKey) {
        Holder.Reference fluid = NeoForgeRegistries.FLUID_TYPES.getHolderOrThrow(fluidKey);
        float bonus = OxygenBonus.NONE;
        for (OxygenBonus.Instance instance : this.all()) {
            if (instance.getOxygenBonus((Holder<FluidType>)fluid) == -1.0f) {
                return -1.0f;
            }
            bonus += instance.getOxygenBonus((Holder<FluidType>)fluid);
        }
        return bonus;
    }

    @SubscribeEvent
    public static void tickData(EntityTickEvent.Post event) {
        Entity entity = event.getEntity();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            player.getExistingData(DSDataAttachments.OXYGEN_BONUSES).ifPresent(storage -> {
                storage.tick((Entity)player);
                if (storage.isEmpty()) {
                    player.removeData(DSDataAttachments.OXYGEN_BONUSES);
                }
            });
        }
    }

    @Override
    protected Tag save(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider, OxygenBonus.Instance entry) {
        return entry.save(provider);
    }

    @Override
    protected OxygenBonus.Instance load(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider, CompoundTag tag) {
        return OxygenBonus.Instance.load(provider, tag);
    }

    @Override
    public AttachmentType<?> type() {
        return (AttachmentType)DSDataAttachments.OXYGEN_BONUSES.get();
    }
}

