/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.registry.attachments;

import by.dragonsurvivalteam.dragonsurvival.DragonSurvival;
import by.dragonsurvivalteam.dragonsurvival.client.gui.hud.MagicHUD;
import by.dragonsurvivalteam.dragonsurvival.common.capability.DragonStateHandler;
import by.dragonsurvivalteam.dragonsurvival.common.capability.DragonStateProvider;
import by.dragonsurvivalteam.dragonsurvival.common.codecs.Condition;
import by.dragonsurvivalteam.dragonsurvival.common.codecs.DragonAbilityHolder;
import by.dragonsurvivalteam.dragonsurvival.common.codecs.ability.ActionContainer;
import by.dragonsurvivalteam.dragonsurvival.network.magic.SyncMagicData;
import by.dragonsurvivalteam.dragonsurvival.registry.DSAdvancementTriggers;
import by.dragonsurvivalteam.dragonsurvival.registry.DSSounds;
import by.dragonsurvivalteam.dragonsurvival.registry.attachments.DSDataAttachments;
import by.dragonsurvivalteam.dragonsurvival.registry.data_components.DSDataComponents;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.BuiltInDragonSpecies;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.DragonSpecies;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.ability.DragonAbility;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.ability.DragonAbilityInstance;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.ability.activation.Activation;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.ability.activation.PassiveActivation;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.ability.activation.trigger.ActivationTrigger;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.ability.upgrade.ExperiencePointsUpgrade;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.ability.upgrade.InputData;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.ability.upgrade.UpgradeType;
import by.dragonsurvivalteam.dragonsurvival.util.Functions;
import java.text.NumberFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.contents.PlainTextContents;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.util.INBTSerializable;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@EventBusSubscriber
public class MagicData
implements INBTSerializable<CompoundTag> {
    public static final int HOTBAR_SLOTS = 4;
    public static final int NO_SLOT = -1;
    private final Map<ResourceKey<DragonSpecies>, Map<ResourceKey<DragonAbility>, DragonAbilityInstance>> abilities = new HashMap<ResourceKey<DragonSpecies>, Map<ResourceKey<DragonAbility>, DragonAbilityInstance>>();
    private final Map<ResourceKey<DragonSpecies>, Map<Integer, ResourceKey<DragonAbility>>> hotbar = new HashMap<ResourceKey<DragonSpecies>, Map<Integer, ResourceKey<DragonAbility>>>();
    @Nullable
    private ResourceKey<DragonSpecies> currentSpecies;
    private boolean renderAbilities = true;
    private int selectedAbilitySlot;
    private float currentMana;
    private boolean errorMessageSent;
    private boolean isCasting;
    private int castTimer;
    private final String HOTBARS = "hotbars";
    private final String ABILITIES = "abilities";
    private final String CURRENT_SPECIES = "current_species";
    private final String CURRENT_MANA = "current_mana";
    private final String SELECTED_SLOT = "selected_slot";
    private final String RENDER_ABILITIES = "render_abilities";

    public static MagicData getData(Player player) {
        return (MagicData)player.getData(DSDataAttachments.MAGIC);
    }

    public float getCurrentMana() {
        return this.currentMana;
    }

    public void setCurrentMana(float currentMana) {
        this.currentMana = Math.max(0.0f, currentMana);
    }

    public void setSelectedAbilitySlot(int newSlot) {
        this.selectedAbilitySlot = newSlot;
    }

    public int getSelectedAbilitySlot() {
        return this.selectedAbilitySlot;
    }

    public DragonAbilityInstance getSelectedAbility() {
        return this.fromSlot(this.selectedAbilitySlot);
    }

    public int getClientCastTimer() {
        return this.castTimer;
    }

    public void setCurrentSpecies(Player player, @Nullable ResourceKey<DragonSpecies> currentSpecies) {
        if (this.currentSpecies != null && this.abilities.containsKey(this.currentSpecies)) {
            this.abilities.get(this.currentSpecies).values().forEach(ability -> ability.setActive(player, false));
        }
        this.currentSpecies = currentSpecies;
        if (currentSpecies != null && this.abilities.containsKey(currentSpecies)) {
            this.abilities.get(currentSpecies).values().forEach(ability -> {
                if (ability.isPassive()) {
                    ability.setActive(player, true);
                }
            });
        }
    }

    public boolean dataForSpeciesIsEmpty(ResourceKey<DragonSpecies> species) {
        return this.abilities.get(species) == null || this.abilities.get(species).isEmpty();
    }

    @Nullable
    public DragonAbilityInstance getAbility(ResourceKey<DragonAbility> key) {
        if (this.currentSpecies == null) {
            return null;
        }
        return this.getAbilities().get(key);
    }

    public Map<ResourceKey<DragonAbility>, DragonAbilityInstance> getAbilities() {
        if (this.currentSpecies == null) {
            return Map.of();
        }
        return this.abilities.computeIfAbsent(this.currentSpecies, species -> new HashMap());
    }

    private Map<Integer, ResourceKey<DragonAbility>> getHotbar() {
        if (this.currentSpecies == null) {
            return Map.of();
        }
        return this.hotbar.computeIfAbsent(this.currentSpecies, species -> new HashMap());
    }

    @SubscribeEvent
    public static void cancelCastingOnDeath(LivingDeathEvent event) {
        Player player;
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player && DragonStateProvider.isDragon((Entity)(player = (Player)livingEntity))) {
            MagicData.getData(player).stopCasting(player);
        }
    }

    @SubscribeEvent
    public static void tickAbilities(PlayerTickEvent.Post event) {
        if (event.getEntity().isSpectator()) {
            return;
        }
        if (!DragonStateProvider.isDragon((Entity)event.getEntity())) {
            return;
        }
        Optional optional = event.getEntity().getExistingData(DSDataAttachments.MAGIC);
        if (optional.isEmpty()) {
            return;
        }
        MagicData magic = (MagicData)optional.get();
        InputData experienceLevels = InputData.experienceLevels(event.getEntity().experienceLevel);
        for (DragonAbilityInstance ability : magic.getAbilities().values()) {
            PassiveActivation passive;
            Object object = event.getEntity();
            if (object instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)object;
                ability.value().upgrade().ifPresent(upgrade -> {
                    upgrade.attempt(serverPlayer, ability, null);
                    upgrade.attempt(serverPlayer, ability, Items.AIR);
                    upgrade.attempt(serverPlayer, ability, experienceLevels);
                });
                DSAdvancementTriggers.UPGRADE_ABILITY.get().trigger(serverPlayer, ability.key(), ability.level());
            }
            ability.tickCooldown(event.getEntity());
            object = ability.value().activation();
            if (object instanceof PassiveActivation && (passive = (PassiveActivation)object).trigger().type() != ActivationTrigger.TriggerType.CONSTANT) continue;
            ability.tick(event.getEntity());
        }
        if (event.getEntity().level().isClientSide() && magic.isCasting()) {
            magic.castTimer = Math.max(0, magic.castTimer - 1);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void handleItemBasedLeveling(PlayerInteractEvent.RightClickItem event) {
        Player player = event.getEntity();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player2 = (ServerPlayer)player;
        DragonStateHandler handler = DragonStateProvider.getData((Player)player2);
        if (!handler.isDragon()) {
            return;
        }
        ItemStack stack = event.getItemStack();
        if (stack.isEmpty()) {
            return;
        }
        MagicData magic = MagicData.getData((Player)player2);
        DragonAbilityHolder abilityHolder = (DragonAbilityHolder)stack.get(DSDataComponents.DRAGON_ABILITIES);
        if (abilityHolder != null && abilityHolder.use(player2, handler, magic)) {
            stack.consume(1, (LivingEntity)player2);
            player2.playNotifySound((SoundEvent)DSSounds.UPGRADE_BEACON.get(), SoundSource.PLAYERS, 1.0f, 0.0f);
            PacketDistributor.sendToPlayer((ServerPlayer)player2, (CustomPacketPayload)new SyncMagicData(magic.serializeNBT((HolderLookup.Provider)player2.registryAccess())), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
        magic.getAbilities().values().forEach(ability -> ability.value().upgrade().ifPresent(upgrade -> {
            if (stack.isEmpty()) {
                return;
            }
            if (upgrade.attempt(player2, (DragonAbilityInstance)ability, stack.getItem())) {
                stack.consume(1, (LivingEntity)player2);
                player2.playNotifySound(SoundEvents.UI_TOAST_CHALLENGE_COMPLETE, SoundSource.PLAYERS, 1.0f, 0.0f);
            }
        }));
    }

    public void handleAutoUpgrades(ServerPlayer player, Object ... inputs) {
        if (!DragonStateProvider.isDragon((Entity)player)) {
            return;
        }
        for (DragonAbilityInstance ability : this.getAbilities().values()) {
            UpgradeType upgrade = ability.value().upgrade().orElse(null);
            if (upgrade == null) continue;
            for (Object input : inputs) {
                upgrade.attempt(player, ability, input);
            }
        }
    }

    @Nullable
    public DragonAbilityInstance fromSlot(int slot) {
        ResourceKey<DragonAbility> key = this.getHotbar().get(slot);
        return key != null ? this.getAbility(key) : null;
    }

    public int slotFromAbility(ResourceKey<DragonAbility> key) {
        for (int slot : this.getHotbar().keySet()) {
            if (this.getHotbar().get(slot) != key) continue;
            return slot;
        }
        return -1;
    }

    @Nullable
    public DragonAbilityInstance getCurrentlyCasting() {
        return this.isCasting ? this.fromSlot(this.getSelectedAbilitySlot()) : null;
    }

    public boolean attemptCast(Player player, int slot) {
        if (slot < 0 || slot >= this.getAbilities().size()) {
            return false;
        }
        DragonAbilityInstance instance = this.fromSlot(slot);
        if (instance == null) {
            return false;
        }
        if (!this.checkCast(player, instance)) {
            int cooldown = instance.getCooldown();
            if (!this.errorMessageSent && player.level().isClientSide() && cooldown != 0) {
                this.errorMessageSent = true;
                MagicHUD.castingError((Component)Component.translatable((String)MagicHUD.COOLDOWN, (Object[])new Object[]{NumberFormat.getInstance().format(Functions.ticksToSeconds(cooldown)) + "s"}).withStyle(ChatFormatting.RED));
            }
            return false;
        }
        DragonAbilityInstance currentlyCasting = this.getCurrentlyCasting();
        if (currentlyCasting != null) {
            currentlyCasting.release(player);
        }
        this.setSelectedAbilitySlot(slot);
        this.beginCasting(player);
        return true;
    }

    public void stopCasting(Player player, @Nullable DragonAbilityInstance instance, boolean withCooldown) {
        if (instance != null) {
            instance.stopSound(player);
            if (withCooldown) {
                instance.release(player);
                instance.value().activation().playEndSound(player);
                if (instance.hasEndAnimation()) {
                    instance.value().activation().playEndAnimation(player);
                } else if (!instance.isPassive()) {
                    DragonSurvival.PROXY.setCurrentAbilityAnimation(player, null);
                }
            } else if (!instance.isPassive()) {
                DragonSurvival.PROXY.setCurrentAbilityAnimation(player, null);
            }
            instance.setActive(player, false);
        }
        if (instance == null || !instance.isPassive()) {
            this.isCasting = false;
        }
    }

    public void stopCasting(Player player) {
        this.stopCasting(player, this.getCurrentlyCasting());
    }

    public void stopCasting(Player player, @Nullable DragonAbilityInstance instance) {
        this.stopCasting(player, instance, instance != null && instance.isApplyingEffects());
    }

    public void setErrorMessageSent(boolean errorMessageSent) {
        this.errorMessageSent = errorMessageSent;
    }

    private void beginCasting(Player player) {
        DragonAbilityInstance instance = this.fromSlot(this.getSelectedAbilitySlot());
        if (instance == null) {
            return;
        }
        this.isCasting = true;
        this.castTimer = instance.value().activation().getCastTime(instance.level());
        instance.setActive(player, true);
    }

    public boolean isCasting() {
        return this.isCasting && this.getCurrentlyCasting() != null;
    }

    private boolean checkCast(Player dragon, DragonAbilityInstance instance) {
        if (instance.isDisabled(false)) {
            if (dragon.level().isClientSide()) {
                MagicData magic = MagicData.getData(dragon);
                magic.setErrorMessageSent(true);
                Optional<Component> message = instance.value().activation().notification().usageBlocked();
                if (message.isPresent() && message.get().getContents() != PlainTextContents.EMPTY) {
                    MagicHUD.castingError(message.get());
                }
            }
            return false;
        }
        if (!instance.hasEnoughMana(dragon)) {
            instance.handleNotEnoughMana(dragon);
            return false;
        }
        return instance.canBeCast();
    }

    public boolean shouldRenderAbilities() {
        return this.renderAbilities;
    }

    public void setRenderAbilities(boolean renderAbilities) {
        this.renderAbilities = renderAbilities;
    }

    public int clear(ServerPlayer player) {
        int count = this.abilities.values().stream().mapToInt(Map::size).sum();
        this.abilities.values().forEach(perSpecies -> perSpecies.values().forEach(ability -> ability.setActive((Player)player, false)));
        this.abilities.clear();
        this.hotbar.clear();
        return count;
    }

    public void removeAbility(Player player, ResourceKey<DragonAbility> key) {
        int slot;
        if (this.currentSpecies == null) {
            return;
        }
        DragonAbilityInstance removed = this.getAbilities().remove(key);
        if (removed != null) {
            removed.setActive(player, false);
        }
        if ((slot = this.slotFromAbility(key)) != -1) {
            this.getHotbar().remove(slot);
        }
    }

    public void addAbility(ServerPlayer player, Holder<DragonAbility> ability) {
        DragonAbilityInstance instance;
        if (this.getAbilities().containsKey(ability.getKey())) {
            return;
        }
        UpgradeType upgrade = ((DragonAbility)ability.value()).upgrade().orElse(null);
        InputData growthInput = InputData.growth((int)DragonStateProvider.getData((Player)player).getGrowth());
        if (upgrade == null) {
            instance = new DragonAbilityInstance(ability, ((DragonAbility)ability.value()).getMaxLevel());
        } else {
            instance = new DragonAbilityInstance(ability, 0);
            upgrade.attempt(player, instance, growthInput);
        }
        if (!instance.isPassive()) {
            for (int i = 0; i < 4; ++i) {
                if (this.getHotbar().containsKey(i)) continue;
                this.getHotbar().put(i, (ResourceKey<DragonAbility>)ability.getKey());
                break;
            }
        }
        this.getAbilities().put((ResourceKey<DragonAbility>)ability.getKey(), instance);
    }

    public void refresh(ServerPlayer player, Holder<DragonSpecies> currentSpecies) {
        this.abilities.values().forEach(perSpecies -> perSpecies.values().forEach(ability -> ability.setActive((Player)player, false)));
        if (currentSpecies == null) {
            return;
        }
        this.currentSpecies = currentSpecies.getKey();
        InputData growthInput = InputData.growth((int)DragonStateProvider.getData((Player)player).getGrowth());
        int slot = 0;
        for (Holder ability : ((DragonSpecies)currentSpecies.value()).abilities()) {
            DragonAbilityInstance instance;
            UpgradeType upgrade = ((DragonAbility)ability.value()).upgrade().orElse(null);
            if (upgrade == null) {
                instance = new DragonAbilityInstance((Holder<DragonAbility>)ability, ((DragonAbility)ability.value()).getMaxLevel());
            } else {
                instance = new DragonAbilityInstance((Holder<DragonAbility>)ability, 0);
                upgrade.attempt(player, instance, growthInput);
            }
            if (slot < 4 && !instance.isPassive()) {
                this.getHotbar().put(slot, (ResourceKey<DragonAbility>)ability.getKey());
                ++slot;
            }
            this.getAbilities().put((ResourceKey<DragonAbility>)ability.getKey(), instance);
        }
    }

    public List<DragonAbilityInstance> getActiveAbilities() {
        return this.getAbilities().values().stream().filter(instance -> !instance.isPassive()).collect(Collectors.toList());
    }

    public List<DragonAbilityInstance> filterPassiveByUpgrade(Predicate<Optional<UpgradeType<?>>> predicate) {
        return this.getAbilities().values().stream().filter(instance -> instance.isPassive() && predicate.test(instance.value().upgrade())).collect(Collectors.toList());
    }

    public List<DragonAbilityInstance> filterPassiveByTrigger(Predicate<ActivationTrigger> predicate) {
        return this.getAbilities().values().stream().filter(instance -> {
            PassiveActivation passive;
            Activation patt0$temp = instance.value().activation();
            return patt0$temp instanceof PassiveActivation && predicate.test((passive = (PassiveActivation)patt0$temp).trigger());
        }).collect(Collectors.toList());
    }

    public int getCost(Player dragon, ResourceKey<DragonAbility> key, ExperiencePointsUpgrade.Type type) {
        DragonAbilityInstance ability = this.getAbility(key);
        if (ability == null) {
            return 0;
        }
        return ability.value().upgrade().map(upgrade -> {
            if (upgrade instanceof ExperiencePointsUpgrade) {
                ExperiencePointsUpgrade experiencePointsUpgrade = (ExperiencePointsUpgrade)upgrade;
                return experiencePointsUpgrade.getExperience(dragon, ability, type);
            }
            return 0;
        }).orElse(0);
    }

    public void moveAbilityToSlot(ResourceKey<DragonAbility> key, int newSlot) {
        int currentSlot = this.slotFromAbility(key);
        ResourceKey<DragonAbility> previous = this.getHotbar().put(newSlot, key);
        if (previous != null && currentSlot != -1 && newSlot != -1) {
            this.getHotbar().put(currentSlot, previous);
        } else {
            this.getHotbar().remove(currentSlot);
        }
    }

    public boolean checkAbility(Player player, Class<?> effectType, AbilityCheck check) {
        for (DragonAbilityInstance instance : this.getAbilities().values()) {
            for (ActionContainer action : instance.value().actions()) {
                if (!((Boolean)action.effect().target().map(target -> this.checkEffects(player, effectType, check, instance, target.effects(), target.targetConditions().orElse(null)), target -> this.checkEffects(player, effectType, check, instance, target.effects(), target.targetConditions().orElse(null)))).booleanValue()) continue;
                return true;
            }
        }
        return false;
    }

    private <T> boolean checkEffects(Player player, Class<?> effectType, AbilityCheck check, DragonAbilityInstance instance, List<T> effects, @Nullable LootItemCondition condition) {
        for (T effect : effects) {
            if (!effectType.isInstance(effect)) continue;
            if (check == AbilityCheck.HAS_EFFECT) {
                return true;
            }
            if (!(player instanceof ServerPlayer)) continue;
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (check != AbilityCheck.IS_EFFECT_UNLOCKED || !instance.isApplyingEffects()) continue;
            return condition == null || condition.test((Object)Condition.abilityContext(serverPlayer));
        }
        return false;
    }

    public CompoundTag serializeNBTForCurrentSpecies(@NotNull HolderLookup.Provider provider) {
        CompoundTag tag = new CompoundTag();
        CompoundTag speciesAbilities = new CompoundTag();
        this.abilities.get(this.currentSpecies).values().forEach(instance -> speciesAbilities.put(instance.key().location().toString(), instance.save(provider)));
        CompoundTag speciesHotbar = new CompoundTag();
        this.hotbar.get(this.currentSpecies).forEach((slot, key) -> speciesHotbar.putInt(key.location().toString(), slot.intValue()));
        tag.put("abilities", (Tag)speciesAbilities);
        tag.put("hotbars", (Tag)speciesHotbar);
        return tag;
    }

    public void deserializeNBTForCurrentSpecies(@NotNull HolderLookup.Provider provider, @NotNull CompoundTag tag) {
        if (this.currentSpecies == null) {
            DragonSurvival.LOGGER.warn("Current species is not set - ability data cannot be deserialized [{}]", (Object)tag);
            return;
        }
        this.abilities.get(this.currentSpecies).clear();
        this.hotbar.get(this.currentSpecies).clear();
        if (tag.contains("abilities")) {
            CompoundTag storedAbilities = tag.getCompound("abilities");
            storedAbilities.getAllKeys().forEach(abilityLocation -> {
                CompoundTag abilityTag = storedAbilities.getCompound(abilityLocation);
                DragonAbilityInstance instance = DragonAbilityInstance.load(provider, abilityTag);
                if (instance != null) {
                    this.abilities.get(this.currentSpecies).put(instance.key(), instance);
                }
            });
        }
        if (tag.contains("hotbars")) {
            CompoundTag storedHotbar = tag.getCompound("hotbars");
            storedHotbar.getAllKeys().forEach(abilityLocation -> {
                int slot = storedHotbar.getInt(abilityLocation);
                ResourceKey key = ResourceKey.create(DragonAbility.REGISTRY, (ResourceLocation)ResourceLocation.parse((String)abilityLocation));
                if (provider.holder(key).isEmpty()) {
                    return;
                }
                this.hotbar.get(this.currentSpecies).put(slot, (ResourceKey<DragonAbility>)key);
            });
        }
    }

    public CompoundTag serializeNBT(@NotNull HolderLookup.Provider provider) {
        CompoundTag tag = new CompoundTag();
        CompoundTag allAbilities = new CompoundTag();
        for (Map.Entry<ResourceKey<DragonSpecies>, Map<ResourceKey<DragonAbility>, DragonAbilityInstance>> entry : this.abilities.entrySet()) {
            CompoundTag abilities = new CompoundTag();
            entry.getValue().values().forEach(instance -> abilities.put(instance.key().location().toString(), instance.save(provider)));
            allAbilities.put(entry.getKey().location().toString(), (Tag)abilities);
        }
        CompoundTag allHotbars = new CompoundTag();
        for (Map.Entry<ResourceKey<DragonSpecies>, Map<Integer, ResourceKey<DragonAbility>>> entry : this.hotbar.entrySet()) {
            CompoundTag hotbar = new CompoundTag();
            entry.getValue().forEach((slot, key) -> hotbar.putInt(key.location().toString(), slot.intValue()));
            allHotbars.put(entry.getKey().location().toString(), (Tag)hotbar);
        }
        tag.put("abilities", (Tag)allAbilities);
        tag.put("hotbars", (Tag)allHotbars);
        tag.putFloat("current_mana", this.currentMana);
        tag.putInt("selected_slot", this.selectedAbilitySlot);
        tag.putBoolean("render_abilities", this.renderAbilities);
        if (this.currentSpecies != null) {
            tag.putString("current_species", this.currentSpecies.location().toString());
        }
        return tag;
    }

    public void deserializeNBT(@NotNull HolderLookup.Provider provider, @NotNull CompoundTag tag) {
        ResourceKey speciesKey;
        this.abilities.clear();
        this.hotbar.clear();
        if (tag.contains("abilities")) {
            for (String speciesLocation : tag.getCompound("abilities").getAllKeys()) {
                speciesKey = ResourceKey.create(DragonSpecies.REGISTRY, (ResourceLocation)ResourceLocation.parse((String)speciesLocation));
                if (provider.holder(speciesKey).isEmpty()) continue;
                HashMap<ResourceKey<DragonAbility>, DragonAbilityInstance> abilities = new HashMap<ResourceKey<DragonAbility>, DragonAbilityInstance>();
                CompoundTag storedAbilities = tag.getCompound("abilities").getCompound(speciesLocation);
                for (String abilityLocation : storedAbilities.getAllKeys()) {
                    CompoundTag abilityTag = storedAbilities.getCompound(abilityLocation);
                    DragonAbilityInstance instance = DragonAbilityInstance.load(provider, abilityTag);
                    if (instance == null) continue;
                    abilities.put(instance.key(), instance);
                }
                this.abilities.put((ResourceKey<DragonSpecies>)speciesKey, abilities);
            }
        }
        if (tag.contains("hotbars")) {
            for (String speciesLocation : tag.getCompound("hotbars").getAllKeys()) {
                speciesKey = ResourceKey.create(DragonSpecies.REGISTRY, (ResourceLocation)ResourceLocation.parse((String)speciesLocation));
                if (provider.holder(speciesKey).isEmpty()) continue;
                HashMap<Integer, ResourceKey> hotbar = new HashMap<Integer, ResourceKey>();
                CompoundTag storedHotbar = tag.getCompound("hotbars").getCompound(speciesLocation);
                for (String abilityLocation : storedHotbar.getAllKeys()) {
                    int slot = storedHotbar.getInt(abilityLocation);
                    ResourceKey key = ResourceKey.create(DragonAbility.REGISTRY, (ResourceLocation)ResourceLocation.parse((String)abilityLocation));
                    if (provider.holder(key).isEmpty()) continue;
                    hotbar.put(slot, key);
                }
                this.hotbar.put((ResourceKey<DragonSpecies>)speciesKey, hotbar);
            }
        }
        this.currentMana = tag.getFloat("current_mana");
        this.selectedAbilitySlot = tag.getInt("selected_slot");
        this.renderAbilities = tag.getBoolean("render_abilities");
        if (tag.contains("current_species")) {
            this.currentSpecies = ResourceKey.create(DragonSpecies.REGISTRY, (ResourceLocation)ResourceLocation.parse((String)tag.getString("current_species")));
            if (provider.holder(this.currentSpecies).isEmpty()) {
                DragonSurvival.LOGGER.warn("Failed to load current species for magic data! Did you remove a species from this save? Defaulting to cave dragon");
                this.currentSpecies = BuiltInDragonSpecies.CAVE_DRAGON;
            }
        }
    }

    public static enum AbilityCheck {
        HAS_EFFECT,
        IS_EFFECT_UNLOCKED;

    }
}

