/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.registry.attachments;

import by.dragonsurvivalteam.dragonsurvival.common.handlers.magic.HunterHandler;
import by.dragonsurvivalteam.dragonsurvival.registry.attachments.DSDataAttachments;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.LivingEntity;
import net.neoforged.neoforge.common.util.INBTSerializable;
import org.jetbrains.annotations.NotNull;

public class HunterData
implements INBTSerializable<CompoundTag> {
    private int hunterStacks;
    private boolean transparencyDisabled;

    public static boolean hasTransparency(LivingEntity entity) {
        HunterData data = entity.getExistingData(DSDataAttachments.HUNTER).orElse(null);
        if (data == null) {
            return false;
        }
        return data.hasTransparency();
    }

    public static boolean hasMaxHunterStacks(LivingEntity entity) {
        HunterData data = entity.getExistingData(DSDataAttachments.HUNTER).orElse(null);
        if (data == null) {
            return false;
        }
        return data.hasMaxHunterStacks();
    }

    public boolean hasTransparency() {
        if (this.transparencyDisabled) {
            return false;
        }
        return this.hasHunterStacks();
    }

    public void modifyHunterStacks(int modification) {
        this.hunterStacks = Math.clamp((long)(this.hunterStacks + modification), 0, HunterHandler.getMaxStacks());
    }

    public boolean hasMaxHunterStacks() {
        return this.hunterStacks == HunterHandler.getMaxStacks();
    }

    public boolean hasHunterStacks() {
        return this.hunterStacks > 0;
    }

    public void clearHunterStacks() {
        this.hunterStacks = 0;
    }

    public int getHunterStacks() {
        return this.hunterStacks;
    }

    public void disableTransparency() {
        this.transparencyDisabled = true;
    }

    public void enableTransparency() {
        this.transparencyDisabled = false;
    }

    public CompoundTag serializeNBT(@NotNull HolderLookup.Provider provider) {
        return new CompoundTag();
    }

    public void deserializeNBT(@NotNull HolderLookup.Provider provider, @NotNull CompoundTag tag) {
    }
}

