/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.registry.attachments;

import by.dragonsurvivalteam.dragonsurvival.DragonSurvival;
import by.dragonsurvivalteam.dragonsurvival.network.magic.SyncData;
import by.dragonsurvivalteam.dragonsurvival.registry.attachments.DSDataAttachments;
import by.dragonsurvivalteam.dragonsurvival.registry.datagen.Translation;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.ability.ClientEffectProvider;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import java.util.Objects;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.common.util.INBTSerializable;
import net.neoforged.neoforge.fluids.FluidType;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.registries.NeoForgeRegistries;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FlightData
implements INBTSerializable<CompoundTag> {
    public static final ResourceLocation DEFAULT_ICON = DragonSurvival.res("textures/ability_effect/generic_icons/dragon_wings.png");
    public ResourceLocation icon = DEFAULT_ICON;
    @Nullable
    public HolderSet<FluidType> inFluid;
    public boolean areWingsSpread;
    public boolean hasFlight;
    public boolean hasSpin;
    public int cooldown;
    public int duration;
    public static final ClientEffectProvider FLIGHT_EFFECT = new ClientEffectProvider(){
        @Translation(type=Translation.Type.GUI, comments={"Dragon Wings"})
        private static final ResourceLocation NAME = DragonSurvival.res("dragon_wings");
        private static final ResourceLocation ID = DragonSurvival.res("dragon_wings");
        private static final Component TRANSLATED_NAME = Component.translatable((String)Translation.Type.GUI.wrap(NAME));

        @Override
        public Component getDescription() {
            return Component.empty();
        }

        @Override
        public ClientEffectProvider.ClientData clientData() {
            Player player = DragonSurvival.PROXY.getLocalPlayer();
            ResourceLocation icon = player != null ? FlightData.getData((Player)player).icon : DEFAULT_ICON;
            return new ClientEffectProvider.ClientData(ID, icon, TRANSLATED_NAME, CommonComponents.EMPTY);
        }

        @Override
        public int getDuration() {
            return -1;
        }

        @Override
        public int currentDuration() {
            return 0;
        }
    };
    private static final String COOLDOWN = "cooldown";
    private static final String DURATION = "duration";
    private static final String FLIGHT = "flight";
    private static final String SPIN = "spin";
    private static final String ARE_WINGS_SPREAD = "are_wings_spread";
    private static final String IN_FLUID = "in_fluid";
    private static final String ICON = "icon";

    public static FlightData getData(Player player) {
        return (FlightData)player.getData(DSDataAttachments.FLIGHT);
    }

    public CompoundTag serializeNBT(@NotNull HolderLookup.Provider provider) {
        CompoundTag tag = new CompoundTag();
        tag.putBoolean(ARE_WINGS_SPREAD, this.areWingsSpread);
        tag.putBoolean(FLIGHT, this.hasFlight);
        tag.putBoolean(SPIN, this.hasSpin);
        tag.putInt(COOLDOWN, this.cooldown);
        tag.putInt(DURATION, this.duration);
        if (this.inFluid != null) {
            RegistryCodecs.homogeneousList((ResourceKey)NeoForgeRegistries.Keys.FLUID_TYPES).encodeStart((DynamicOps)provider.createSerializationContext((DynamicOps)NbtOps.INSTANCE), this.inFluid).resultOrPartial(arg_0 -> ((Logger)DragonSurvival.LOGGER).error(arg_0)).ifPresent(list -> tag.put(IN_FLUID, list));
        }
        tag.putString(ICON, this.icon.toString());
        return tag;
    }

    public void deserializeNBT(@NotNull HolderLookup.Provider provider, @NotNull CompoundTag tag) {
        this.areWingsSpread = tag.getBoolean(ARE_WINGS_SPREAD);
        this.hasFlight = tag.getBoolean(FLIGHT);
        this.hasSpin = tag.getBoolean(SPIN);
        this.cooldown = tag.getInt(COOLDOWN);
        this.duration = tag.getInt(DURATION);
        this.inFluid = tag.contains(IN_FLUID) ? (HolderSet)RegistryCodecs.homogeneousList((ResourceKey)NeoForgeRegistries.Keys.FLUID_TYPES).decode((DynamicOps)provider.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)tag.get(IN_FLUID)).resultOrPartial(arg_0 -> ((Logger)DragonSurvival.LOGGER).error(arg_0)).map(Pair::getFirst).orElse(null) : null;
        this.icon = Objects.requireNonNullElse(ResourceLocation.tryParse((String)tag.getString(ICON)), DEFAULT_ICON);
    }

    public void sync(ServerPlayer player) {
        PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new SyncData(player.getId(), DSDataAttachments.FLIGHT.getId(), this.serializeNBT((HolderLookup.Provider)player.registryAccess())), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public void sync(ServerPlayer source, ServerPlayer target) {
        PacketDistributor.sendToPlayer((ServerPlayer)target, (CustomPacketPayload)new SyncData(source.getId(), DSDataAttachments.FLIGHT.getId(), this.serializeNBT((HolderLookup.Provider)source.registryAccess())), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public boolean hasFlight() {
        return this.hasFlight;
    }

    public boolean isWingsSpread() {
        return this.hasFlight && this.areWingsSpread;
    }
}

