/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.registry.attachments;

import by.dragonsurvivalteam.dragonsurvival.DragonSurvival;
import by.dragonsurvivalteam.dragonsurvival.common.capability.DragonStateProvider;
import by.dragonsurvivalteam.dragonsurvival.common.handlers.magic.ClawToolHandler;
import by.dragonsurvivalteam.dragonsurvival.network.claw.SyncDragonClawsMenu;
import by.dragonsurvivalteam.dragonsurvival.registry.attachments.DSDataAttachments;
import by.dragonsurvivalteam.dragonsurvival.util.ToolUtils;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import java.util.Locale;
import java.util.Optional;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.common.util.INBTSerializable;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;

public class ClawInventoryData
implements INBTSerializable<CompoundTag> {
    public static final String IS_MENU_OPEN = "is_menu_open";
    public static final String SHOULD_RENDER_CLAWS = "should_render_claws";
    public boolean shouldRenderClaws = true;
    public ItemStack storedMainHandTool = ItemStack.EMPTY;
    public boolean switchedTool;
    public int switchedToolSlot = -1;
    private final SimpleContainer clawsInventory = new SimpleContainer(4);
    private boolean isMenuOpen = true;
    private int toolSwapLayer;

    public void swapStart(Player player, BlockState blockState) {
        Pair<ItemStack, Integer> data = ClawToolHandler.getDragonHarvestToolAndSlot(player, blockState);
        ItemStack dragonHarvestTool = (ItemStack)data.getFirst();
        int toolSlot = (Integer)data.getSecond();
        this.swapStart(player, dragonHarvestTool, toolSlot);
    }

    public void swapStart(Player player, ItemStack tool, int slot) {
        if (slot == -1 || player.isCreative() || player.isSpectator() || !DragonStateProvider.isDragon((Entity)player)) {
            return;
        }
        ItemStack mainHand = player.getItemInHand(InteractionHand.MAIN_HAND);
        if (!this.switchedTool) {
            player.setItemInHand(InteractionHand.MAIN_HAND, tool);
            tool.forEachModifier(EquipmentSlot.MAINHAND, (attribute, modifier) -> {
                Level patt0$temp;
                AttributeInstance instance = player.getAttributes().getInstance(attribute);
                if (instance != null) {
                    instance.removeModifier(modifier.id());
                    instance.addTransientModifier(modifier);
                }
                if ((patt0$temp = player.level()) instanceof ServerLevel) {
                    ServerLevel serverlevel = (ServerLevel)patt0$temp;
                    EnchantmentHelper.runLocationChangedEffects((ServerLevel)serverlevel, (ItemStack)tool, (LivingEntity)player, (EquipmentSlot)EquipmentSlot.MAINHAND);
                }
            });
            this.clawsInventory.setItem(slot, ItemStack.EMPTY);
            this.storedMainHandTool = mainHand;
            this.switchedTool = true;
            this.switchedToolSlot = slot;
        }
        ++this.toolSwapLayer;
    }

    public void swapFinish(Player player) {
        if (!this.switchedTool) {
            this.toolSwapLayer = 0;
            return;
        }
        if (player.isCreative() || player.isSpectator() || !DragonStateProvider.isDragon((Entity)player)) {
            return;
        }
        --this.toolSwapLayer;
        if (this.toolSwapLayer < 0) {
            DragonSurvival.LOGGER.warn("Tool swap layer was lower than 0 - this should not happen");
            this.toolSwapLayer = 0;
        }
        if (this.toolSwapLayer == 0) {
            ItemStack originalMainHand = this.storedMainHandTool;
            ItemStack originalToolSlot = player.getItemInHand(InteractionHand.MAIN_HAND);
            originalToolSlot.forEachModifier(EquipmentSlot.MAINHAND, (attributeHolder, attributeModifier) -> {
                AttributeInstance attributeinstance = player.getAttributes().getInstance(attributeHolder);
                if (attributeinstance != null) {
                    attributeinstance.removeModifier(attributeModifier);
                }
                EnchantmentHelper.stopLocationBasedEffects((ItemStack)originalToolSlot, (LivingEntity)player, (EquipmentSlot)EquipmentSlot.MAINHAND);
            });
            player.setItemInHand(InteractionHand.MAIN_HAND, originalMainHand);
            this.clawsInventory.setItem(this.switchedToolSlot, originalToolSlot);
            this.storedMainHandTool = ItemStack.EMPTY;
            this.switchedTool = false;
            this.switchedToolSlot = -1;
        }
    }

    public static void reInsertClawTools(Player player) {
        SimpleContainer clawsContainer = ClawInventoryData.getData(player).getContainer();
        for (int i = 0; i < 4; ++i) {
            ServerPlayer serverPlayer;
            ItemStack stack = clawsContainer.getItem(i);
            if (!(player instanceof ServerPlayer) || (serverPlayer = (ServerPlayer)player).addItem(stack)) continue;
            serverPlayer.level().addFreshEntity((Entity)new ItemEntity(serverPlayer.level(), serverPlayer.position().x, serverPlayer.position().y, serverPlayer.position().z, stack));
        }
        clawsContainer.clearContent();
    }

    public void set(Slot slot, ItemStack stack) {
        this.clawsInventory.setItem(slot.ordinal(), stack);
    }

    public ItemStack get(Slot slot) {
        return this.clawsInventory.getItem(slot.ordinal());
    }

    public ItemStack getSword() {
        return this.clawsInventory.getItem(Slot.SWORD.ordinal());
    }

    public ItemStack getPickaxe() {
        return this.clawsInventory.getItem(Slot.PICKAXE.ordinal());
    }

    public ItemStack getAxe() {
        return this.clawsInventory.getItem(Slot.AXE.ordinal());
    }

    public ItemStack getShovel() {
        return this.clawsInventory.getItem(Slot.SHOVEL.ordinal());
    }

    public void setMenuOpen(boolean isMenuOpen) {
        this.isMenuOpen = isMenuOpen;
    }

    public SimpleContainer getContainer() {
        return this.clawsInventory;
    }

    public boolean isMenuOpen() {
        return this.isMenuOpen;
    }

    public ItemStack getTool(BlockState state) {
        ItemStack currentTool = ItemStack.EMPTY;
        int currentLevel = 0;
        for (int slot = 0; slot < Slot.size(); ++slot) {
            ItemStack tool = this.getContainer().getItem(slot);
            int level = ToolUtils.toolToHarvestLevel(tool);
            if (level <= currentLevel || !ToolUtils.isCorrectTool(tool, state)) continue;
            currentTool = tool;
            currentLevel = level;
        }
        return currentTool;
    }

    public void sync(Player player) {
        if (player.level().isClientSide()) {
            return;
        }
        PacketDistributor.sendToPlayersTrackingEntityAndSelf((Entity)player, (CustomPacketPayload)new SyncDragonClawsMenu(player.getId(), this.isMenuOpen, this.serializeNBT((HolderLookup.Provider)player.registryAccess())), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static ClawInventoryData getData(Player player) {
        return (ClawInventoryData)player.getData(DSDataAttachments.CLAW_INVENTORY);
    }

    public CompoundTag serializeNBT(@NotNull HolderLookup.Provider provider) {
        CompoundTag tag = new CompoundTag();
        tag.putBoolean(IS_MENU_OPEN, this.isMenuOpen);
        for (Slot slot : Slot.values()) {
            if (this.clawsInventory.getItem(slot.ordinal()).isEmpty()) continue;
            tag.put(slot.name(), this.clawsInventory.getItem(slot.ordinal()).save(provider));
        }
        tag.putBoolean(SHOULD_RENDER_CLAWS, this.shouldRenderClaws);
        return tag;
    }

    public void deserializeNBT(@NotNull HolderLookup.Provider provider, @NotNull CompoundTag tag) {
        this.setMenuOpen(tag.getBoolean(IS_MENU_OPEN));
        this.shouldRenderClaws = tag.getBoolean(SHOULD_RENDER_CLAWS);
        for (Slot slot : Slot.values()) {
            Optional stack;
            CompoundTag slotTag = tag.getCompound(slot.name());
            if (slotTag.isEmpty() || (stack = ItemStack.parse((HolderLookup.Provider)provider, (Tag)slotTag)).isEmpty()) continue;
            this.clawsInventory.setItem(slot.ordinal(), (ItemStack)stack.get());
        }
    }

    public static enum Slot implements StringRepresentable
    {
        SWORD("gui/dragon_claws_sword"),
        PICKAXE("gui/dragon_claws_pickaxe"),
        AXE("gui/dragon_claws_axe"),
        SHOVEL("gui/dragon_claws_shovel");

        public static Codec<Slot> CODEC;
        private final ResourceLocation emptyTexture;

        private Slot(String path) {
            this.emptyTexture = DragonSurvival.res(path);
        }

        public ResourceLocation getEmptyTexture() {
            return this.emptyTexture;
        }

        public static int size() {
            return Slot.values().length;
        }

        @NotNull
        public String getSerializedName() {
            return this.name().toLowerCase(Locale.ENGLISH);
        }

        static {
            CODEC = StringRepresentable.fromValues(Slot::values);
        }
    }
}

