/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.registry;

import by.dragonsurvivalteam.dragonsurvival.common.capability.DragonStateHandler;
import by.dragonsurvivalteam.dragonsurvival.common.capability.DragonStateProvider;
import by.dragonsurvivalteam.dragonsurvival.common.codecs.ModifierType;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.AttributeModifierSupplier;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.DragonSpecies;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.body.DragonBody;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.stage.DragonStage;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.Nullable;

public class DSModifiers {
    public static void updateAllModifiers(@Nullable Player player) {
        if (player == null || player.level().isClientSide()) {
            return;
        }
        float healthPercentage = player.getHealth() / player.getMaxHealth();
        DragonStateHandler handler = DragonStateProvider.getData(player);
        DSModifiers.updateTypeModifiers(player, handler);
        DSModifiers.updateGrowthModifiers(player, handler);
        DSModifiers.updateBodyModifiers(player, handler);
        player.setHealth(player.getMaxHealth() * healthPercentage);
    }

    public static void clearModifiers(@Nullable Player player) {
        if (player == null || player.level().isClientSide()) {
            return;
        }
        float healthPercentage = player.getHealth() / player.getMaxHealth();
        AttributeModifierSupplier.removeModifiers(ModifierType.DRAGON_TYPE, (LivingEntity)player);
        AttributeModifierSupplier.removeModifiers(ModifierType.DRAGON_STAGE, (LivingEntity)player);
        AttributeModifierSupplier.removeModifiers(ModifierType.DRAGON_BODY, (LivingEntity)player);
        player.setHealth(player.getMaxHealth() * healthPercentage);
    }

    public static void updateTypeModifiers(@Nullable Player player, DragonStateHandler handler) {
        if (player == null || player.level().isClientSide()) {
            return;
        }
        float healthPercentage = player.getHealth() / player.getMaxHealth();
        AttributeModifierSupplier.removeModifiers(ModifierType.DRAGON_TYPE, (LivingEntity)player);
        if (handler.isDragon()) {
            ((DragonSpecies)handler.species().value()).applyModifiers((LivingEntity)player);
        }
        player.setHealth(player.getMaxHealth() * healthPercentage);
    }

    public static void updateGrowthModifiers(@Nullable Player player, DragonStateHandler handler) {
        if (player == null) {
            return;
        }
        float healthPercentage = player.getHealth() / player.getMaxHealth();
        AttributeModifierSupplier.removeModifiers(ModifierType.DRAGON_STAGE, (LivingEntity)player);
        if (handler.isDragon()) {
            ((DragonStage)handler.stage().value()).applyModifiers((LivingEntity)player, handler.getGrowth() - ((DragonStage)handler.stage().value()).growthRange().min());
        }
        player.setHealth(player.getMaxHealth() * healthPercentage);
    }

    public static void updateBodyModifiers(@Nullable Player player, DragonStateHandler handler) {
        if (player == null || player.level().isClientSide()) {
            return;
        }
        float healthPercentage = player.getHealth() / player.getMaxHealth();
        AttributeModifierSupplier.removeModifiers(ModifierType.DRAGON_BODY, (LivingEntity)player);
        if (handler.isDragon()) {
            ((DragonBody)handler.body().value()).applyModifiers((LivingEntity)player);
        }
        player.setHealth(player.getMaxHealth() * healthPercentage);
    }
}

