/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.network.magic;

import by.dragonsurvivalteam.dragonsurvival.DragonSurvival;
import by.dragonsurvivalteam.dragonsurvival.registry.attachments.DSDataAttachments;
import by.dragonsurvivalteam.dragonsurvival.registry.attachments.SummonData;
import by.dragonsurvivalteam.dragonsurvival.registry.attachments.SummonedEntities;
import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.codec.NeoForgeStreamCodecs;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;

public record SyncSummonedEntitiesBehaviour(SummonedEntities.AttackBehaviour attackBehaviour, SummonedEntities.MovementBehaviour movementBehaviour) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<SyncSummonedEntitiesBehaviour> TYPE = new CustomPacketPayload.Type(DragonSurvival.res("sync_summoned_entities_behaviour"));
    public static final StreamCodec<FriendlyByteBuf, SyncSummonedEntitiesBehaviour> STREAM_CODEC = StreamCodec.composite((StreamCodec)NeoForgeStreamCodecs.enumCodec(SummonedEntities.AttackBehaviour.class), SyncSummonedEntitiesBehaviour::attackBehaviour, (StreamCodec)NeoForgeStreamCodecs.enumCodec(SummonedEntities.MovementBehaviour.class), SyncSummonedEntitiesBehaviour::movementBehaviour, SyncSummonedEntitiesBehaviour::new);

    public static void handleServer(SyncSummonedEntitiesBehaviour packet, IPayloadContext context) {
        context.enqueueWork(() -> {
            SummonedEntities summonData = (SummonedEntities)context.player().getData(DSDataAttachments.SUMMONED_ENTITIES);
            summonData.attackBehaviour = packet.attackBehaviour();
            summonData.movementBehaviour = packet.movementBehaviour();
            Level patt0$temp = context.player().level();
            if (patt0$temp instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)patt0$temp;
                summonData.all().forEach(instance -> {
                    for (UUID uuid : instance.entityUUIDs()) {
                        Entity entity = serverLevel.getEntity(uuid);
                        if (entity == null) continue;
                        SummonData data = (SummonData)entity.getData(DSDataAttachments.SUMMON);
                        data.attackBehaviour = packet.attackBehaviour();
                        data.movementBehaviour = packet.movementBehaviour();
                        if (data.attackBehaviour != SummonedEntities.AttackBehaviour.PASSIVE || !(entity instanceof Mob)) continue;
                        Mob mob = (Mob)entity;
                        mob.setTarget(null);
                    }
                });
            }
        });
    }

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

