/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.network.flight;

import by.dragonsurvivalteam.dragonsurvival.DragonSurvival;
import by.dragonsurvivalteam.dragonsurvival.client.handlers.ClientFlightHandler;
import by.dragonsurvivalteam.dragonsurvival.registry.attachments.FlightData;
import java.util.Optional;
import net.minecraft.core.HolderSet;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.fluids.FluidType;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.neoforged.neoforge.registries.NeoForgeRegistries;
import org.jetbrains.annotations.NotNull;

public record SyncSpinStatus(int playerId, boolean hasSpin, Optional<HolderSet<FluidType>> swimSpinFluid) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<SyncSpinStatus> TYPE = new CustomPacketPayload.Type(DragonSurvival.res("sync_spin_status"));
    public static final StreamCodec<RegistryFriendlyByteBuf, SyncSpinStatus> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.VAR_INT, SyncSpinStatus::playerId, (StreamCodec)ByteBufCodecs.BOOL, SyncSpinStatus::hasSpin, (StreamCodec)ByteBufCodecs.optional((StreamCodec)ByteBufCodecs.holderSet((ResourceKey)NeoForgeRegistries.Keys.FLUID_TYPES)), SyncSpinStatus::swimSpinFluid, SyncSpinStatus::new);

    public static void handleClient(SyncSpinStatus packet, IPayloadContext context) {
        context.enqueueWork(() -> {
            Entity patt0$temp = context.player().level().getEntity(packet.playerId());
            if (patt0$temp instanceof Player) {
                Player player = (Player)patt0$temp;
                FlightData spin = FlightData.getData(player);
                spin.hasSpin = packet.hasSpin();
                spin.inFluid = packet.swimSpinFluid().orElse(null);
                ClientFlightHandler.lastSync = player.tickCount;
            }
        });
    }

    public static void handleServer(SyncSpinStatus packet, IPayloadContext context) {
        context.enqueueWork(() -> {
            Entity patt0$temp = context.player().level().getEntity(packet.playerId());
            if (patt0$temp instanceof Player) {
                Player player = (Player)patt0$temp;
                FlightData spin = FlightData.getData(player);
                spin.hasSpin = packet.hasSpin();
                spin.inFluid = packet.swimSpinFluid().orElse(null);
            }
        }).thenRun(() -> PacketDistributor.sendToPlayersTrackingEntityAndSelf((Entity)context.player(), (CustomPacketPayload)packet, (CustomPacketPayload[])new CustomPacketPayload[0]));
    }

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

