/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.network.flight;

import by.dragonsurvivalteam.dragonsurvival.DragonSurvival;
import by.dragonsurvivalteam.dragonsurvival.registry.attachments.FlightData;
import io.netty.buffer.ByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;

public record FlightStatus(int playerId, boolean hasFlight) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<FlightStatus> TYPE = new CustomPacketPayload.Type(DragonSurvival.res("sync_flight_status"));
    public static final StreamCodec<ByteBuf, FlightStatus> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, FlightStatus::playerId, (StreamCodec)ByteBufCodecs.BOOL, FlightStatus::hasFlight, FlightStatus::new);

    public static void handleClient(FlightStatus packet, IPayloadContext context) {
        context.enqueueWork(() -> {
            Entity patt0$temp = context.player().level().getEntity(packet.playerId());
            if (patt0$temp instanceof Player) {
                Player player = (Player)patt0$temp;
                FlightData data = FlightData.getData(player);
                data.hasFlight = packet.hasFlight;
            }
        });
    }

    public static void handleServer(FlightStatus packet, IPayloadContext context) {
        context.enqueueWork(() -> {
            Entity patt0$temp = context.player().level().getEntity(packet.playerId());
            if (patt0$temp instanceof Player) {
                Player player = (Player)patt0$temp;
                FlightData data = FlightData.getData(player);
                data.hasFlight = packet.hasFlight;
            }
        }).thenRun(() -> PacketDistributor.sendToPlayersTrackingEntityAndSelf((Entity)context.player(), (CustomPacketPayload)packet, (CustomPacketPayload[])new CustomPacketPayload[0]));
    }

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

