/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.network.client;

import by.dragonsurvivalteam.dragonsurvival.client.gui.screens.DragonAltarScreen;
import by.dragonsurvivalteam.dragonsurvival.client.gui.screens.dragon_editor.DragonEditorScreen;
import by.dragonsurvivalteam.dragonsurvival.client.render.ClientDragonRenderer;
import by.dragonsurvivalteam.dragonsurvival.client.render.entity.dragon.DragonRenderer;
import by.dragonsurvivalteam.dragonsurvival.common.capability.DragonStateHandler;
import by.dragonsurvivalteam.dragonsurvival.common.capability.DragonStateProvider;
import by.dragonsurvivalteam.dragonsurvival.common.codecs.UnlockableBehavior;
import by.dragonsurvivalteam.dragonsurvival.network.claw.SyncDragonClawRender;
import by.dragonsurvivalteam.dragonsurvival.network.container.OpenDragonAltar;
import by.dragonsurvivalteam.dragonsurvival.network.container.OpenDragonEditor;
import by.dragonsurvivalteam.dragonsurvival.network.dragon_editor.SyncDragonSkinSettings;
import by.dragonsurvivalteam.dragonsurvival.network.dragon_editor.SyncPlayerSkinPreset;
import by.dragonsurvivalteam.dragonsurvival.network.particle.SyncBreathParticles;
import by.dragonsurvivalteam.dragonsurvival.network.particle.SyncParticleTrail;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.DragonSpecies;
import by.dragonsurvivalteam.dragonsurvival.util.ResourceHelper;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.network.PacketDistributor;

public class ClientProxy {
    public static void sendClientData() {
        LocalPlayer localPlayer = Minecraft.getInstance().player;
        if (localPlayer == null) {
            return;
        }
        DragonStateHandler data = DragonStateProvider.getData((Player)localPlayer);
        if (!data.isDragon()) {
            return;
        }
        PacketDistributor.sendToServer((CustomPacketPayload)new SyncDragonClawRender(localPlayer.getId(), ClientDragonRenderer.renderDragonClaws), (CustomPacketPayload[])new CustomPacketPayload[0]);
        PacketDistributor.sendToServer((CustomPacketPayload)new SyncDragonSkinSettings(localPlayer.getId(), ClientDragonRenderer.renderCustomSkin), (CustomPacketPayload[])new CustomPacketPayload[0]);
        PacketDistributor.sendToServer((CustomPacketPayload)new SyncPlayerSkinPreset(localPlayer.getId(), data.speciesKey(), data.getCurrentSkinPreset().serializeNBT((HolderLookup.Provider)localPlayer.registryAccess())), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static void openDragonAltar() {
        PacketDistributor.sendToServer((CustomPacketPayload)new OpenDragonAltar(List.of()), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static void openDragonAltar(List<UnlockableBehavior.SpeciesEntry> entries) {
        Minecraft.getInstance().setScreen((Screen)new DragonAltarScreen(entries));
    }

    public static void openDragonEditor(ResourceKey<DragonSpecies> species, boolean fromAltar) {
        PacketDistributor.sendToServer((CustomPacketPayload)new OpenDragonEditor(species, List.of(), fromAltar), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static void openDragonEditor(List<UnlockableBehavior.BodyEntry> entries, ResourceKey<DragonSpecies> species, boolean fromAltar) {
        Optional<Holder.Reference<DragonSpecies>> speciesHolder = ResourceHelper.get(null, species);
        if (speciesHolder.isEmpty()) {
            Minecraft.getInstance().setScreen(null);
        } else {
            Minecraft.getInstance().setScreen((Screen)new DragonEditorScreen((Holder<DragonSpecies>)((Holder)speciesHolder.get()), entries, fromAltar));
        }
    }

    public static void handleSyncParticleTrail(SyncParticleTrail message) {
        Vec3 source = new Vec3((double)message.source().x(), (double)message.source().y(), (double)message.source().z());
        Vec3 target = new Vec3((double)message.target().x(), (double)message.target().y(), (double)message.target().z());
        int steps = Math.max(20, (int)Math.ceil(source.distanceTo(target) * 2.5));
        float stepSize = 1.0f / (float)steps;
        Vec3 distV = new Vec3(source.x - target.x, source.y - target.y, source.z - target.z);
        for (int i = 0; i < steps; ++i) {
            Vec3 step = target.add(distV.scale((double)(stepSize * (float)i)));
            Minecraft.getInstance().level.addParticle(message.trailParticle(), step.x(), step.y(), step.z(), 0.0, 0.0, 0.0);
        }
    }

    public static void handleBreathParticles(SyncBreathParticles packet, Player receiver) {
        int i;
        Player player;
        DragonStateHandler handler;
        Entity entity = receiver.level().getEntity(packet.playerId());
        if (!(entity instanceof Entity)) {
            return;
        }
        Entity entity2 = entity;
        double speedMultiplier = 20.0;
        Vec3 position = null;
        if (entity2 instanceof Player && (handler = DragonStateProvider.getData(player = (Player)entity2)).isDragon()) {
            speedMultiplier = handler.getGrowth();
            if (player != Minecraft.getInstance().player || Minecraft.getInstance().options.getCameraType() != CameraType.FIRST_PERSON) {
                position = DragonRenderer.getBonePosition(player, "BreathSource");
            }
        }
        float yaw = (float)Math.toRadians(-entity2.getYRot());
        float pitch = (float)Math.toRadians(-entity2.getXRot());
        float speed = (float)((double)packet.speedPerGrowth() * speedMultiplier);
        double movement = 1.0 + entity2.getDeltaMovement().horizontalDistanceSqr();
        Vec3 angle = entity2.getLookAngle();
        position = position == null || position == Vec3.ZERO ? entity2.getEyePosition().add(angle.scale(movement)) : position.subtract(angle).add(angle.scale(movement));
        for (i = 0; i < packet.numParticles(); ++i) {
            ClientProxy.spawnParticle(packet.secondaryParticle(), entity2, position, yaw, pitch, speed, packet.spread());
        }
        for (i = 0; i < packet.numParticles() / 2; ++i) {
            ClientProxy.spawnParticle(packet.mainParticle(), entity2, position, yaw, pitch, speed, packet.spread());
        }
    }

    private static void spawnParticle(ParticleOptions particle, Entity entity, Vec3 position, float yaw, float pitch, float speed, float spread) {
        Vec3 velocity = ClientProxy.calculateParticleVelocity((float)((double)yaw + (double)(spread * 2.0f) * (entity.getRandom().nextDouble() * 2.0 - 1.0) * 2.0 * Math.PI), (float)((double)pitch + (double)spread * (entity.getRandom().nextDouble() * 2.0 - 1.0) * 2.0 * Math.PI), speed);
        velocity = velocity.add(entity.getDeltaMovement());
        entity.level().addParticle(particle, position.x, position.y, position.z, velocity.x, velocity.y, velocity.z);
    }

    private static Vec3 calculateParticleVelocity(float yaw, float pitch, float speed) {
        float xVel = (float)(Math.sin(yaw) * Math.cos(pitch) * (double)speed);
        float yVel = (float)Math.sin(pitch) * speed;
        float zVel = (float)(Math.cos(yaw) * Math.cos(pitch) * (double)speed);
        return new Vec3((double)xVel, (double)yVel, (double)zVel);
    }
}

