/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.mixins.client;

import by.dragonsurvivalteam.dragonsurvival.client.handlers.SmithingScreenHandler;
import by.dragonsurvivalteam.dragonsurvival.client.util.FakeClientPlayer;
import by.dragonsurvivalteam.dragonsurvival.client.util.FakeClientPlayerUtils;
import by.dragonsurvivalteam.dragonsurvival.common.capability.DragonStateHandler;
import by.dragonsurvivalteam.dragonsurvival.common.capability.DragonStateProvider;
import by.dragonsurvivalteam.dragonsurvival.common.entity.DragonEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.inventory.SmithingScreen;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={SmithingScreen.class})
public abstract class SmithingScreenMixin {
    @Unique
    @Nullable
    private DragonEntity dragonSurvival$dragon;

    @Inject(method={"subInit"}, at={@At(value="HEAD")})
    private void dragonSurvival$addDragonToInit(CallbackInfo callback) {
        if (DragonStateProvider.isDragon((Entity)Minecraft.getInstance().player)) {
            DragonStateHandler handler = DragonStateProvider.getData((Player)Minecraft.getInstance().player);
            this.dragonSurvival$dragon = FakeClientPlayerUtils.getFakeDragon(SmithingScreenHandler.FAKE_PLAYER, handler);
            FakeClientPlayerUtils.getFakePlayer((int)SmithingScreenHandler.FAKE_PLAYER, (DragonStateHandler)handler).animationSupplier = () -> "sit";
        } else {
            this.dragonSurvival$dragon = null;
        }
    }

    @Inject(method={"updateArmorStandPreview"}, at={@At(value="HEAD")})
    private void dragonSurvival$updateFakeDragon(ItemStack stack, CallbackInfo callback) {
        if (this.dragonSurvival$dragon != null) {
            DragonStateHandler handler = DragonStateProvider.getData((Player)Minecraft.getInstance().player);
            FakeClientPlayer player = FakeClientPlayerUtils.getFakePlayer(1, handler);
            SmithingScreenHandler.copyEquipment((Player)Minecraft.getInstance().player, (Player)player);
            if (!stack.isEmpty()) {
                ItemStack copied = stack.copy();
                Item item = stack.getItem();
                if (item instanceof ArmorItem) {
                    ArmorItem armor = (ArmorItem)item;
                    player.setItemSlot(armor.getEquipmentSlot(), copied);
                } else {
                    player.setItemSlot(EquipmentSlot.OFFHAND, copied);
                }
            }
        }
    }

    @ModifyArg(method={"renderBg"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/screens/inventory/InventoryScreen;renderEntityInInventory(Lnet/minecraft/client/gui/GuiGraphics;FFFLorg/joml/Vector3f;Lorg/joml/Quaternionf;Lorg/joml/Quaternionf;Lnet/minecraft/world/entity/LivingEntity;)V"), index=7)
    private LivingEntity dragonSurvival$renderDragon(LivingEntity armorStand) {
        if (this.dragonSurvival$dragon != null && DragonStateProvider.isDragon((Entity)Minecraft.getInstance().player)) {
            this.dragonSurvival$dragon.overrideUUIDWithLocalPlayerForTextureFetch = true;
            this.dragonSurvival$dragon.isInInventory = true;
            this.dragonSurvival$dragon.yBodyRot = 210.0f;
            this.dragonSurvival$dragon.setXRot(25.0f);
            return this.dragonSurvival$dragon;
        }
        return armorStand;
    }

    @Inject(method={"renderBg"}, at={@At(value="RETURN")})
    private void dragonSurvival$resetUUIDOverwriteFlag(CallbackInfo callback) {
        if (this.dragonSurvival$dragon != null) {
            this.dragonSurvival$dragon.overrideUUIDWithLocalPlayerForTextureFetch = false;
            this.dragonSurvival$dragon.isInInventory = false;
            this.dragonSurvival$dragon.yBodyRot = 0.0f;
            this.dragonSurvival$dragon.setXRot(0.0f);
        }
    }
}

