/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.mixins.client;

import by.dragonsurvivalteam.dragonsurvival.common.entity.DragonEntity;
import by.dragonsurvivalteam.dragonsurvival.common.handlers.magic.HunterHandler;
import by.dragonsurvivalteam.dragonsurvival.registry.attachments.HunterData;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Debug;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Debug(export=true)
@Mixin(value={ItemRenderer.class})
public abstract class ItemRendererMixin {
    @Inject(method={"renderStatic(Lnet/minecraft/world/entity/LivingEntity;Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/world/item/ItemDisplayContext;ZLcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;Lnet/minecraft/world/level/Level;III)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/entity/ItemRenderer;render(Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/world/item/ItemDisplayContext;ZLcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;IILnet/minecraft/client/resources/model/BakedModel;)V", shift=At.Shift.BEFORE)})
    private void dragonSurvival$storeAlpha(LivingEntity entity, ItemStack stack, ItemDisplayContext context, boolean leftHand, PoseStack poseStack, MultiBufferSource bufferSource, Level level, int combinedLight, int combinedOverlay, int seed, CallbackInfo callback) {
        LivingEntity relevantEntity;
        if ((ItemRendererMixin.dragonSurvival$isThirdPerson(context) || HunterHandler.TRANSLUCENT_ITEMS_IN_FIRST_PERSON && ItemRendererMixin.dragonSurvival$isFirstPerson(context)) && (relevantEntity = ItemRendererMixin.dragonSurvival$getRelevantEntity(entity)) != null) {
            HunterHandler.itemTranslucency = HunterHandler.calculateAlphaAsFloat((Entity)relevantEntity);
            return;
        }
        HunterHandler.itemTranslucency = -1.0f;
    }

    @ModifyArg(method={"renderQuadList"}, at=@At(value="INVOKE", target="Lcom/mojang/blaze3d/vertex/VertexConsumer;putBulkData(Lcom/mojang/blaze3d/vertex/PoseStack$Pose;Lnet/minecraft/client/renderer/block/model/BakedQuad;FFFFIIZ)V"), index=5)
    private float dragonSurvival$modifyAlpha(float alpha) {
        if (HunterHandler.itemTranslucency != -1.0f) {
            return HunterHandler.itemTranslucency;
        }
        return alpha;
    }

    @Inject(method={"render"}, at={@At(value="RETURN")})
    private void dragonSurvival$clearItemTranslucency(CallbackInfo callback) {
        HunterHandler.itemTranslucency = -1.0f;
    }

    @Unique
    private static boolean dragonSurvival$isThirdPerson(ItemDisplayContext context) {
        return context == ItemDisplayContext.THIRD_PERSON_LEFT_HAND || context == ItemDisplayContext.THIRD_PERSON_RIGHT_HAND;
    }

    @Unique
    private static boolean dragonSurvival$isFirstPerson(ItemDisplayContext context) {
        return context == ItemDisplayContext.FIRST_PERSON_LEFT_HAND || context == ItemDisplayContext.FIRST_PERSON_RIGHT_HAND;
    }

    @Unique
    @Nullable
    private static LivingEntity dragonSurvival$getRelevantEntity(LivingEntity entity) {
        DragonEntity dragon;
        Player player;
        if (entity instanceof DragonEntity && (player = (dragon = (DragonEntity)entity).getPlayer()) != null && HunterData.hasTransparency((LivingEntity)player)) {
            return player;
        }
        return entity != null && HunterData.hasTransparency(entity) ? entity : null;
    }
}

