/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.mixins.client;

import by.dragonsurvivalteam.dragonsurvival.mixins.client.GuiAccessor;
import by.dragonsurvivalteam.dragonsurvival.registry.attachments.SwimData;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.ability.ClientEffectProvider;
import by.dragonsurvivalteam.dragonsurvival.util.Functions;
import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.sugar.Local;
import java.util.List;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.common.NeoForgeMod;
import net.neoforged.neoforge.fluids.FluidType;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Gui.class})
public abstract class GuiMixin {
    @Unique
    private List<ClientEffectProvider> dragonSurvival$providers = List.of();

    @Inject(method={"renderEffects"}, at={@At(value="HEAD")})
    private void dragonSurvival$storeProviders(GuiGraphics graphics, DeltaTracker deltaTracker, CallbackInfo callback) {
        this.dragonSurvival$providers = ClientEffectProvider.getProviders(false);
    }

    @ModifyExpressionValue(method={"renderEffects"}, at={@At(value="INVOKE", target="Ljava/util/Collection;isEmpty()Z")})
    private boolean dragonSurvival$considerClientEffectsForIsEmpty(boolean isEmpty) {
        return isEmpty && this.dragonSurvival$providers.isEmpty();
    }

    @Inject(method={"renderEffects"}, at={@At(value="INVOKE", target="Ljava/util/List;forEach(Ljava/util/function/Consumer;)V")})
    private void dragonSurvival$renderAbilityEffects(GuiGraphics graphics, DeltaTracker deltaTracker, CallbackInfo callback, @Local(ordinal=0) int renderedCount) {
        Gui self = (Gui)this;
        int effectCount = renderedCount;
        for (ClientEffectProvider provider : this.dragonSurvival$providers) {
            int xPos = graphics.guiWidth();
            int yPos = 1;
            if (Minecraft.getInstance().isDemo()) {
                yPos += 15;
            }
            graphics.blitSprite(((GuiAccessor)self).dragonSurvival$getEffectBackgroundSprite(), xPos -= 25 * ++effectCount, yPos, 24, 24);
            float alpha = 1.0f;
            if (!provider.isInfiniteDuration() && provider.currentDuration() < 200) {
                int duration = (int)(10.0 - Functions.ticksToSeconds(provider.currentDuration()));
                alpha = Mth.clamp((float)((float)provider.currentDuration() / 10.0f / 5.0f * 0.5f), (float)0.0f, (float)0.5f) + Mth.cos((float)((float)provider.currentDuration() * (float)Math.PI / 5.0f)) * Mth.clamp((float)((float)duration / 10.0f * 0.25f), (float)0.0f, (float)0.25f);
            }
            graphics.setColor(1.0f, 1.0f, 1.0f, alpha);
            graphics.blit(provider.clientData().texture(), xPos + 3, yPos + 3, 0, 0.0f, 0.0f, 18, 18, 18, 18);
            graphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
        }
    }

    @Unique
    @Nullable
    private static ResourceLocation dragonSurvival$getSpriteForAirBubble(boolean burst) {
        LocalPlayer player = Minecraft.getInstance().player;
        FluidType previousFluidType = SwimData.getData((Player)player).previousFluid;
        FluidType currentFluidType = player.getEyeInFluidType();
        FluidType relevantFluid = NeoForgeMod.EMPTY_TYPE.getKey() == SwimData.key(currentFluidType) ? previousFluidType : currentFluidType;
        ResourceLocation replacementSprite = burst ? SwimData.getAirBurstSprite(relevantFluid) : SwimData.getAirSprite(relevantFluid);
        if (replacementSprite == null) {
            return null;
        }
        TextureAtlasSprite sprite = Minecraft.getInstance().getGuiSprites().getSprite(replacementSprite);
        if (sprite.contents().name() != MissingTextureAtlasSprite.getLocation()) {
            return replacementSprite;
        }
        return null;
    }

    @ModifyArg(method={"renderAirLevel"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/GuiGraphics;blitSprite(Lnet/minecraft/resources/ResourceLocation;IIII)V", ordinal=0))
    private ResourceLocation dragonSurvival$modifyAirSprite(ResourceLocation sprite) {
        ResourceLocation replacementSprite = GuiMixin.dragonSurvival$getSpriteForAirBubble(false);
        if (replacementSprite != null) {
            return replacementSprite;
        }
        return sprite;
    }

    @ModifyArg(method={"renderAirLevel"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/GuiGraphics;blitSprite(Lnet/minecraft/resources/ResourceLocation;IIII)V", ordinal=1))
    private ResourceLocation dragonSurvival$modifyAirBurstSprite(ResourceLocation sprite) {
        ResourceLocation replacementSprite = GuiMixin.dragonSurvival$getSpriteForAirBubble(true);
        if (replacementSprite != null) {
            return replacementSprite;
        }
        return sprite;
    }
}

