/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.mixins.client;

import by.dragonsurvivalteam.dragonsurvival.client.handlers.DragonDestructionHandler;
import by.dragonsurvivalteam.dragonsurvival.client.render.BlockVisionHandler;
import by.dragonsurvivalteam.dragonsurvival.common.blocks.SourceOfMagicBlock;
import by.dragonsurvivalteam.dragonsurvival.server.tileentity.SourceOfMagicPlaceholder;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.storage.WritableLevelData;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ClientLevel.class})
public abstract class ClientLevelMixin
extends Level {
    protected ClientLevelMixin(WritableLevelData pLevelData, ResourceKey<Level> pDimension, RegistryAccess pRegistryAccess, Holder<DimensionType> pDimensionTypeRegistration, Supplier<ProfilerFiller> pProfiler, boolean pIsClientSide, boolean pIsDebug, long pBiomeZoomSeed, int pMaxChainedNeighborUpdates) {
        super(pLevelData, pDimension, pRegistryAccess, pDimensionTypeRegistration, pProfiler, pIsClientSide, pIsDebug, pBiomeZoomSeed, pMaxChainedNeighborUpdates);
    }

    @Inject(method={"destroyBlockProgress"}, at={@At(value="RETURN")})
    private void dragonSurvival$storeCenterOfDestruction(int breakerId, BlockPos position, int progress, CallbackInfo callback) {
        if (Minecraft.getInstance().level.getEntity(breakerId) == Minecraft.getInstance().player) {
            DragonDestructionHandler.centerOfDestruction = position;
        }
    }

    @ModifyArg(method={"destroyBlockProgress"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/renderer/LevelRenderer;destroyBlockProgress(ILnet/minecraft/core/BlockPos;I)V"), index=1)
    private BlockPos dragonSurvival$handleSourceOfMagicDestroyProgress(BlockPos position) {
        BlockEntity blockEntity;
        BlockState state = this.getBlockState(position);
        if (state.getBlock() instanceof SourceOfMagicBlock && !((Boolean)state.getValue((Property)SourceOfMagicBlock.PRIMARY_BLOCK)).booleanValue() && (blockEntity = this.getBlockEntity(position)) instanceof SourceOfMagicPlaceholder) {
            SourceOfMagicPlaceholder placeholder = (SourceOfMagicPlaceholder)blockEntity;
            return placeholder.rootPos;
        }
        return position;
    }

    @Inject(method={"sendBlockUpdated"}, at={@At(value="HEAD")})
    private void dragonSurvival$updateBlockVision(BlockPos position, BlockState oldState, BlockState newState, int flags, CallbackInfo callback) {
        BlockVisionHandler.updateEntry(position, oldState, newState);
    }
}

