/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.mixins;

import by.dragonsurvivalteam.dragonsurvival.common.capability.DragonStateProvider;
import by.dragonsurvivalteam.dragonsurvival.registry.DSEffects;
import by.dragonsurvivalteam.dragonsurvival.util.AdditionalEffectData;
import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import com.llamalad7.mixinextras.sugar.Local;
import java.util.UUID;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={MobEffectInstance.class})
public abstract class MobEffectInstanceMixin
implements AdditionalEffectData {
    @Unique
    private static final String dragonSurvival$APPLIER = "applier";
    @Shadow
    @Final
    private Holder<MobEffect> effect;
    @Shadow
    private int duration;
    @Unique
    @Nullable
    private Entity dragonSurvival$applier;
    @Unique
    @Nullable
    private UUID dragonSurvival$applierUUID;
    @Unique
    @Nullable
    private ThreadLocal<Player> dragonSurvival$entity;

    @Override
    public void dragonSurvival$setApplier(Entity applier) {
        this.dragonSurvival$applier = applier;
    }

    @Override
    @Nullable
    public Entity dragonSurvival$getApplier(ServerLevel level) {
        if (this.dragonSurvival$applier == null && this.dragonSurvival$applierUUID != null) {
            this.dragonSurvival$applier = level.getEntity(this.dragonSurvival$applierUUID);
            if (this.dragonSurvival$applier == null) {
                this.dragonSurvival$applier = level.getServer().getPlayerList().getPlayer(this.dragonSurvival$applierUUID);
            }
        }
        return this.dragonSurvival$applier;
    }

    @Override
    public void dragonSurvival$setApplierUUID(UUID applierUUID) {
        this.dragonSurvival$applierUUID = applierUUID;
    }

    @ModifyReturnValue(method={"save"}, at={@At(value="RETURN")})
    private Tag dragonSurvival$saveAdditionalData(Tag tag) {
        if (this.dragonSurvival$applierUUID != null && tag instanceof CompoundTag) {
            CompoundTag compound = (CompoundTag)tag;
            compound.putUUID(dragonSurvival$APPLIER, this.dragonSurvival$applierUUID);
        }
        return tag;
    }

    @ModifyReturnValue(method={"load"}, at={@At(value="RETURN")})
    private static MobEffectInstance dragonSurvival$loadAdditionalData(MobEffectInstance instance, @Local(argsOnly=true) CompoundTag tag) {
        Tag applierTag = tag.get(dragonSurvival$APPLIER);
        if (applierTag != null) {
            ((AdditionalEffectData)instance).dragonSurvival$setApplierUUID(NbtUtils.loadUUID((Tag)applierTag));
        }
        return instance;
    }

    @Inject(method={"tick"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/effect/MobEffectInstance;tickDownDuration()I")})
    private void dragonSurvival$storeEntity(LivingEntity entity, Runnable onExpirationRunnable, CallbackInfoReturnable<Boolean> callback) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (this.effect.is(DSEffects.SOURCE_OF_MAGIC)) {
                if (this.dragonSurvival$entity == null) {
                    this.dragonSurvival$entity = new ThreadLocal();
                }
                this.dragonSurvival$entity.set(player);
            }
        }
    }

    @Inject(method={"tickDownDuration"}, at={@At(value="HEAD")}, cancellable=true)
    private void dragonSurvival$retainDuration(CallbackInfoReturnable<Integer> callback) {
        if (this.dragonSurvival$entity != null && this.effect.is(DSEffects.SOURCE_OF_MAGIC)) {
            Player player = this.dragonSurvival$entity.get();
            if (player != null && DragonStateProvider.getData((Player)player).isOnMagicSource) {
                callback.setReturnValue((Object)this.duration);
            }
            this.dragonSurvival$entity.remove();
        }
    }
}

