/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.input;

import by.dragonsurvivalteam.dragonsurvival.registry.datagen.Translation;
import com.mojang.blaze3d.platform.InputConstants;
import java.util.Locale;
import net.minecraft.client.KeyMapping;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.RegisterKeyMappingsEvent;
import net.neoforged.neoforge.client.settings.IKeyConflictContext;
import net.neoforged.neoforge.client.settings.KeyConflictContext;
import net.neoforged.neoforge.client.settings.KeyModifier;
import org.jetbrains.annotations.Nullable;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public enum Keybind {
    TOGGLE_FLIGHT((IKeyConflictContext)KeyConflictContext.IN_GAME, 71),
    USE_ABILITY((IKeyConflictContext)KeyConflictContext.IN_GAME, 67),
    TOGGLE_ABILITIES((IKeyConflictContext)KeyConflictContext.IN_GAME, 88),
    NEXT_ABILITY((IKeyConflictContext)KeyConflictContext.IN_GAME, 82),
    PREVIOUS_ABILITY((IKeyConflictContext)KeyConflictContext.IN_GAME, 82, KeyModifier.SHIFT),
    ABILITY1((IKeyConflictContext)KeyConflictContext.IN_GAME, 321),
    ABILITY2((IKeyConflictContext)KeyConflictContext.IN_GAME, 322),
    ABILITY3((IKeyConflictContext)KeyConflictContext.IN_GAME, 323),
    ABILITY4((IKeyConflictContext)KeyConflictContext.IN_GAME, 324),
    SPIN_ABILITY((IKeyConflictContext)KeyConflictContext.IN_GAME, 86),
    FREE_LOOK((IKeyConflictContext)KeyConflictContext.IN_GAME, 342),
    TOGGLE_LARGE_DRAGON_DESTRUCTION((IKeyConflictContext)KeyConflictContext.IN_GAME, -1),
    TOGGLE_MULTI_MINING((IKeyConflictContext)KeyConflictContext.IN_GAME, -1),
    DRAGON_INVENTORY((IKeyConflictContext)KeyConflictContext.UNIVERSAL, -1),
    ABILITY_MENU((IKeyConflictContext)KeyConflictContext.UNIVERSAL, -1),
    SPECIES_MENU((IKeyConflictContext)KeyConflictContext.UNIVERSAL, -1),
    EMOTE_MENU((IKeyConflictContext)KeyConflictContext.UNIVERSAL, -1),
    SKINS_MENU((IKeyConflictContext)KeyConflictContext.UNIVERSAL, -1),
    TOGGLE_SUMMON_BEHAVIOUR((IKeyConflictContext)KeyConflictContext.IN_GAME, -1);

    @Translation(comments={"Dragon Survival"})
    private static final String CATEGORY;
    private final IKeyConflictContext keyConflictContext;
    private final KeyModifier defaultModifier;
    private final int defaultKey;
    @Nullable
    private KeyMapping keyMapping;

    private Keybind(IKeyConflictContext keyConflictContext, int defaultKey) {
        this(keyConflictContext, defaultKey, null);
    }

    private Keybind(IKeyConflictContext keyConflictContext, int defaultKey, KeyModifier defaultModifier) {
        this.keyConflictContext = keyConflictContext;
        this.defaultKey = defaultKey;
        this.defaultModifier = defaultModifier;
    }

    @SubscribeEvent
    public static void registerAllKeys(RegisterKeyMappingsEvent event) {
        for (Keybind keybind : Keybind.values()) {
            event.register(keybind.get());
        }
    }

    public KeyMapping get() {
        if (this.keyMapping == null) {
            String translationKey = Translation.Type.KEYBIND.wrap(this.name().toLowerCase(Locale.ENGLISH));
            this.keyMapping = this.defaultModifier == null ? new KeyMapping(translationKey, this.keyConflictContext, InputConstants.Type.KEYSYM, this.defaultKey, CATEGORY) : new KeyMapping(translationKey, this.keyConflictContext, this.defaultModifier, InputConstants.Type.KEYSYM, this.defaultKey, CATEGORY);
        }
        return this.keyMapping;
    }

    public boolean consumeClick() {
        return this.get().consumeClick();
    }

    public boolean isReleased(InputConstants.Key input) {
        KeyMapping mapping = this.get();
        return mapping.getKey().equals((Object)input) || mapping.getKeyModifier().matches(input);
    }

    public boolean matches(InputConstants.Key input) {
        return this.matches(input, false);
    }

    public boolean matches(InputConstants.Key input, boolean isGui) {
        KeyMapping mapping = this.get();
        if (!mapping.isConflictContextAndModifierActive()) {
            return false;
        }
        if (mapping.getKey().equals((Object)input)) {
            return input.getType() == InputConstants.Type.MOUSE || isGui || mapping.consumeClick();
        }
        return false;
    }

    static {
        CATEGORY = Translation.Type.KEYBIND.wrap("category");
    }
}

