/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.gametests;

import by.dragonsurvivalteam.dragonsurvival.common.capability.DragonStateHandler;
import by.dragonsurvivalteam.dragonsurvival.common.capability.DragonStateProvider;
import by.dragonsurvivalteam.dragonsurvival.config.ConfigHandler;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.DragonSpecies;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.body.DragonBody;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.stage.DragonStage;
import by.dragonsurvivalteam.dragonsurvival.util.DragonUtils;
import java.lang.reflect.Field;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.gametest.framework.GameTestHelper;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;

public class TestUtils {
    public static final String AIR_CUBE_1X = "test_templates/1x1x1_air";
    public static final String AIR_CUBE_3X = "test_templates/3x3x3_air";

    public static BlockState setBlock(GameTestHelper helper, Block block) {
        return TestUtils.setBlock(helper, block, BlockPos.ZERO);
    }

    public static BlockState setBlock(GameTestHelper helper, Block block, BlockPos position) {
        helper.setBlock(position, block);
        BlockState state = helper.getBlockState(position);
        helper.assertTrue(state.is(block), "Block at position [" + String.valueOf(position) + "] was [" + String.valueOf(state.getBlock()) + "] - expected [" + String.valueOf(block) + "]");
        return helper.getBlockState(position);
    }

    public static boolean compare(Object value, Object fieldValue) {
        if (value instanceof Number) {
            Number number = (Number)value;
            if (fieldValue instanceof Number) {
                Number fieldNumber = (Number)fieldValue;
                return Float.compare(number.floatValue(), fieldNumber.floatValue()) == 0;
            }
        }
        return value.equals(fieldValue);
    }

    public static void setAndCheckConfig(GameTestHelper helper, String configKey, Object value) {
        ConfigHandler.updateConfigValue(configKey, value);
        Field field = ConfigHandler.getField(configKey);
        try {
            Object fieldValue = field.get(null);
            helper.assertTrue(TestUtils.compare(value, fieldValue), "The field value [" + String.valueOf(fieldValue) + "] did not match the new value [" + String.valueOf(value) + "] after updating the config");
        }
        catch (IllegalAccessException exception) {
            helper.fail("Failed trying to access a field for the config [" + configKey + "] to validate the config: [" + exception.getMessage() + "]");
        }
    }

    public static void setToDragon(GameTestHelper helper, Player player, ResourceKey<DragonSpecies> dragonSpecies, ResourceKey<DragonBody> dragonBody, ResourceKey<DragonStage> dragonStage) {
        DragonStateHandler data = DragonStateProvider.getData(player);
        Holder species = player.level().registryAccess().holderOrThrow(dragonSpecies);
        data.setSpecies(player, (Holder<DragonSpecies>)species);
        helper.assertTrue(data.species().is(dragonSpecies), String.format("Dragon species was [%s] - expected [%s]", data.species(), species));
        Holder body = player.registryAccess().holderOrThrow(dragonBody);
        data.setBody(player, (Holder<DragonBody>)body);
        helper.assertTrue(DragonUtils.isBody(data, (Holder<DragonBody>)body), String.format("Dragon type was [%s] - expected [%s]", data.body(), dragonBody));
        Holder stage = player.registryAccess().holderOrThrow(dragonStage);
        data.setStage(player, (Holder<DragonStage>)stage);
        helper.assertTrue(data.stage().is(stage), String.format("Dragon stage was [%s] - expected [%s]", data.stage(), stage));
        helper.assertTrue(data.isDragon(), "Player is not a dragon - expected player to be a dragon");
        TestUtils.tick(player);
    }

    public static Player createPlayer(GameTestHelper helper) {
        Player player = helper.makeMockPlayer(GameType.SURVIVAL);
        TestUtils.resetPlayer(helper, player);
        return player;
    }

    public static void resetPlayer(GameTestHelper helper, Player player) {
        DragonStateHandler data = DragonStateProvider.getData(player);
        data.revertToHumanForm(player, false);
        Holder<DragonSpecies> dragonSpecies = data.species();
        helper.assertTrue(dragonSpecies == null, String.format("Dragon type was [%s] - expected [null]", dragonSpecies));
        Holder<DragonBody> dragonBody = data.body();
        helper.assertTrue(dragonBody == null, String.format("Dragon body was [%s] - expected [null]", dragonBody));
        Holder<DragonStage> dragonStage = data.stage();
        helper.assertTrue(dragonStage == null, String.format("Dragon level was [%s] - expected [null]", dragonStage));
        double size = data.getGrowth();
        helper.assertTrue(size == -1.0, String.format("Size was [%f] - expected [0]", size));
        TestUtils.tick(player);
    }

    public static void tick(Player player) {
        NeoForge.EVENT_BUS.post((Event)new PlayerTickEvent.Pre(player));
        NeoForge.EVENT_BUS.post((Event)new PlayerTickEvent.Post(player));
    }
}

