/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.config;

import by.dragonsurvivalteam.dragonsurvival.common.codecs.ResourceLocationWrapper;
import by.dragonsurvivalteam.dragonsurvival.config.CustomConfig;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class OffsetConfig
implements CustomConfig {
    private static final String SPLIT = ";";
    private final Map<ResourceKey<EntityType<?>>, Vec3> offsets = new HashMap();
    private final String originalData;
    private static final int ENTITY_TYPE = 0;
    private static final int X_OFFSET = 1;
    private static final int Y_OFFSET = 2;
    private static final int Z_OFFSET = 3;

    @Nullable
    public Vec3 getOffset(ResourceKey<EntityType<?>> entityType) {
        return this.offsets.get(entityType);
    }

    public OffsetConfig() {
        this("", Vec3.ZERO, "");
    }

    private OffsetConfig(String entityTypeResource, Vec3 offset, String originalData) {
        this.originalData = originalData;
        ResourceLocationWrapper.getEntries(entityTypeResource, BuiltInRegistries.ENTITY_TYPE).forEach(resource -> this.offsets.put(ResourceKey.create((ResourceKey)Registries.ENTITY_TYPE, (ResourceLocation)resource), offset));
    }

    public static OffsetConfig create(Holder<EntityType<?>> entityType, Vec3 offset) {
        return OffsetConfig.create(entityType.getRegisteredName(), offset);
    }

    public static OffsetConfig create(TagKey<EntityType<?>> entityType, Vec3 offset) {
        return OffsetConfig.create("#" + String.valueOf(entityType.location()), offset);
    }

    public static OffsetConfig create(String entityType, Vec3 offset) {
        String data = entityType + SPLIT + offset.x() + SPLIT + offset.y() + SPLIT + offset.z();
        return new OffsetConfig(entityType, offset, data);
    }

    @Override
    public CustomConfig parse(String data) {
        String[] elements = data.split(SPLIT);
        double xOffset = Double.parseDouble(elements[1]);
        double yOffset = Double.parseDouble(elements[2]);
        double zOffset = Double.parseDouble(elements[3]);
        return new OffsetConfig(elements[0], new Vec3(xOffset, yOffset, zOffset), data);
    }

    @Override
    public boolean validate(Object configValue) {
        if (configValue instanceof String) {
            String string = (String)configValue;
            String[] elements = string.split(SPLIT);
            if (elements.length != 4) {
                return false;
            }
            if (!ResourceLocationWrapper.validateRegexResourceLocation(elements[0])) {
                return false;
            }
            try {
                Double.parseDouble(elements[1]);
                Double.parseDouble(elements[2]);
                Double.parseDouble(elements[3]);
            }
            catch (NumberFormatException ignored) {
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public String convert() {
        return this.originalData;
    }
}

