/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.common.particles;

import by.dragonsurvivalteam.dragonsurvival.registry.attachments.BlockVisionData;
import by.dragonsurvivalteam.dragonsurvival.registry.attachments.DSDataAttachments;
import by.dragonsurvivalteam.dragonsurvival.util.DSColors;
import by.dragonsurvivalteam.dragonsurvival.util.Functions;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.GlowParticle;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.util.FastColor;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;

public class CustomGlowParticle
extends GlowParticle {
    private final double colorOffset;
    private List<Integer> colors;

    protected CustomGlowParticle(ClientLevel level, double x, double y, double z, double blockId, double ySpeed, double colorOffset, SpriteSet sprites) {
        super(level, x, y, z, 0.5 - level.getRandom().nextDouble(), ySpeed, 0.5 - level.getRandom().nextDouble(), sprites);
        this.colorOffset = colorOffset;
    }

    public void tick() {
        super.tick();
        if (this.colors != null) {
            int argb = DSColors.withAlpha(Functions.lerpColor(this.colors, this.colorOffset), 1.0f);
            float red = (float)FastColor.ARGB32.red((int)argb) / 255.0f;
            float green = (float)FastColor.ARGB32.green((int)argb) / 255.0f;
            float blue = (float)FastColor.ARGB32.blue((int)argb) / 255.0f;
            this.setColor(red, green, blue);
        }
    }

    public void setColors(List<Integer> colors) {
        this.colors = colors;
    }

    public static class Provider
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet sprites;

        public Provider(SpriteSet sprites) {
            this.sprites = sprites;
        }

        public Particle createParticle(@NotNull SimpleParticleType type, @NotNull ClientLevel level, double x, double y, double z, double blockId, double ySpeed, double colorOffset) {
            CustomGlowParticle particle = new CustomGlowParticle(level, x, y, z, blockId, ySpeed, colorOffset, this.sprites);
            LocalPlayer player = Minecraft.getInstance().player;
            List<Integer> colors = List.of();
            BlockVisionData vision = player.getExistingData(DSDataAttachments.BLOCK_VISION).orElse(null);
            if (vision != null) {
                colors = vision.getColors((Block)BuiltInRegistries.BLOCK.byId((int)blockId));
            }
            int argb = DSColors.withAlpha(Functions.lerpColor(colors), 1.0f);
            float red = (float)FastColor.ARGB32.red((int)argb) / 255.0f;
            float green = (float)FastColor.ARGB32.green((int)argb) / 255.0f;
            float blue = (float)FastColor.ARGB32.blue((int)argb) / 255.0f;
            particle.setColor(red, green, blue);
            particle.yd *= 0.2f;
            particle.xd *= 0.1f;
            particle.zd *= 0.1f;
            particle.setColors(colors);
            particle.setLifetime((int)(8.0 / (level.getRandom().nextDouble() * 0.8 + 0.2)));
            return particle;
        }
    }
}

