/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.common.items;

import by.dragonsurvivalteam.dragonsurvival.common.capability.DragonStateHandler;
import by.dragonsurvivalteam.dragonsurvival.common.capability.DragonStateProvider;
import by.dragonsurvivalteam.dragonsurvival.common.items.TooltipItem;
import by.dragonsurvivalteam.dragonsurvival.registry.datagen.Translation;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class SpinGrantItem
extends TooltipItem {
    @Translation(comments={"You feel empowered with the ability to spin through the air."})
    private static final String SPIN_GRANT_GAINED = Translation.Type.GUI.wrap("spin_grant_gained");

    public SpinGrantItem(Item.Properties properties, String key) {
        super(properties, key);
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(@NotNull Level level, @NotNull Player player, @NotNull InteractionHand hand) {
        DragonStateHandler handler = DragonStateProvider.getData(player);
        if (handler.isDragon() && !handler.spinWasGranted && !level.isClientSide()) {
            player.sendSystemMessage((Component)Component.translatable((String)SPIN_GRANT_GAINED));
            handler.spinWasGranted = true;
            player.getItemInHand(hand).consume(1, (LivingEntity)player);
            level.playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.UI_TOAST_CHALLENGE_COMPLETE, SoundSource.PLAYERS, 1.0f, 0.0f);
            return InteractionResultHolder.success((Object)player.getItemInHand(hand));
        }
        return super.use(level, player, hand);
    }
}

