/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.common.handlers.magic;

import by.dragonsurvivalteam.dragonsurvival.DragonSurvival;
import by.dragonsurvivalteam.dragonsurvival.config.obj.ConfigOption;
import by.dragonsurvivalteam.dragonsurvival.config.obj.ConfigSide;
import by.dragonsurvivalteam.dragonsurvival.network.magic.SyncHunterStacksRemoval;
import by.dragonsurvivalteam.dragonsurvival.registry.DSEffects;
import by.dragonsurvivalteam.dragonsurvival.registry.attachments.DSDataAttachments;
import by.dragonsurvivalteam.dragonsurvival.registry.attachments.HunterData;
import by.dragonsurvivalteam.dragonsurvival.registry.datagen.Translation;
import by.dragonsurvivalteam.dragonsurvival.registry.datagen.tags.DSBlockTags;
import by.dragonsurvivalteam.dragonsurvival.util.Functions;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.util.FastColor;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import net.neoforged.neoforge.event.entity.living.LivingEvent;
import net.neoforged.neoforge.event.entity.living.MobEffectEvent;
import net.neoforged.neoforge.event.tick.EntityTickEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.util.Color;

@EventBusSubscriber
public class HunterHandler {
    @Translation(key="hunter_max_level", type=Translation.Type.CONFIGURATION, comments={"The current level compared to the maximum level determines how quickly stacks are gained or lost"})
    @ConfigOption(side=ConfigSide.SERVER, category={"effects", "hunter"}, key="hunter_max_level")
    public static int MAX_LEVEL = 4;
    @Translation(key="hunter_damage_per_level", type=Translation.Type.CONFIGURATION, comments={"Determines the damage bonus (0.5 -> 50%) per level of the effect", "The damage bonus scales with the current stacks, max. amount being reached at max. stacks"})
    @ConfigOption(side=ConfigSide.SERVER, category={"effects", "hunter"}, key="hunter_damage_per_level")
    public static double DAMAGE_PER_LEVEL = 0.75;
    @Translation(key="hunter_fully_invisible", type=Translation.Type.CONFIGURATION, comments={"If enabled other players will be fully invisible at maximum hunter stacks"})
    @ConfigOption(side=ConfigSide.SERVER, category={"effects", "hunter"}, key="hunter_full_invisibility")
    public static boolean FULLY_INVISIBLE;
    @Translation(key="hunter_translucent_items_in_first_person", type=Translation.Type.CONFIGURATION, comments={"If enabled items held in first person will also appear translucent"})
    @ConfigOption(side=ConfigSide.CLIENT, category={"effects", "hunter"}, key="hunter_translucent_items_in_first_person")
    public static boolean TRANSLUCENT_ITEMS_IN_FIRST_PERSON;
    @Translation(key="hunter_fix_translucency", type=Translation.Type.CONFIGURATION, comments={"This enables the shader features of fabulous mode which are needed for translucency to work correctly"})
    @ConfigOption(side=ConfigSide.CLIENT, category={"effects", "hunter"}, key="hunter_fix_translucency", gameRestart=true)
    public static boolean FIX_TRANSLUCENCY;
    public static final int UNMODIFIED = -1;
    public static final int NON_TRANSPARENT = 1;
    public static final float MIN_ALPHA = 0.2f;
    public static float itemTranslucency;

    @SubscribeEvent
    public static void modifyHunterStacks(EntityTickEvent.Post event) {
        Entity entity = event.getEntity();
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity entity2 = (LivingEntity)entity;
        MobEffectInstance hunterEffect = entity2.getEffect(DSEffects.HUNTER);
        if (hunterEffect != null) {
            HunterData data = (HunterData)entity2.getData(DSDataAttachments.HUNTER);
            int modification = HunterHandler.isHunterRelevant(entity2.getBlockStateOn()) || HunterHandler.isHunterRelevant(entity2.getInBlockState()) ? Math.min(MAX_LEVEL, 1 + hunterEffect.getAmplifier()) : Math.min(MAX_LEVEL - 1, hunterEffect.getAmplifier()) - MAX_LEVEL;
            data.modifyHunterStacks(modification);
        }
    }

    @SubscribeEvent
    public static void clearCurrentTarget(EntityTickEvent.Post event) {
        LivingEntity target;
        Mob mob;
        Entity entity = event.getEntity();
        if (entity instanceof Mob && (mob = (Mob)entity).getTarget() != null && HunterData.hasMaxHunterStacks(target = mob.getTarget())) {
            mob.setTarget(null);
        }
    }

    @SubscribeEvent
    public static void removeHunterEffect(LivingDamageEvent.Post event) {
        MobEffectInstance hunterEffect = event.getEntity().getEffect(DSEffects.HUNTER);
        if (hunterEffect != null && event.getNewDamage() > (float)hunterEffect.getAmplifier()) {
            event.getEntity().removeEffect(DSEffects.HUNTER);
        }
    }

    @SubscribeEvent
    public static void modifyVisibility(LivingEvent.LivingVisibilityEvent event) {
        event.getEntity().getExistingData(DSDataAttachments.HUNTER).ifPresent(data -> {
            if (data.hasHunterStacks()) {
                event.modifyVisibility(1.0 - (double)data.getHunterStacks() / (double)HunterHandler.getMaxStacks());
            }
        });
    }

    @SubscribeEvent
    public static void clearHunterStacks(MobEffectEvent.Remove event) {
        if (event.getEffect().is(DSEffects.HUNTER)) {
            HunterHandler.clearHunterStacks(event.getEntity());
        }
    }

    @SubscribeEvent
    public static void clearHunterStacks(MobEffectEvent.Expired event) {
        MobEffectInstance instance = event.getEffectInstance();
        if (instance != null && instance.getEffect().is(DSEffects.HUNTER)) {
            HunterHandler.clearHunterStacks(event.getEntity());
        }
    }

    @SubscribeEvent
    public static void handleCriticalBonus(LivingDamageEvent.Pre event) {
        Entity entity = event.getSource().getEntity();
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity attacker = (LivingEntity)entity;
        MobEffectInstance hunterEffect = attacker.getEffect(DSEffects.HUNTER);
        if (hunterEffect == null) {
            return;
        }
        HunterData data = (HunterData)attacker.getData(DSDataAttachments.HUNTER);
        float multiplier = (float)(1.0 + (double)hunterEffect.getAmplifier() * DAMAGE_PER_LEVEL);
        event.setNewDamage(event.getNewDamage() * (1.0f + (multiplier *= (float)data.getHunterStacks() / (float)HunterHandler.getMaxStacks())));
        attacker.removeEffect(DSEffects.HUNTER);
    }

    public static int getMaxStacks() {
        return MAX_LEVEL * Functions.secondsToTicks(2.0);
    }

    public static int applyAlpha(float alpha, int packedColor) {
        return FastColor.ARGB32.color((int)((int)(alpha * 255.0f)), (int)FastColor.ARGB32.red((int)packedColor), (int)FastColor.ARGB32.green((int)packedColor), (int)FastColor.ARGB32.blue((int)packedColor));
    }

    public static int applyAlpha(int alpha, int packedColor) {
        return FastColor.ARGB32.color((int)alpha, (int)FastColor.ARGB32.red((int)packedColor), (int)FastColor.ARGB32.green((int)packedColor), (int)FastColor.ARGB32.blue((int)packedColor));
    }

    public static int modifyAlpha(@Nullable Entity entity, int packedColor) {
        if (entity == null) {
            return packedColor;
        }
        HunterData data = entity.getExistingData(DSDataAttachments.HUNTER).orElse(null);
        if (data == null || !data.hasHunterStacks()) {
            return packedColor;
        }
        float alpha = HunterHandler.calculateAlpha(data, entity == DragonSurvival.PROXY.getLocalPlayer());
        return HunterHandler.applyAlpha(alpha, packedColor);
    }

    public static Color modifyAlpha(@Nullable Entity entity, Color color) {
        if (entity == null) {
            return color;
        }
        HunterData data = entity.getExistingData(DSDataAttachments.HUNTER).orElse(null);
        if (data == null || !data.hasHunterStacks()) {
            return color;
        }
        int packedColor = color.getColor();
        float alpha = HunterHandler.calculateAlpha(data, entity == DragonSurvival.PROXY.getLocalPlayer());
        return Color.ofARGB((int)((int)(alpha * 255.0f)), (int)FastColor.ARGB32.red((int)packedColor), (int)FastColor.ARGB32.green((int)packedColor), (int)FastColor.ARGB32.blue((int)packedColor));
    }

    public static int calculateAlpha(Entity entity) {
        return (int)(HunterHandler.calculateAlphaAsFloat(entity) * 255.0f);
    }

    public static float calculateAlphaAsFloat(Entity entity) {
        HunterData data = entity.getExistingData(DSDataAttachments.HUNTER).orElse(null);
        if (data == null) {
            return -1.0f;
        }
        return HunterHandler.calculateAlpha(data, entity == DragonSurvival.PROXY.getLocalPlayer());
    }

    private static float calculateAlpha(@NotNull HunterData data, boolean isLocalPlayer) {
        if (!data.hasTransparency()) {
            return -1.0f;
        }
        float min = isLocalPlayer || !FULLY_INVISIBLE ? 0.2f : 0.0f;
        return Math.max(min, 1.0f - (float)data.getHunterStacks() / (float)HunterHandler.getMaxStacks());
    }

    private static boolean isHunterRelevant(BlockState blockState) {
        return blockState.is(DSBlockTags.ENABLES_HUNTER_EFFECT);
    }

    private static void clearHunterStacks(LivingEntity entity) {
        ((HunterData)entity.getData(DSDataAttachments.HUNTER)).clearHunterStacks();
        if (!entity.level().isClientSide()) {
            PacketDistributor.sendToPlayersTrackingEntityAndSelf((Entity)entity, (CustomPacketPayload)new SyncHunterStacksRemoval(entity.getId()), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    static {
        TRANSLUCENT_ITEMS_IN_FIRST_PERSON = true;
        FIX_TRANSLUCENCY = true;
        itemTranslucency = -1.0f;
    }
}

