/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.common.handlers;

import by.dragonsurvivalteam.dragonsurvival.registry.DSAttributes;
import by.dragonsurvivalteam.dragonsurvival.registry.DSEffects;
import by.dragonsurvivalteam.dragonsurvival.registry.DSEnchantments;
import by.dragonsurvivalteam.dragonsurvival.registry.DSMapDecorationTypes;
import by.dragonsurvivalteam.dragonsurvival.registry.DSTrades;
import by.dragonsurvivalteam.dragonsurvival.registry.attachments.EffectsMaintainedThroughDeath;
import by.dragonsurvivalteam.dragonsurvival.registry.datagen.lang.LangKey;
import by.dragonsurvivalteam.dragonsurvival.registry.datagen.tags.DSEntityTypeTags;
import by.dragonsurvivalteam.dragonsurvival.util.EnchantmentUtils;
import by.dragonsurvivalteam.dragonsurvival.util.Functions;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.MapItem;
import net.minecraft.world.item.component.MapDecorations;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.EntityJoinLevelEvent;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;
import net.neoforged.neoforge.event.entity.living.MobEffectEvent;
import org.jetbrains.annotations.Nullable;

@EventBusSubscriber
public class HunterOmenHandler {
    @SubscribeEvent
    public static void applyHunterOmenOnMurderedEntities(LivingDeathEvent deathEvent) {
        LivingEntity livingEntity = deathEvent.getEntity();
        Entity killer = deathEvent.getSource().getEntity();
        if (killer instanceof Player) {
            Player player = (Player)killer;
            if (livingEntity.getType().is(DSEntityTypeTags.HUNTER_FACTION)) {
                HunterOmenHandler.applyHunterOmenFromKilling(player);
            }
        }
    }

    public static boolean avoidPlayer(LivingEntity villager, LivingEntity target) {
        if (!(target instanceof Player)) {
            return false;
        }
        Player player = (Player)target;
        double visibilityPercent = player.getVisibilityPercent((Entity)villager);
        double visibleRange = Math.max(8.0 * visibilityPercent, 2.0);
        if (villager.distanceToSqr((Entity)player) > visibleRange * visibleRange) {
            return false;
        }
        return !player.isCreative() && player.canBeSeenByAnyone() && player.hasEffect(DSEffects.HUNTER_OMEN);
    }

    public static List<ItemStack> generateVillagerLoot(AbstractVillager genericVillager, Level level, @Nullable Player player, boolean wasKilled) {
        ArrayList<ItemStack> trades = new ArrayList<ItemStack>();
        for (MerchantOffer offer : genericVillager.getOffers()) {
            if (offer.getResult().getItem() == Items.EMERALD) continue;
            trades.add(offer.getResult().copy());
        }
        int looting = player != null ? EnchantmentUtils.getLevel((LivingEntity)player, (ResourceKey<Enchantment>)Enchantments.LOOTING) : 0;
        int rolls = Math.min(looting + 1, trades.size());
        ArrayList<ItemStack> loot = new ArrayList<ItemStack>();
        for (int i = 0; i < rolls; ++i) {
            int roll = level.getRandom().nextInt(trades.size());
            loot.add((ItemStack)trades.remove(roll));
        }
        if (!wasKilled || !(genericVillager instanceof Villager)) {
            return loot;
        }
        Villager villager = (Villager)genericVillager;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (villager.getVillagerData().getProfession() == VillagerProfession.CARTOGRAPHER) {
                for (ItemStack stack : loot) {
                    MapDecorations decorations;
                    if (stack.getItem() != Items.MAP || (decorations = (MapDecorations)stack.get(DataComponents.MAP_DECORATIONS)) == null) continue;
                    for (MapDecorations.Entry entry : decorations.decorations().values()) {
                        if (entry.type() != DSMapDecorationTypes.DRAGON_HUNTER) continue;
                        return loot;
                    }
                }
                BlockPos castlePosition = serverLevel.findNearestMapStructure(DSTrades.ON_DRAGON_HUNTERS_CASTLE_MAPS, villager.blockPosition(), 100, true);
                if (castlePosition == null) {
                    return loot;
                }
                ItemStack map = MapItem.create((Level)serverLevel, (int)castlePosition.getX(), (int)castlePosition.getZ(), (byte)2, (boolean)true, (boolean)true);
                map.set(DataComponents.ITEM_NAME, (Object)Component.translatable((String)LangKey.ITEM_KINGDOM_EXPLORER_MAP));
                MapItem.renderBiomePreviewMap((ServerLevel)serverLevel, (ItemStack)map);
                MapItemSavedData.addTargetDecoration((ItemStack)map, (BlockPos)castlePosition, (String)"+", DSMapDecorationTypes.DRAGON_HUNTER);
                loot.add(map);
            }
        }
        return loot;
    }

    @SubscribeEvent
    public static void modifyDropsForVillagers(LivingDeathEvent event) {
        int experience;
        AbstractVillager genericVillager;
        LivingEntity livingEntity;
        block6: {
            block5: {
                livingEntity = event.getEntity();
                if (!(livingEntity instanceof AbstractVillager)) break block5;
                genericVillager = (AbstractVillager)livingEntity;
                livingEntity = event.getSource().getEntity();
                if (livingEntity instanceof Player) break block6;
            }
            return;
        }
        Player player = (Player)livingEntity;
        HunterOmenHandler.generateVillagerLoot(genericVillager, player.level(), player, true).forEach(arg_0 -> ((AbstractVillager)genericVillager).spawnAtLocation(arg_0));
        if (genericVillager instanceof Villager) {
            Villager villager = (Villager)genericVillager;
            experience = (int)Math.pow(2.0, villager.getVillagerData().getLevel());
        } else {
            experience = 4;
        }
        player.level().addFreshEntity((Entity)new ExperienceOrb(player.level(), genericVillager.getX(), genericVillager.getY() + 0.5, genericVillager.getZ(), experience));
    }

    @SubscribeEvent
    public static void preserveHunterOmenOnRespawn(LivingDeathEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        EffectsMaintainedThroughDeath effects = EffectsMaintainedThroughDeath.getData(player);
        if (player.hasEffect(DSEffects.HUNTER_OMEN)) {
            effects.addEffect(player.getEffect(DSEffects.HUNTER_OMEN));
        }
    }

    private static void applyHunterOmenFromKilling(Player player) {
        MobEffectInstance instance = player.getEffect(DSEffects.HUNTER_OMEN);
        int duration = instance != null ? instance.getDuration() : 0;
        player.addEffect(new MobEffectInstance(DSEffects.HUNTER_OMEN, Math.max(Functions.minutesToTicks(12.0), Math.min(duration * 2, Functions.minutesToTicks(30.0))), 0, false, false, true));
    }

    @SubscribeEvent
    public static void voidsHunterOmen(MobEffectEvent.Added event) {
        if (event.getEffectInstance().getEffect() == MobEffects.HERO_OF_THE_VILLAGE) {
            event.getEntity().removeEffect(DSEffects.HUNTER_OMEN);
        }
    }

    @SubscribeEvent
    public static void ironGolemTargetsMarkedPlayers(EntityJoinLevelEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof IronGolem) {
            IronGolem golem = (IronGolem)entity;
            golem.targetSelector.addGoal(5, (Goal)new NearestAttackableTargetGoal((Mob)golem, Player.class, 0, true, false, livingEntity -> livingEntity.hasEffect(DSEffects.HUNTER_OMEN)));
        }
    }

    @SubscribeEvent
    public static void handleVillagerAttack(LivingIncomingDamageEvent event) {
        Player player;
        Player attacker;
        LivingEntity target = event.getEntity();
        Entity entity = event.getSource().getEntity();
        Player player2 = attacker = entity instanceof Player ? (player = (Player)entity) : null;
        if (attacker == null || !target.getType().is(DSEntityTypeTags.HUNTER_FACTION)) {
            return;
        }
        double multiplier = attacker.getAttributeValue(DSAttributes.HUNTER_FACTION_DAMAGE);
        double damage = (double)event.getAmount() * multiplier;
        if (damage == 0.0) {
            event.setCanceled(true);
            return;
        }
        MobEffectInstance effect = attacker.getEffect(DSEffects.HUNTER_OMEN);
        int duration = 0;
        if (effect != null) {
            duration = effect.getDuration();
        }
        if (EnchantmentUtils.getLevel((LivingEntity)attacker, DSEnchantments.CURSE_OF_KINDNESS) < 1) {
            attacker.addEffect(new MobEffectInstance(DSEffects.HUNTER_OMEN, duration + Functions.secondsToTicks(30.0), 0, false, false, true));
        }
    }
}

