/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.common.handlers;

import by.dragonsurvivalteam.dragonsurvival.common.capability.DragonStateHandler;
import by.dragonsurvivalteam.dragonsurvival.common.capability.DragonStateProvider;
import by.dragonsurvivalteam.dragonsurvival.common.entity.DragonEntity;
import by.dragonsurvivalteam.dragonsurvival.compat.Compat;
import by.dragonsurvivalteam.dragonsurvival.mixins.EntityAccessor;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.body.DragonBody;
import by.dragonsurvivalteam.dragonsurvival.server.handlers.ServerFlightHandler;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.EntityEvent;
import net.neoforged.neoforge.event.entity.EntityJoinLevelEvent;
import net.neoforged.neoforge.event.entity.EntityLeaveLevelEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;
import org.jetbrains.annotations.Nullable;

@EventBusSubscriber
public class DragonSizeHandler {
    private static final ConcurrentHashMap<String, Boolean> WAS_DRAGON = new ConcurrentHashMap();

    @SubscribeEvent
    public static void initializeGrowthOnJoin(EntityJoinLevelEvent event) {
        ServerPlayer serverPlayer;
        DragonStateHandler data;
        Entity entity = event.getEntity();
        if (entity instanceof ServerPlayer && (data = DragonStateProvider.getData((Player)(serverPlayer = (ServerPlayer)entity))).isDragon()) {
            data.setGrowth((Player)serverPlayer, data.getGrowth(), true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void getDragonSize(EntityEvent.Size event) {
        Entity entity = event.getEntity();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        if (!DragonStateProvider.isDragon((Entity)player)) {
            return;
        }
        DragonStateHandler handler = DragonStateProvider.getData(player);
        if (handler.previousPose == null) {
            handler.previousPose = DragonSizeHandler.overridePose(player);
        }
        EntityDimensions newDimensions = DragonSizeHandler.calculateDimensions(handler, player, handler.previousPose);
        event.setNewSize(new EntityDimensions(newDimensions.width(), newDimensions.height(), newDimensions.eyeHeight(), event.getOldSize().attachments(), event.getOldSize().fixed()));
    }

    public static double calculateDragonEyeHeight(DragonStateHandler handler, Player player) {
        double scale = player.getAttributeValue(Attributes.SCALE);
        double eyeHeight = ((DragonBody)handler.body().value()).scalingProportions().eyeHeight();
        return DragonSizeHandler.applyPose(eyeHeight * scale, DragonSizeHandler.overridePose(player), ((DragonBody)handler.body().value()).crouchHeightRatio());
    }

    public static EntityDimensions calculateDimensions(DragonStateHandler handler, Player player, @Nullable Pose overridePose) {
        double scale = player.getAttributeValue(Attributes.SCALE);
        double height = ((DragonBody)handler.body().value()).scalingProportions().height();
        double eyeHeight = ((DragonBody)handler.body().value()).scalingProportions().eyeHeight();
        double width = ((DragonBody)handler.body().value()).scalingProportions().width();
        height = DragonSizeHandler.applyPose(height, overridePose, ((DragonBody)handler.body().value()).crouchHeightRatio());
        eyeHeight = DragonSizeHandler.applyPose(eyeHeight, overridePose, ((DragonBody)handler.body().value()).crouchHeightRatio());
        return EntityDimensions.scalable((float)((float)(width * scale)), (float)((float)(height * scale))).withEyeHeight((float)(eyeHeight * scale));
    }

    public static double applyPose(double height, @Nullable Pose pose, double crouchHeightRatio) {
        if (pose == Pose.CROUCHING || pose == Pose.FALL_FLYING || pose == Pose.SWIMMING || pose == Pose.SPIN_ATTACK) {
            height *= crouchHeightRatio;
        }
        return height;
    }

    public static Pose overridePose(Player player) {
        Pose overridePose = DragonSizeHandler.getOverridePose(player);
        if (player == null) {
            return overridePose;
        }
        if (Compat.hasModelSwap(player)) {
            player.setForcedPose(null);
            return overridePose;
        }
        if (player.getForcedPose() != overridePose) {
            player.setForcedPose(overridePose);
        }
        DragonStateHandler data = DragonStateProvider.getData(player);
        data.previousPose = overridePose;
        return overridePose;
    }

    public static Pose getOverridePose(Player player) {
        if (player == null) {
            return Pose.STANDING;
        }
        Pose pose = (player.getAbilities().flying || ServerFlightHandler.isFlying(player)) && !player.isSleeping() ? Pose.FALL_FLYING : (DragonEntity.isConsideredSwimmingForAnimation(player) && player.isSprinting() ? Pose.SWIMMING : (player.isAutoSpinAttack() ? Pose.SPIN_ATTACK : (player.isShiftKeyDown() ? Pose.CROUCHING : Pose.STANDING)));
        if (player.isSpectator() || player.isPassenger() || DragonSizeHandler.canPoseFit(player, pose)) {
            return pose;
        }
        if (DragonSizeHandler.canPoseFit(player, Pose.CROUCHING)) {
            return Pose.CROUCHING;
        }
        return Pose.STANDING;
    }

    public static void fudgePositionAfterSizeChange(Entity entity, EntityDimensions newDimensions) {
        EntityDimensions oldDimensions = ((EntityAccessor)entity).dragonSurvival$getDimensions();
        double widthChange = (double)Math.max(0.0f, oldDimensions.width() - newDimensions.width()) + 1.0E-6;
        double heightChange = (double)Math.max(0.0f, oldDimensions.height() - newDimensions.height()) + 1.0E-6;
        Vec3 halfHeightPosition = entity.position().add(0.0, (double)(newDimensions.height() / 2.0f), 0.0);
        VoxelShape fullHeightVoxelShape = Shapes.create((AABB)AABB.ofSize((Vec3)halfHeightPosition, (double)widthChange, (double)heightChange, (double)widthChange));
        Optional fullHeightFreePosition = entity.level().findFreePosition(entity, fullHeightVoxelShape, halfHeightPosition, (double)oldDimensions.width(), (double)oldDimensions.height(), (double)oldDimensions.width());
        if (fullHeightFreePosition.isPresent()) {
            entity.setPos(((Vec3)fullHeightFreePosition.get()).add(0.0, (double)(-oldDimensions.height() / 2.0f), 0.0));
        } else {
            VoxelShape deltaHeightVoxelShape = Shapes.create((AABB)AABB.ofSize((Vec3)halfHeightPosition, (double)widthChange, (double)1.0E-6, (double)widthChange));
            entity.level().findFreePosition(entity, deltaHeightVoxelShape, halfHeightPosition, (double)oldDimensions.width(), (double)newDimensions.height(), (double)oldDimensions.width()).ifPresent(freePosition -> entity.setPos(freePosition.add(0.0, (double)(-newDimensions.height()) / 20.0 + 1.0E-6, 0.0)));
        }
    }

    public static boolean canPoseFit(Player player, @Nullable Pose pose) {
        return player.level().noCollision(DragonSizeHandler.calculateDimensions(DragonStateProvider.getData(player), player, pose).makeBoundingBox(player.position()).deflate(1.0E-7));
    }

    @SubscribeEvent
    public static void handleLerpGrowthAndPose(PlayerTickEvent.Pre event) {
        Player player = event.getEntity();
        DragonStateHandler data = DragonStateProvider.getData(player);
        boolean isDragon = data.isDragon();
        Boolean wasDragon = WAS_DRAGON.put(DragonSizeHandler.getKey(player), isDragon);
        if (wasDragon != null && wasDragon.booleanValue() && !isDragon) {
            player.setForcedPose(null);
            player.refreshDimensions();
        } else if (isDragon) {
            data.lerpGrowth(player);
            DragonSizeHandler.overridePose(event.getEntity());
        }
    }

    @SubscribeEvent
    public static void removeMapEntry(EntityLeaveLevelEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            WAS_DRAGON.remove(DragonSizeHandler.getKey(player));
        }
    }

    private static String getKey(Player player) {
        return player.getId() + (player.level().isClientSide() ? "client" : "server");
    }
}

