/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.common.handlers;

import by.dragonsurvivalteam.dragonsurvival.common.capability.DragonStateHandler;
import by.dragonsurvivalteam.dragonsurvival.common.capability.DragonStateProvider;
import by.dragonsurvivalteam.dragonsurvival.common.codecs.GrowthItem;
import by.dragonsurvivalteam.dragonsurvival.network.player.SyncGrowthState;
import by.dragonsurvivalteam.dragonsurvival.registry.DSAdvancementTriggers;
import by.dragonsurvivalteam.dragonsurvival.registry.datagen.Translation;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.stage.DragonStage;
import by.dragonsurvivalteam.dragonsurvival.util.Functions;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;
import net.neoforged.neoforge.network.PacketDistributor;

@EventBusSubscriber
public class DragonGrowthHandler {
    @Translation(comments={"Natural growth is \u00a7cinactive\u00a7r"})
    private static final String INACTIVE = Translation.Type.GUI.wrap("message.natural_growth_inactive");
    @Translation(comments={"Natural growth is \u00a72active\u00a7r"})
    private static final String ACTIVE = Translation.Type.GUI.wrap("message.natural_growth_active");
    @Translation(comments={"You have reached the largest growth"})
    private static final String REACHED_LARGEST = Translation.Type.GUI.wrap("system.reached_largest");
    @Translation(comments={"You have reached the smallest growth"})
    private static final String REACHED_SMALLEST = Translation.Type.GUI.wrap("system.reached_smallest");
    private static final int INTERVAL = Functions.secondsToTicks(1.0);

    @SubscribeEvent
    public static void onItemUse(PlayerInteractEvent.RightClickItem event) {
        Player player = event.getEntity();
        DragonStateHandler handler = DragonStateProvider.getData(player);
        if (!handler.isDragon()) {
            return;
        }
        Double growth = DragonGrowthHandler.getGrowth(player, handler, event.getItemStack().getItem());
        if (growth.isNaN()) {
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                DSAdvancementTriggers.STOP_NATURAL_GROWTH.get().trigger(serverPlayer);
            }
            handler.isGrowthStopped = !handler.isGrowthStopped;
            event.getItemStack().consume(1, (LivingEntity)player);
            if (player.level().isClientSide()) {
                String message = handler.isGrowthStopped ? INACTIVE : ACTIVE;
                player.displayClientMessage((Component)Component.translatable((String)message), true);
            }
            return;
        }
        if (growth == 0.0) {
            return;
        }
        handler.incrementGrowthUses(event.getItemStack().getItem());
        double oldGrowth = handler.getDesiredGrowth();
        handler.setDesiredGrowth(player, handler.getDesiredGrowth() + growth);
        if (handler.getDesiredGrowth() == oldGrowth) {
            player.sendSystemMessage((Component)Component.translatable((String)(growth > 0.0 ? REACHED_LARGEST : REACHED_SMALLEST)).withStyle(ChatFormatting.RED));
            return;
        }
        event.getItemStack().consume(1, (LivingEntity)player);
    }

    public static Double getGrowth(Player player, DragonStateHandler handler, Item item) {
        for (GrowthItem growthItem : ((DragonStage)handler.stageFromDesiredSize(player).value()).growthItems()) {
            if (!growthItem.canBeUsed(handler, item)) continue;
            if (growthItem.growthInTicks() == 0) {
                return Double.NaN;
            }
            return ((DragonStage)handler.stage().value()).ticksToGrowth(growthItem.growthInTicks());
        }
        return 0.0;
    }

    @SubscribeEvent
    public static void onPlayerUpdate(PlayerTickEvent.Pre event) {
        Player player = event.getEntity();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer serverPlayer = (ServerPlayer)player;
        DragonStateHandler handler = DragonStateProvider.getData((Player)serverPlayer);
        if (!handler.isDragon()) {
            return;
        }
        if (serverPlayer.tickCount % INTERVAL == 0) {
            double desiredGrowth;
            DragonStage dragonStage = (DragonStage)handler.stage().value();
            double oldGrowth = handler.getDesiredGrowth();
            if (oldGrowth == (desiredGrowth = handler.getDesiredGrowth() + dragonStage.ticksToGrowth(INTERVAL)) || dragonStage.isNaturalGrowthStopped().map(condition -> condition.matches(serverPlayer.serverLevel(), serverPlayer.position(), (Entity)serverPlayer)).orElse(false).booleanValue()) {
                if (handler.isGrowing) {
                    handler.isGrowing = false;
                    PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new SyncGrowthState(false), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
                return;
            }
            if (!handler.isGrowing) {
                handler.isGrowing = true;
                PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new SyncGrowthState(true), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
            handler.setDesiredGrowth((Player)serverPlayer, desiredGrowth);
        }
    }
}

