/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.common.handlers;

import by.dragonsurvivalteam.dragonsurvival.common.capability.DragonStateProvider;
import by.dragonsurvivalteam.dragonsurvival.common.entity.DragonEntity;
import by.dragonsurvivalteam.dragonsurvival.network.status.SyncPlayerJump;
import by.dragonsurvivalteam.dragonsurvival.registry.DSEffects;
import by.dragonsurvivalteam.dragonsurvival.registry.attachments.DSDataAttachments;
import by.dragonsurvivalteam.dragonsurvival.registry.attachments.ItemData;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingEvent;
import net.neoforged.neoforge.event.level.BlockDropsEvent;
import net.neoforged.neoforge.network.PacketDistributor;

@EventBusSubscriber
public class DragonBonusHandler {
    @SubscribeEvent
    public static void onJump(LivingEvent.LivingJumpEvent event) {
        LivingEntity entity = event.getEntity();
        if (entity.getEffect(DSEffects.TRAPPED) != null) {
            Vec3 deltaMovement = entity.getDeltaMovement();
            entity.setDeltaMovement(deltaMovement.x, deltaMovement.y < 0.0 ? deltaMovement.y : 0.0, deltaMovement.z);
            entity.setJumping(false);
            return;
        }
        if (!DragonStateProvider.isDragon((Entity)entity)) {
            return;
        }
        if (entity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)entity;
            PacketDistributor.sendToPlayersTrackingEntity((Entity)serverPlayer, (CustomPacketPayload)new SyncPlayerJump(entity.getId(), true), (CustomPacketPayload[])new CustomPacketPayload[0]);
        } else if (entity instanceof Player) {
            Player player = (Player)entity;
            DragonEntity.DRAGONS_JUMPING.put(player.getId(), true);
        }
    }

    @SubscribeEvent
    public static void addFireProtectionToDragonDrops(BlockDropsEvent event) {
        if (event.getBreaker() == null) {
            return;
        }
        if (event.getBreaker().fireImmune() && DragonStateProvider.isDragon(event.getBreaker()) && event.getBreaker().isInLava()) {
            event.getDrops().forEach(drop -> {
                ((ItemData)drop.getData(DSDataAttachments.ITEM)).isFireImmune = true;
            });
        }
    }
}

