/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.common.entity.projectiles;

import by.dragonsurvivalteam.dragonsurvival.DragonSurvival;
import by.dragonsurvivalteam.dragonsurvival.common.codecs.Condition;
import by.dragonsurvivalteam.dragonsurvival.common.codecs.LevelBasedResource;
import by.dragonsurvivalteam.dragonsurvival.registry.DSEntities;
import by.dragonsurvivalteam.dragonsurvival.registry.datagen.Translation;
import by.dragonsurvivalteam.dragonsurvival.registry.projectile.ProjectileData;
import by.dragonsurvivalteam.dragonsurvival.registry.projectile.block_effects.ProjectileBlockEffect;
import by.dragonsurvivalteam.dragonsurvival.registry.projectile.entity_effects.ProjectileEntityEffect;
import by.dragonsurvivalteam.dragonsurvival.registry.projectile.targeting.ProjectileTargeting;
import com.mojang.serialization.DynamicOps;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.projectile.AbstractHurtingProjectile;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.enchantment.LevelBasedValue;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.util.Lazy;
import net.neoforged.neoforge.entity.IEntityWithComplexSpawn;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class GenericBallEntity
extends AbstractHurtingProjectile
implements GeoEntity,
IEntityWithComplexSpawn {
    private static final EntityDataAccessor<Boolean> LINGERING = SynchedEntityData.defineId(GenericBallEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private ProjectileData.GeneralData generalData;
    private ProjectileData.GenericBallData typeData;
    private int projectileLevel;
    private final Lazy<EntityDimensions> dimensions = Lazy.of(() -> EntityDimensions.scalable((float)this.getTypeData().behaviourData().width().calculate(this.projectileLevel), (float)this.getTypeData().behaviourData().height().calculate(this.projectileLevel)));
    private float movementDistance;
    private int lingerTicks;
    private int lifespan;
    private int bounces;
    private Entity lastEntityHit;
    private BlockPos lastBlockHit;
    private boolean hitWasTriggeredByLifespanOrDistance;
    private static final RawAnimation EXPLOSION = RawAnimation.begin().thenLoop("explosion");
    private static final RawAnimation IDLE = RawAnimation.begin().thenLoop("idle");
    private static final RawAnimation FLY = RawAnimation.begin().thenLoop("fly");
    private static final String GENERAL_DATA = "general_data";
    private static final String TYPE_DATA = "type_data";
    private static final String PROJECTILE_LEVEL = "projectile_level";
    private static final String MOVEMENT_DISTANCE = "movement_distance";
    private static final String LINGERING_TICKS = "lingering_ticks";
    private static final String LIFESPAN = "lifespan";
    private static final String BOUNCES = "bounces";

    public GenericBallEntity(ProjectileData.GeneralData generalData, ProjectileData.GenericBallData typeData, int projectileLevel, Vec3 position, Level level) {
        super((EntityType)DSEntities.GENERIC_BALL_ENTITY.get(), level);
        this.generalData = generalData;
        this.typeData = typeData;
        this.projectileLevel = projectileLevel;
        this.accelerationPower = 0.0;
        this.refreshDimensions();
        this.setPos(position.x, position.y, position.z);
        this.reapplyPosition();
    }

    public ProjectileData.GeneralData getGeneralData() {
        if (this.generalData == null) {
            DragonSurvival.LOGGER.error("Attempted to get generalData for GenericBallEntity, but it was not initialized! Destroying projectile.");
            this.discard();
            return new ProjectileData.GeneralData(ResourceLocation.fromNamespaceAndPath((String)"dragonsurvival", (String)"generic_ball"), Optional.empty(), List.of(), List.of(), List.of(), List.of());
        }
        return this.generalData;
    }

    public ProjectileData.GenericBallData getTypeData() {
        if (this.typeData == null) {
            DragonSurvival.LOGGER.error("Attempted to get typeData for GenericBallEntity, but it was not initialized! Destroying projectile.");
            this.discard();
            return new ProjectileData.GenericBallData(new LevelBasedResource(List.of(new LevelBasedResource.Entry(DragonSurvival.res("generic_ball"), 1))), Optional.empty(), List.of(), new ProjectileData.BehaviourData((LevelBasedValue)LevelBasedValue.constant((float)1.0f), (LevelBasedValue)LevelBasedValue.constant((float)1.0f), (LevelBasedValue)LevelBasedValue.constant((float)0.0f), (LevelBasedValue)LevelBasedValue.constant((float)0.0f), (LevelBasedValue)LevelBasedValue.constant((float)32.0f), (LevelBasedValue)LevelBasedValue.constant((float)100.0f)));
        }
        return this.typeData;
    }

    public GenericBallEntity(EntityType<GenericBallEntity> type, Level level) {
        super(type, level);
    }

    public void writeSpawnData(@NotNull RegistryFriendlyByteBuf buffer) {
        ByteBufCodecs.fromCodecWithRegistries(ProjectileData.GeneralData.CODEC).encode((Object)buffer, (Object)this.getGeneralData());
        ByteBufCodecs.fromCodecWithRegistries(ProjectileData.GenericBallData.CODEC).encode((Object)buffer, (Object)this.getTypeData());
        buffer.writeVarInt(this.projectileLevel);
    }

    public void readSpawnData(@NotNull RegistryFriendlyByteBuf buffer) {
        this.generalData = (ProjectileData.GeneralData)ByteBufCodecs.fromCodecWithRegistries(ProjectileData.GeneralData.CODEC).decode((Object)buffer);
        this.typeData = (ProjectileData.GenericBallData)ByteBufCodecs.fromCodecWithRegistries(ProjectileData.GenericBallData.CODEC).decode((Object)buffer);
        this.projectileLevel = buffer.readVarInt();
        this.accelerationPower = 0.0;
        this.refreshDimensions();
    }

    public void addAdditionalSaveData(@NotNull CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        RegistryOps context = this.level().registryAccess().createSerializationContext((DynamicOps)NbtOps.INSTANCE);
        ProjectileData.GeneralData.CODEC.encodeStart((DynamicOps)context, (Object)this.getGeneralData()).ifSuccess(data -> tag.put(GENERAL_DATA, data));
        ProjectileData.GenericBallData.CODEC.encodeStart((DynamicOps)context, (Object)this.getTypeData()).ifSuccess(data -> tag.put(TYPE_DATA, data));
        tag.putInt(PROJECTILE_LEVEL, this.projectileLevel);
        tag.putFloat(MOVEMENT_DISTANCE, this.movementDistance);
        tag.putInt(LINGERING_TICKS, this.lingerTicks);
        tag.putInt(LIFESPAN, this.lifespan);
        tag.putInt(BOUNCES, this.bounces);
    }

    public void readAdditionalSaveData(@NotNull CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        RegistryOps context = this.level().registryAccess().createSerializationContext((DynamicOps)NbtOps.INSTANCE);
        if (tag.contains(GENERAL_DATA)) {
            ProjectileData.GeneralData.CODEC.parse((DynamicOps)context, (Object)tag.get(GENERAL_DATA)).resultOrPartial(arg_0 -> ((Logger)DragonSurvival.LOGGER).error(arg_0)).map(data -> {
                this.generalData = data;
                return this.generalData;
            });
        }
        if (tag.contains(TYPE_DATA)) {
            ProjectileData.GenericBallData.CODEC.parse((DynamicOps)context, (Object)tag.get(TYPE_DATA)).resultOrPartial(arg_0 -> ((Logger)DragonSurvival.LOGGER).error(arg_0)).map(data -> {
                this.typeData = data;
                return this.typeData;
            });
        }
        if (this.generalData == null || this.typeData == null) {
            this.discard();
            return;
        }
        this.projectileLevel = tag.getInt(PROJECTILE_LEVEL);
        this.movementDistance = tag.getFloat(MOVEMENT_DISTANCE);
        this.lingerTicks = tag.getInt(LINGERING_TICKS);
        this.lifespan = tag.getInt(LIFESPAN);
        this.bounces = tag.getInt(BOUNCES);
        this.accelerationPower = 0.0;
        this.refreshDimensions();
    }

    @NotNull
    public EntityDimensions getDimensions(@NotNull Pose pose) {
        return (EntityDimensions)this.dimensions.get();
    }

    private boolean isLingering() {
        return (Boolean)this.entityData.get(LINGERING);
    }

    private void setLingering(boolean isLingering) {
        this.entityData.set(LINGERING, (Object)isLingering);
        if (isLingering) {
            this.setDeltaMovement(Vec3.ZERO);
        }
    }

    @NotNull
    protected Component getTypeName() {
        if (this.generalData == null) {
            return super.getTypeName();
        }
        return Component.translatable((String)Translation.Type.PROJECTILE.wrap(this.getGeneralData().name()));
    }

    protected ParticleOptions getTrailParticle() {
        return this.getTypeData().trailParticle().orElse(null);
    }

    protected boolean canHitEntity(@NotNull Entity target) {
        if (!super.canHitEntity(target)) {
            return false;
        }
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (this.getGeneralData().entityHitCondition().isPresent()) {
                return this.getGeneralData().entityHitCondition().get().test((Object)Condition.projectileContext(serverLevel, (Projectile)this, target));
            }
        }
        return true;
    }

    protected void onDestroy() {
        if (this.level().isClientSide()) {
            return;
        }
        for (ProjectileTargeting effect : this.getTypeData().onDestroyEffects()) {
            effect.apply((Projectile)this, this.projectileLevel);
        }
        this.discard();
    }

    protected void defineSynchedData(@NotNull SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(LINGERING, (Object)false);
    }

    @NotNull
    public Vec3 getDeltaMovement() {
        if (this.isLingering()) {
            return Vec3.ZERO;
        }
        return super.getDeltaMovement();
    }

    public void tick() {
        super.tick();
        this.movementDistance += (float)this.getDeltaMovement().length();
        ++this.lifespan;
        if (this.movementDistance > (float)this.getMaxMovementDistance() || this.lifespan > this.getMaxLifespan()) {
            this.hitWasTriggeredByLifespanOrDistance = true;
            this.onHitBlock(new BlockHitResult(this.position(), this.getDirection(), this.blockPosition(), false));
        }
        if (!this.level().isClientSide()) {
            for (ProjectileTargeting effect : this.getGeneralData().tickingEffects()) {
                effect.apply((Projectile)this, this.projectileLevel);
            }
        }
        if (this.isLingering()) {
            ++this.lingerTicks;
            if (this.lingerTicks > this.getMaxLingeringTicks()) {
                this.onDestroy();
            }
        }
    }

    protected void onHitEntity(@NotNull EntityHitResult hitResult) {
        if (hitResult.getEntity() == this.lastEntityHit) {
            return;
        }
        this.lastEntityHit = hitResult.getEntity();
        super.onHitEntity(hitResult);
        if (!this.level().isClientSide()) {
            for (ProjectileEntityEffect effect : this.getGeneralData().entityHitEffects()) {
                effect.apply((Projectile)this, hitResult.getEntity(), this.projectileLevel);
            }
        }
        this.onHitCommon(hitResult.getEntity().getDirection(), true);
    }

    protected void onHitBlock(@NotNull BlockHitResult hitResult) {
        if (hitResult.isInside()) {
            this.onDestroy();
            return;
        }
        if (hitResult.getBlockPos().equals((Object)this.lastBlockHit)) {
            return;
        }
        this.lastBlockHit = hitResult.getBlockPos();
        super.onHitBlock(hitResult);
        if (!this.level().isClientSide()) {
            for (ProjectileBlockEffect effect : this.getGeneralData().blockHitEffects()) {
                effect.apply((Projectile)this, hitResult.getBlockPos(), this.projectileLevel);
            }
        }
        this.onHitCommon(hitResult.getDirection(), false);
    }

    private void reflect() {
        Vec3 motion = this.getDeltaMovement();
        this.setDeltaMovement(-motion.x(), -motion.y(), -motion.z());
        ++this.bounces;
    }

    private void bounce(Direction direction) {
        Vec3 motion = this.getDeltaMovement();
        double x = motion.x();
        double y = motion.y();
        double z = motion.z();
        switch (direction) {
            case NORTH: 
            case SOUTH: {
                this.setDeltaMovement(x, y, -z);
                break;
            }
            case EAST: 
            case WEST: {
                this.setDeltaMovement(-x, y, z);
                break;
            }
            case UP: 
            case DOWN: {
                this.setDeltaMovement(x, -y, z);
            }
        }
        ++this.bounces;
    }

    public void onHitCommon(Direction direction, boolean wasEntity) {
        if (!this.level().isClientSide()) {
            for (ProjectileTargeting effect : this.getGeneralData().commonHitEffects()) {
                effect.apply((Projectile)this, this.projectileLevel);
            }
            if (this.getMaxLingeringTicks() <= 0 && this.bounces >= this.getMaxBounces()) {
                this.onDestroy();
            }
        }
        if (!this.isLingering() && (this.bounces >= this.getMaxBounces() || this.hitWasTriggeredByLifespanOrDistance)) {
            this.setLingering(true);
        } else if (this.bounces < this.getMaxBounces()) {
            if (wasEntity) {
                this.reflect();
            } else {
                this.bounce(direction);
            }
        }
    }

    public PlayState predicate(AnimationState<GenericBallEntity> state) {
        if (!this.isLingering() && this.getMaxLingeringTicks() > 0) {
            state.getController().setAnimation(FLY);
            return PlayState.CONTINUE;
        }
        if (this.lingerTicks < 16 && this.getMaxLingeringTicks() > 0) {
            state.getController().setAnimation(EXPLOSION);
        } else {
            state.getController().setAnimation(IDLE);
        }
        return PlayState.CONTINUE;
    }

    public ResourceLocation getTextureResource() {
        return this.getTypeData().resources().get(this.projectileLevel);
    }

    public ResourceLocation getAnimationResource() {
        return this.getTypeData().resources().get(this.projectileLevel);
    }

    public ResourceLocation getModelResource() {
        return this.getTypeData().resources().get(this.projectileLevel);
    }

    private int getMaxBounces() {
        return (int)this.getTypeData().behaviourData().maxBounces().calculate(this.projectileLevel);
    }

    public int getMaxLingeringTicks() {
        return (int)this.getTypeData().behaviourData().maxLingeringTicks().calculate(this.projectileLevel);
    }

    public int getMaxMovementDistance() {
        return (int)this.getTypeData().behaviourData().maxMovementDistance().calculate(this.projectileLevel);
    }

    public int getMaxLifespan() {
        return (int)this.getTypeData().behaviourData().maxLifespan().calculate(this.projectileLevel);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar registrar) {
        registrar.add(new AnimationController((GeoAnimatable)this, "everything", this::predicate));
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    protected float getInertia() {
        return 1.0f;
    }

    protected boolean shouldBurn() {
        return false;
    }

    public boolean fireImmune() {
        return true;
    }
}

