/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.common.entity.projectiles;

import by.dragonsurvivalteam.dragonsurvival.DragonSurvival;
import by.dragonsurvivalteam.dragonsurvival.common.codecs.Condition;
import by.dragonsurvivalteam.dragonsurvival.common.codecs.LevelBasedResource;
import by.dragonsurvivalteam.dragonsurvival.registry.DSEntities;
import by.dragonsurvivalteam.dragonsurvival.registry.datagen.Translation;
import by.dragonsurvivalteam.dragonsurvival.registry.projectile.ProjectileData;
import by.dragonsurvivalteam.dragonsurvival.registry.projectile.block_effects.ProjectileBlockEffect;
import by.dragonsurvivalteam.dragonsurvival.registry.projectile.entity_effects.ProjectileDamageEffect;
import by.dragonsurvivalteam.dragonsurvival.registry.projectile.entity_effects.ProjectileEntityEffect;
import by.dragonsurvivalteam.dragonsurvival.registry.projectile.targeting.ProjectileTargeting;
import com.mojang.serialization.DynamicOps;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundGameEventPacket;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Unit;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileDeflection;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.LevelBasedValue;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.entity.IEntityWithComplexSpawn;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GenericArrowEntity
extends AbstractArrow
implements IEntityWithComplexSpawn {
    private ProjectileData.GeneralData generalData;
    private ProjectileData.GenericArrowData typeData;
    private int projectileLevel;
    @Nullable
    private IntOpenHashSet piercingIgnoreEntityIds;
    @Nullable
    private Entity lastDeflectedBy;
    private static final String GENERAL_DATA = "general_data";
    private static final String TYPE_DATA = "type_data";
    private static final String PROJECTILE_LEVEL = "projectile_level";

    public GenericArrowEntity(ProjectileData.GeneralData generalData, ProjectileData.GenericArrowData typeData, int projectileLevel, Vec3 position, Level level) {
        super((EntityType)DSEntities.GENERIC_ARROW_ENTITY.get(), level);
        this.generalData = generalData;
        this.typeData = typeData;
        this.projectileLevel = projectileLevel;
        this.setPierceLevel((byte)typeData.piercingLevel().calculate(projectileLevel));
        this.setPos(position.x, position.y, position.z);
        this.reapplyPosition();
    }

    public GenericArrowEntity(EntityType<? extends AbstractArrow> type, Level level) {
        super(type, level);
    }

    public ProjectileData.GeneralData getGeneralData() {
        if (this.generalData == null) {
            DragonSurvival.LOGGER.error("Attempted to get generalData for GenericArrowEntity, but it was not initialized! Destroying projectile.");
            this.discard();
            return new ProjectileData.GeneralData(ResourceLocation.fromNamespaceAndPath((String)"dragonsurvival", (String)"generic_ball"), Optional.empty(), List.of(), List.of(), List.of(), List.of());
        }
        return this.generalData;
    }

    public ProjectileData.GenericArrowData getTypeData() {
        if (this.typeData == null) {
            DragonSurvival.LOGGER.error("Attempted to get typeData for GenericArrowEntity, but it was not initialized! Destroying projectile.");
            this.discard();
            return new ProjectileData.GenericArrowData(new LevelBasedResource(List.of(new LevelBasedResource.Entry(DragonSurvival.res("generic_arrow"), 1))), (LevelBasedValue)LevelBasedValue.constant((float)0.0f));
        }
        return this.typeData;
    }

    public void writeSpawnData(@NotNull RegistryFriendlyByteBuf buffer) {
        ByteBufCodecs.fromCodecWithRegistries(ProjectileData.GeneralData.CODEC).encode((Object)buffer, (Object)this.getGeneralData());
        ByteBufCodecs.fromCodecWithRegistries(ProjectileData.GenericArrowData.CODEC).encode((Object)buffer, (Object)this.getTypeData());
        buffer.writeVarInt(this.projectileLevel);
    }

    public void readSpawnData(@NotNull RegistryFriendlyByteBuf buffer) {
        this.generalData = (ProjectileData.GeneralData)ByteBufCodecs.fromCodecWithRegistries(ProjectileData.GeneralData.CODEC).decode((Object)buffer);
        this.typeData = (ProjectileData.GenericArrowData)ByteBufCodecs.fromCodecWithRegistries(ProjectileData.GenericArrowData.CODEC).decode((Object)buffer);
        this.projectileLevel = buffer.readVarInt();
    }

    public void addAdditionalSaveData(@NotNull CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        RegistryOps context = this.level().registryAccess().createSerializationContext((DynamicOps)NbtOps.INSTANCE);
        ProjectileData.GeneralData.CODEC.encodeStart((DynamicOps)context, (Object)this.getGeneralData()).ifSuccess(data -> tag.put(GENERAL_DATA, data));
        ProjectileData.GenericArrowData.CODEC.encodeStart((DynamicOps)context, (Object)this.getTypeData()).ifSuccess(data -> tag.put(TYPE_DATA, data));
        tag.putInt(PROJECTILE_LEVEL, this.projectileLevel);
    }

    public void readAdditionalSaveData(@NotNull CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        RegistryOps context = this.level().registryAccess().createSerializationContext((DynamicOps)NbtOps.INSTANCE);
        if (tag.contains(GENERAL_DATA)) {
            ProjectileData.GeneralData.CODEC.parse((DynamicOps)context, (Object)tag.get(GENERAL_DATA)).resultOrPartial(arg_0 -> ((Logger)DragonSurvival.LOGGER).error(arg_0)).map(data -> {
                this.generalData = data;
                return this.generalData;
            });
        }
        if (tag.contains(TYPE_DATA)) {
            ProjectileData.GenericArrowData.CODEC.parse((DynamicOps)context, (Object)tag.get(TYPE_DATA)).resultOrPartial(arg_0 -> ((Logger)DragonSurvival.LOGGER).error(arg_0)).map(data -> {
                this.typeData = data;
                return this.typeData;
            });
        }
        if (this.generalData == null || this.typeData == null) {
            this.discard();
            return;
        }
        this.projectileLevel = tag.getInt(PROJECTILE_LEVEL);
    }

    @NotNull
    protected Component getTypeName() {
        if (this.generalData == null) {
            return super.getTypeName();
        }
        return Component.translatable((String)Translation.Type.PROJECTILE.wrap(this.getGeneralData().name()));
    }

    protected boolean canHitEntity(@NotNull Entity target) {
        if (!super.canHitEntity(target) || this.piercingIgnoreEntityIds != null && this.piercingIgnoreEntityIds.contains(target.getId())) {
            return false;
        }
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (this.getGeneralData().entityHitCondition().isPresent()) {
                return this.getGeneralData().entityHitCondition().get().test((Object)Condition.projectileContext(serverLevel, (Projectile)this, target));
            }
        }
        return true;
    }

    private void onHitCommon() {
        if (this.level().isClientSide()) {
            return;
        }
        for (ProjectileTargeting effect : this.getGeneralData().commonHitEffects()) {
            effect.apply((Projectile)this, this.projectileLevel);
        }
    }

    protected void onHitBlock(@NotNull BlockHitResult result) {
        super.onHitBlock(result);
        if (this.level().isClientSide()) {
            return;
        }
        for (ProjectileBlockEffect effect : this.getGeneralData().blockHitEffects()) {
            effect.apply((Projectile)this, result.getBlockPos(), this.projectileLevel);
        }
        this.onHitCommon();
    }

    protected void onHitEntity(@NotNull EntityHitResult result) {
        boolean hasImmunityFrames;
        Entity target = result.getEntity();
        if (this.getPierceLevel() > 0) {
            if (this.piercingIgnoreEntityIds == null) {
                this.piercingIgnoreEntityIds = new IntOpenHashSet(5);
            }
            if (this.piercingIgnoreEntityIds.size() >= this.getPierceLevel() + 1) {
                this.discard();
                return;
            }
            this.piercingIgnoreEntityIds.add(target.getId());
        }
        if (this.level().isClientSide()) {
            return;
        }
        Entity owner = this.getOwner();
        boolean targetIsImmune = false;
        boolean considerImmunityFrames = true;
        for (ProjectileEntityEffect effect : this.getGeneralData().entityHitEffects()) {
            if (!(effect instanceof ProjectileDamageEffect)) continue;
            ProjectileDamageEffect damageEffect = (ProjectileDamageEffect)effect;
            if (damageEffect.damageType().is(DamageTypeTags.BYPASSES_COOLDOWN)) {
                considerImmunityFrames = false;
            }
            if (!target.isInvulnerableTo(new DamageSource(damageEffect.damageType(), owner))) continue;
            targetIsImmune = true;
        }
        boolean bl = hasImmunityFrames = target.invulnerableTime > 10;
        boolean isImmune = considerImmunityFrames ? hasImmunityFrames && targetIsImmune : targetIsImmune;
        ProjectileDeflection deflection = target.deflection((Projectile)this);
        if (target != this.lastDeflectedBy && deflection != ProjectileDeflection.NONE && this.piercingIgnoreEntityIds != null && this.piercingIgnoreEntityIds.size() >= this.getPierceLevel() + 1 && isImmune && this.deflect(ProjectileDeflection.REVERSE, this.getOwner(), target, target instanceof Player)) {
            this.lastDeflectedBy = target;
        } else if (!isImmune) {
            for (ProjectileEntityEffect effect : this.getGeneralData().entityHitEffects()) {
                effect.apply((Projectile)this, result.getEntity(), this.projectileLevel);
            }
            if (owner instanceof Player && target instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)target;
                if (!this.isSilent()) {
                    serverPlayer.connection.send((Packet)new ClientboundGameEventPacket(ClientboundGameEventPacket.ARROW_HIT_PLAYER, 0.0f));
                }
            }
        }
        this.onHitCommon();
        if (this.getPierceLevel() == 0) {
            this.discard();
        }
    }

    public void tick() {
        super.tick();
        if (this.level().isClientSide() || this.inGround) {
            return;
        }
        for (ProjectileTargeting effect : this.getGeneralData().tickingEffects()) {
            effect.apply((Projectile)this, this.projectileLevel);
        }
    }

    public ResourceLocation getResource() {
        return this.getTypeData().texture().get(this.projectileLevel);
    }

    @NotNull
    protected ItemStack getPickupItem() {
        ItemStack stack = Items.ARROW.getDefaultInstance();
        stack.set(DataComponents.INTANGIBLE_PROJECTILE, (Object)Unit.INSTANCE);
        return stack;
    }

    @NotNull
    protected ItemStack getDefaultPickupItem() {
        ItemStack stack = Items.ARROW.getDefaultInstance();
        stack.set(DataComponents.INTANGIBLE_PROJECTILE, (Object)Unit.INSTANCE);
        return stack;
    }
}

