/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.common.entity.goals;

import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import org.jetbrains.annotations.NotNull;

public class WindupMeleeAttackGoal
extends MeleeAttackGoal {
    private int ticksUntilDamage;
    private final int attackTicks;
    private boolean hasPerformedAttack;

    public WindupMeleeAttackGoal(PathfinderMob pMob, double pSpeedModifier, int pAttackTicks) {
        super(pMob, pSpeedModifier, true);
        this.attackTicks = pAttackTicks;
    }

    public void tick() {
        super.tick();
        this.ticksUntilDamage = Math.max(0, this.ticksUntilDamage - 1);
        LivingEntity target = this.mob.getTarget();
        if (target != null) {
            this.checkAndPerformWindupAttack(target);
        }
    }

    protected void checkAndPerformWindupAttack(@NotNull LivingEntity pTarget) {
        if (this.canPerformAttack(pTarget) || this.mob.swinging) {
            if (!this.mob.swinging) {
                this.mob.swing(InteractionHand.MAIN_HAND);
                this.ticksUntilDamage = this.attackTicks;
                this.hasPerformedAttack = false;
            }
            if (this.ticksUntilDamage <= 0 && !this.hasPerformedAttack) {
                if (this.canPerformAttack(pTarget)) {
                    this.mob.doHurtTarget((Entity)pTarget);
                }
                this.hasPerformedAttack = true;
            }
        }
    }

    protected void checkAndPerformAttack(@NotNull LivingEntity pTarget) {
    }

    protected boolean isTimeToAttack() {
        return true;
    }
}

