/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.common.entity.goals;

import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class HurtByTargetGoalExtended
extends HurtByTargetGoal {
    @Nullable
    private Class<? extends Mob>[] toHeedAlert;

    public HurtByTargetGoalExtended(PathfinderMob mob, Class<?> ... ignoreDamagedFrom) {
        super(mob, (Class[])ignoreDamagedFrom);
    }

    @SafeVarargs
    public final HurtByTargetGoal setHeeders(Class<? extends Mob> ... reinforcementTypes) {
        this.toHeedAlert = reinforcementTypes;
        return this;
    }

    protected void alertOthers() {
        if (this.toHeedAlert != null) {
            for (Class<? extends Mob> heedType : this.toHeedAlert) {
                this.alertOthers(heedType);
            }
        }
    }

    protected void alertOthers(Class<? extends Mob> type) {
        double distance = this.getFollowDistance();
        AABB aabb = AABB.unitCubeFromLowerCorner((Vec3)this.mob.position()).inflate(distance, 10.0, distance);
        this.mob.level().getEntitiesOfClass(type, aabb, EntitySelector.NO_SPECTATORS).forEach(otherMob -> {
            if (otherMob == this.mob || otherMob.getTarget() != null) {
                return;
            }
            LivingEntity lastHurtBy = this.mob.getLastHurtByMob();
            if (lastHurtBy == null || otherMob.isAlliedTo((Entity)lastHurtBy)) {
                return;
            }
            if (this.toIgnoreAlert != null) {
                for (Class toIgnore : this.toIgnoreAlert) {
                    if (otherMob.getClass() != toIgnore) continue;
                    return;
                }
            }
            this.alertOther((Mob)otherMob, lastHurtBy);
        });
    }
}

