/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.common.entity.goals;

import by.dragonsurvivalteam.dragonsurvival.registry.attachments.DSDataAttachments;
import by.dragonsurvivalteam.dragonsurvival.registry.attachments.SummonData;
import by.dragonsurvivalteam.dragonsurvival.registry.attachments.SummonedEntities;
import by.dragonsurvivalteam.dragonsurvival.util.Functions;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.pathfinder.WalkNodeEvaluator;
import org.jetbrains.annotations.Nullable;

public class FollowSummonerGoal
extends Goal {
    private final Mob mob;
    private final PathNavigation navigation;
    private final double speedModifier;
    private final float stopDistance;
    private final float startDistance;
    @Nullable
    private LivingEntity owner;
    private int timeToRecalculatePath;
    private float oldWaterCost;

    public FollowSummonerGoal(Mob mob, double speedModifier, float startDistance, float stopDistance) {
        this.mob = mob;
        this.speedModifier = speedModifier;
        this.navigation = mob.getNavigation();
        this.startDistance = startDistance;
        this.stopDistance = stopDistance;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        if (!(mob.getNavigation() instanceof GroundPathNavigation) && !(mob.getNavigation() instanceof FlyingPathNavigation)) {
            Functions.logOrThrow("Unsupported mob type for [" + ((Object)((Object)this)).getClass().getSimpleName() + "]");
        }
    }

    public boolean canUse() {
        LivingEntity owner = ((SummonData)this.mob.getData(DSDataAttachments.SUMMON)).getOwner(this.mob.level());
        if (this.shouldFollow(owner, this.startDistance)) {
            this.owner = owner;
            return true;
        }
        return false;
    }

    public boolean canContinueToUse() {
        if (this.navigation.isDone()) {
            return false;
        }
        return this.shouldFollow(this.owner, this.stopDistance);
    }

    public void start() {
        this.timeToRecalculatePath = 0;
        this.oldWaterCost = this.mob.getPathfindingMalus(PathType.WATER);
        this.mob.setPathfindingMalus(PathType.WATER, 0.0f);
    }

    public void stop() {
        this.owner = null;
        this.navigation.stop();
        this.mob.setPathfindingMalus(PathType.WATER, this.oldWaterCost);
    }

    public void tick() {
        boolean shouldTeleport;
        boolean bl = shouldTeleport = this.mob.distanceToSqr((Entity)this.owner) >= 288.0;
        if (!shouldTeleport) {
            this.mob.getLookControl().setLookAt((Entity)this.owner, 10.0f, (float)this.mob.getMaxHeadXRot());
        }
        if (--this.timeToRecalculatePath <= 0) {
            this.timeToRecalculatePath = this.adjustedTickDelay(10);
            if (shouldTeleport) {
                this.teleportToOwner();
            } else {
                this.navigation.moveTo((Entity)this.owner, this.speedModifier);
            }
        }
    }

    private boolean shouldFollow(@Nullable LivingEntity owner, float distance) {
        if (((SummonData)this.mob.getData(DSDataAttachments.SUMMON)).movementBehaviour != SummonedEntities.MovementBehaviour.FOLLOW) {
            return false;
        }
        if (owner == null || !owner.isAlive()) {
            return false;
        }
        return !(this.mob.distanceToSqr((Entity)owner) < (double)(distance * distance));
    }

    private void teleportToOwner() {
        BlockPos position = this.owner.blockPosition();
        for (int i = 0; i < 10; ++i) {
            int xOffset = this.mob.getRandom().nextIntBetweenInclusive(-3, 3);
            int zOffset = this.mob.getRandom().nextIntBetweenInclusive(-3, 3);
            if (Math.abs(xOffset) < 2 && Math.abs(zOffset) < 2) continue;
            int yOffset = this.mob.getRandom().nextIntBetweenInclusive(-1, 1);
            if (!this.maybeTeleportTo(position.getX() + xOffset, position.getY() + yOffset, position.getZ() + zOffset)) continue;
            return;
        }
    }

    private boolean maybeTeleportTo(int x, int y, int z) {
        if (!this.canTeleportTo(BlockPos.containing((double)x, (double)y, (double)z))) {
            return false;
        }
        this.mob.moveTo((double)x, (double)y, (double)z, this.mob.getYRot(), this.mob.getXRot());
        this.mob.getNavigation().stop();
        return true;
    }

    private boolean canTeleportTo(BlockPos position) {
        PathType pathtype = WalkNodeEvaluator.getPathTypeStatic((Mob)this.mob, (BlockPos)position);
        if (pathtype != PathType.WALKABLE) {
            return false;
        }
        BlockPos blockpos = position.subtract((Vec3i)this.mob.blockPosition());
        return this.mob.level().noCollision((Entity)this.mob, this.mob.getBoundingBox().move(blockpos));
    }
}

