/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.common.entity.creatures;

import by.dragonsurvivalteam.dragonsurvival.client.render.util.AnimationTickTimer;
import by.dragonsurvivalteam.dragonsurvival.client.render.util.RandomAnimationPicker;
import by.dragonsurvivalteam.dragonsurvival.common.entity.creatures.Hunter;
import by.dragonsurvivalteam.dragonsurvival.config.obj.ConfigOption;
import by.dragonsurvivalteam.dragonsurvival.config.obj.ConfigRange;
import by.dragonsurvivalteam.dragonsurvival.config.obj.ConfigSide;
import by.dragonsurvivalteam.dragonsurvival.registry.DSEffects;
import by.dragonsurvivalteam.dragonsurvival.registry.DSEntities;
import by.dragonsurvivalteam.dragonsurvival.registry.datagen.Translation;
import by.dragonsurvivalteam.dragonsurvival.util.AnimationUtils;
import by.dragonsurvivalteam.dragonsurvival.util.DragonUtils;
import by.dragonsurvivalteam.dragonsurvival.util.Functions;
import by.dragonsurvivalteam.dragonsurvival.util.SpawningUtils;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RangedAttackGoal;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.CommonHooks;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;

public class AmbusherEntity
extends Hunter
implements RangedAttackMob {
    @ConfigRange(min=1.0)
    @Translation(key="ambusher_spawn_frequency", type=Translation.Type.CONFIGURATION, comments={"Determines the amount of time (in ticks) (20 ticks = 1 second) that needs to pass before another ambusher spawn attempt is made"})
    @ConfigOption(side=ConfigSide.SERVER, category={"dragon_hunters", "ambusher"}, key="ambusher_spawn_frequency")
    public static int SPAWN_FREQUENCY = Functions.minutesToTicks(10.0);
    @ConfigRange(min=0.0, max=1.0)
    @Translation(key="amusher_spawn_chance", type=Translation.Type.CONFIGURATION, comments={"Determines the chance (in %) of an ambusher spawning", "The spawn frequency will reset even if no actual spawn occurs due to this chance not being met"})
    @ConfigOption(side=ConfigSide.SERVER, category={"dragon_hunters", "ambusher"}, key="amusher_spawn_chance")
    public static double SPAWN_CHANCE = 0.2;
    @ConfigRange(min=1.0)
    @Translation(key="ambusher_health", type=Translation.Type.CONFIGURATION, comments={"Base value for the max health attribute"})
    @ConfigOption(side=ConfigSide.SERVER, category={"dragon_hunters", "ambusher"}, key="ambusher_health")
    public static double MAX_HEALTH = 40.0;
    @ConfigRange(min=0.0)
    @Translation(key="ambusher_attack_damage", type=Translation.Type.CONFIGURATION, comments={"Base value for the attack damage attribute"})
    @ConfigOption(side=ConfigSide.SERVER, category={"dragon_hunters", "ambusher"}, key="ambusher_damage")
    public static int ATTACK_DAMAGE = 12;
    @ConfigRange(min=0.0)
    @Translation(key="ambusher_attack_knockback", type=Translation.Type.CONFIGURATION, comments={"Base value for the attack knockback attribute"})
    @ConfigOption(side=ConfigSide.SERVER, category={"dragon_hunters", "ambusher"}, key="ambusher_attack_knockback")
    public static int ATTACK_KNOCKBACK = 0;
    @ConfigRange(min=0.0)
    @Translation(key="ambusher_movement_speed", type=Translation.Type.CONFIGURATION, comments={"Base value for the movement speed attribute"})
    @ConfigOption(side=ConfigSide.SERVER, category={"dragon_hunters", "ambusher"}, key="ambusher_movement_speed")
    public static double MOVEMENT_SPEED = 0.3;
    @ConfigRange(min=0.0)
    @Translation(key="ambusher_armor", type=Translation.Type.CONFIGURATION, comments={"Base value for the armor attribute"})
    @ConfigOption(side=ConfigSide.SERVER, category={"dragon_hunters", "ambusher"}, key="ambusher_armor")
    public static double ARMOR = 10.0;
    @ConfigRange(min=0.0)
    @Translation(key="ambusher_armor_toughness", type=Translation.Type.CONFIGURATION, comments={"Base value for the armor toughness attribute"})
    @ConfigOption(side=ConfigSide.SERVER, category={"dragon_hunters", "ambusher"}, key="ambusher_armor_toughness")
    public static double ARMOR_TOUGHNESS = 0.0;
    @ConfigRange(min=0.0)
    @Translation(key="ambusher_knockback_resistance", type=Translation.Type.CONFIGURATION, comments={"Base value for the knockback resistance attribute"})
    @ConfigOption(side=ConfigSide.SERVER, category={"dragon_hunters", "ambusher"}, key="ambusher_knockback_resistance")
    public static double KNOCKBACK_RESISTANCE = 0.0;
    @ConfigRange(min=65.0)
    @Translation(key="ambusher_attack_interval", type=Translation.Type.CONFIGURATION, comments={"Determines the crossbow attack rate (in ticks) (20 ticks = 1 second) of the ambusher"})
    @ConfigOption(side=ConfigSide.SERVER, category={"dragon_hunters", "ambusher"}, key="ambusher_attack_interval")
    public static int ATTACK_INTERVAL = 65;
    @ConfigRange(min=0.0, max=256.0)
    @Translation(key="spearman_reinforcement_count", type=Translation.Type.CONFIGURATION, comments={"Determines how many spearman reinforce the ambusher when he is attacked"})
    @ConfigOption(side=ConfigSide.SERVER, category={"dragon_hunters", "ambusher"}, key="spearman_reinforcement_count")
    public static int SPEARMAN_REINFORCEMENT_COUNT = 4;
    @ConfigRange(min=0.0, max=256.0)
    @Translation(key="hound_reinforcement_count", type=Translation.Type.CONFIGURATION, comments={"Determines how many hounds reinforce the ambusher when he is attacked"})
    @ConfigOption(side=ConfigSide.SERVER, category={"dragon_hunters", "ambusher"}, key="hound_reinforcement_count")
    public static int HOUND_REINFORCEMENT_COUNT = 2;
    private static final EntityDataAccessor<Boolean> HAS_RELEASED_GRIFFIN = SynchedEntityData.defineId(AmbusherEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> NEARBY_DRAGON_PLAYER = SynchedEntityData.defineId(AmbusherEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> HAS_CALLED_REINFORCEMENTS = SynchedEntityData.defineId(AmbusherEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> HAS_SUMMONED_REINFORCEMENTS = SynchedEntityData.defineId(AmbusherEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Integer> RANGED_ATTACK_TIMER = SynchedEntityData.defineId(AmbusherEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> AMBUSH_HORN_AND_RELOAD_TIMER = SynchedEntityData.defineId(AmbusherEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> GRIFFIN_RELEASE_RELOAD_TIMER = SynchedEntityData.defineId(AmbusherEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private boolean isRandomIdleAnimSet = false;
    private boolean hasPlayedReleaseAnimation = false;
    private boolean hasPlayedReinforcementsAnimation = false;
    private boolean isFirstClientTick = true;
    private float nextArrowVelocity = 0.0f;
    private RawAnimation currentIdleAnim;
    private final AnimationTickTimer ambusherTickTimer = new AnimationTickTimer();
    private static final RandomAnimationPicker IDLE_ANIMS = new RandomAnimationPicker(new RandomAnimationPicker.WeightedAnimation(RawAnimation.begin().thenLoop("idle1"), 90.0f), new RandomAnimationPicker.WeightedAnimation(RawAnimation.begin().thenLoop("idle2"), 10.0f));
    private static final RawAnimation IDLE_AGGRESSIVE = RawAnimation.begin().thenLoop("idle_agressive_griffin");
    private static final RawAnimation WALK = RawAnimation.begin().thenLoop("walk");
    private static final RawAnimation SWIM = RawAnimation.begin().thenLoop("swim");
    private static final RawAnimation RUN = RawAnimation.begin().thenLoop("run");
    private static final int AMBUSH_ANIM_DURATION = 83;
    private static final int AMBUSH_HORN_SOUND_START_TIME = 38;
    private static final int AMBUSH_ARROW_PLACE_SOUND_TIME = 74;
    private static final RawAnimation AMBUSH_AND_GRIFFIN_RELEASE = RawAnimation.begin().thenPlay("ambush_and_griffin_release");
    private static final int GRIFFIN_RELEASE_ANIM_DURATION = 42;
    private static final int GRIFFIN_RELEASE_ARROW_PLACE_SOUND_TIME = 33;
    private static final RawAnimation ONLY_GRIFFIN_RELEASE = RawAnimation.begin().thenPlay("griffin_release");
    private static final RawAnimation IDLE_NO_GRIFFIN = RawAnimation.begin().thenLoop("idle_no_griffin");
    private static final RawAnimation WALK_NO_GRIFFIN = RawAnimation.begin().thenLoop("walk_no_griffin");
    private static final RawAnimation RUN_NO_GRIFFIN = RawAnimation.begin().thenLoop("run_no_griffin");
    private static final RawAnimation SWIM_NO_GRIFFIN = RawAnimation.begin().thenLoop("swim_no_griffin");
    private static final RawAnimation CROSSBOW_READY_BLEND = RawAnimation.begin().thenLoop("blend_crossbow_ready");
    public static final int CROSSBOW_SHOOT_AND_RELOAD_TIME = 60;
    private static final int CROSSBOW_ATTACK_START_TIME = 4;
    private static final int CROSSBOW_RELOAD_CHARGE_SOUND_TIME = 25;
    private static final int CROSSBOW_RELOAD_ARROW_PLACE_SOUND_TIME = 49;
    private static final RawAnimation CROSSBOW_SHOOT_AND_RELOAD_BLEND = RawAnimation.begin().thenPlay("blend_crossbow_shoot_and_reloading");

    @Override
    public double maxHealthConfig() {
        return MAX_HEALTH;
    }

    @Override
    public double attackDamageConfig() {
        return ATTACK_DAMAGE;
    }

    @Override
    public double attackKnockback() {
        return ATTACK_KNOCKBACK;
    }

    @Override
    public double movementSpeedConfig() {
        return MOVEMENT_SPEED;
    }

    @Override
    public double armorConfig() {
        return ARMOR;
    }

    @Override
    public double armorToughnessConfig() {
        return ARMOR_TOUGHNESS;
    }

    @Override
    public double knockbackResistanceConfig() {
        return KNOCKBACK_RESISTANCE;
    }

    public AmbusherEntity(EntityType<? extends PathfinderMob> entityType, Level world) {
        super(entityType, world);
    }

    @Override
    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(3, (Goal)new RangedAttackGoal(this, 1.0, ATTACK_INTERVAL, 5.0f){

            public boolean canUse() {
                return super.canUse() && (!AmbusherEntity.this.hasCalledReinforcements() || AmbusherEntity.this.hasSummonedReinforcements());
            }
        });
        this.goalSelector.addGoal(4, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f, 1.0f));
    }

    @Override
    public void tick() {
        super.tick();
        if (this.level().isClientSide()) {
            if (this.isFirstClientTick) {
                this.hasPlayedReleaseAnimation = this.hasReleasedGriffin();
                this.hasPlayedReinforcementsAnimation = this.hasCalledReinforcements();
                this.isFirstClientTick = false;
            }
            return;
        }
        if (this.isAggro() && !this.hasReleasedGriffin()) {
            this.setHasReleasedGriffin(true);
            this.summonGriffin();
            LivingEntity target = this.getTarget();
            if (target != null && target.hasEffect(DSEffects.HUNTER_OMEN)) {
                this.beginSummonReinforcements();
            } else {
                this.beginGriffinReleaseReloadTimer();
            }
        }
        if (this.getRangedAttackTimer() == 4) {
            this.fireArrow();
        }
        if (this.getRangedAttackTimer() == 25) {
            this.playSound((SoundEvent)SoundEvents.CROSSBOW_LOADING_MIDDLE.value(), 1.0f, 1.0f);
        }
        if (this.getRangedAttackTimer() == 49) {
            this.playSound((SoundEvent)SoundEvents.CROSSBOW_LOADING_END.value(), 1.0f, 1.0f);
        }
        if (this.getRangedAttackTimer() < ATTACK_INTERVAL && this.getRangedAttackTimer() >= 0) {
            this.setRangedAttackTimer(this.getRangedAttackTimer() + 1);
        } else {
            this.setRangedAttackTimer(-1);
        }
        if (this.getAmbushHornTimer() == 38) {
            this.playSound((SoundEvent)((Holder.Reference)SoundEvents.GOAT_HORN_SOUND_VARIANTS.getFirst()).value(), 1.0f, 1.0f);
        }
        if (this.getAmbushHornTimer() == 74) {
            this.playSound((SoundEvent)SoundEvents.CROSSBOW_LOADING_END.value(), 1.0f, 1.0f);
        }
        if (this.getAmbushHornTimer() < 83 && this.getAmbushHornTimer() >= 0) {
            this.setAmbushHornTimer(this.getAmbushHornTimer() + 1);
        } else {
            if (this.hasCalledReinforcements() && !this.hasSummonedReinforcements()) {
                this.summonReinforcements();
            }
            this.setAmbushHornTimer(-1);
        }
        if (this.getGriffinReleaseReloadTimer() < 42 && this.getGriffinReleaseReloadTimer() >= 0) {
            this.setGriffinReleaseReloadTimer(this.getGriffinReleaseReloadTimer() + 1);
        } else {
            this.setGriffinReleaseReloadTimer(-1);
        }
        this.setNearbyDragonPlayer(DragonUtils.isNearbyDragonPlayerToEntity(8.0, this.level(), (Entity)this));
    }

    public void performRangedAttack(@NotNull LivingEntity pTarget, float pVelocity) {
        if (this.getGriffinReleaseReloadTimer() == -1 && this.getAmbushHornTimer() == -1) {
            this.setRangedAttackTimer(0);
            this.nextArrowVelocity = pVelocity;
        }
    }

    private void fireArrow() {
        CrossbowItem tempCrossbowitem = (CrossbowItem)Items.CROSSBOW;
        ItemStack tempCrossbowItemStack = new ItemStack((ItemLike)tempCrossbowitem, 1);
        CrossbowItem.tryLoadProjectiles((LivingEntity)this, (ItemStack)tempCrossbowItemStack);
        tempCrossbowitem.performShooting(this.level(), (LivingEntity)this, InteractionHand.MAIN_HAND, tempCrossbowItemStack, this.nextArrowVelocity, 1.0f, this.getTarget());
    }

    @NotNull
    public ItemStack getProjectile(@NotNull ItemStack pWeaponStack) {
        return CommonHooks.getProjectile((LivingEntity)this, (ItemStack)pWeaponStack, (ItemStack)new ItemStack((ItemLike)Items.ARROW, 1));
    }

    private void beginSummonReinforcements() {
        this.setHasCalledReinforcements(true);
        this.setAmbushHornTimer(0);
    }

    private void beginGriffinReleaseReloadTimer() {
        this.setGriffinReleaseReloadTimer(0);
    }

    private void summonReinforcements() {
        Mob mob;
        int i;
        for (i = 0; i < SPEARMAN_REINFORCEMENT_COUNT; ++i) {
            mob = (Mob)((EntityType)DSEntities.HUNTER_SPEARMAN.get()).create(this.level());
            SpawningUtils.spawn(mob, this.position(), this.level(), MobSpawnType.MOB_SUMMONED, 20, 3.0f, true);
            mob.setTarget(this.getTarget());
        }
        for (i = 0; i < HOUND_REINFORCEMENT_COUNT; ++i) {
            mob = (Mob)((EntityType)DSEntities.HUNTER_HOUND.get()).create(this.level());
            SpawningUtils.spawn(mob, this.position(), this.level(), MobSpawnType.MOB_SUMMONED, 20, 3.0f, true);
            mob.setTarget(this.getTarget());
        }
        Mob mob2 = (Mob)((EntityType)DSEntities.HUNTER_KNIGHT.get()).create(this.level());
        SpawningUtils.spawn(mob2, this.position(), this.level(), MobSpawnType.MOB_SUMMONED, 20, 3.0f, true);
        mob2.setTarget(this.getTarget());
        this.setHasSummonedReinforcements(true);
    }

    private void summonGriffin() {
        Mob mob = (Mob)((EntityType)DSEntities.HUNTER_GRIFFIN.get()).create(this.level());
        SpawningUtils.spawn(mob, this.position().add(0.0, 2.0, 0.0), this.level(), MobSpawnType.MOB_SUMMONED, 20, 3.0f, true);
        mob.setTarget(this.getTarget());
    }

    @Override
    protected void defineSynchedData(@NotNull SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(HAS_RELEASED_GRIFFIN, (Object)false);
        builder.define(NEARBY_DRAGON_PLAYER, (Object)false);
        builder.define(HAS_CALLED_REINFORCEMENTS, (Object)false);
        builder.define(HAS_SUMMONED_REINFORCEMENTS, (Object)false);
        builder.define(RANGED_ATTACK_TIMER, (Object)-1);
        builder.define(AMBUSH_HORN_AND_RELOAD_TIMER, (Object)-1);
        builder.define(GRIFFIN_RELEASE_RELOAD_TIMER, (Object)-1);
    }

    public void addAdditionalSaveData(@NotNull CompoundTag compoundNBT) {
        super.addAdditionalSaveData(compoundNBT);
        compoundNBT.putBoolean("HasReleasedGriffin", this.hasReleasedGriffin());
        compoundNBT.putBoolean("HasCalledReinforcements", this.hasCalledReinforcements());
        compoundNBT.putBoolean("HasSummonedReinforcements", this.hasSummonedReinforcements());
    }

    public void readAdditionalSaveData(@NotNull CompoundTag compoundNBT) {
        super.readAdditionalSaveData(compoundNBT);
        this.setHasReleasedGriffin(compoundNBT.getBoolean("HasReleasedGriffin"));
        this.setHasCalledReinforcements(compoundNBT.getBoolean("HasCalledReinforcements"));
        this.setHasSummonedReinforcements(compoundNBT.getBoolean("HasSummonedReinforcements"));
    }

    public boolean hasReleasedGriffin() {
        return (Boolean)this.entityData.get(HAS_RELEASED_GRIFFIN);
    }

    public void setHasReleasedGriffin(boolean hasReleasedGriffin) {
        this.entityData.set(HAS_RELEASED_GRIFFIN, (Object)hasReleasedGriffin);
    }

    public int getRangedAttackTimer() {
        return (Integer)this.entityData.get(RANGED_ATTACK_TIMER);
    }

    public void setRangedAttackTimer(int rangedAttackTimer) {
        this.entityData.set(RANGED_ATTACK_TIMER, (Object)rangedAttackTimer);
    }

    public int getAmbushHornTimer() {
        return (Integer)this.entityData.get(AMBUSH_HORN_AND_RELOAD_TIMER);
    }

    public void setAmbushHornTimer(int ambushHornTimer) {
        this.entityData.set(AMBUSH_HORN_AND_RELOAD_TIMER, (Object)ambushHornTimer);
    }

    public int getGriffinReleaseReloadTimer() {
        return (Integer)this.entityData.get(GRIFFIN_RELEASE_RELOAD_TIMER);
    }

    public void setGriffinReleaseReloadTimer(int griffinReleaseReloadTimer) {
        this.entityData.set(GRIFFIN_RELEASE_RELOAD_TIMER, (Object)griffinReleaseReloadTimer);
    }

    public boolean hasCalledReinforcements() {
        return (Boolean)this.entityData.get(HAS_CALLED_REINFORCEMENTS);
    }

    public void setHasCalledReinforcements(boolean hasCalledReinforcements) {
        this.entityData.set(HAS_CALLED_REINFORCEMENTS, (Object)hasCalledReinforcements);
    }

    public boolean hasNearbyDragonPlayer() {
        return (Boolean)this.entityData.get(NEARBY_DRAGON_PLAYER);
    }

    public void setNearbyDragonPlayer(boolean nearbyDragonPlayer) {
        this.entityData.set(NEARBY_DRAGON_PLAYER, (Object)nearbyDragonPlayer);
    }

    public boolean hasSummonedReinforcements() {
        return (Boolean)this.entityData.get(HAS_SUMMONED_REINFORCEMENTS);
    }

    public void setHasSummonedReinforcements(boolean hasSummonedReinforcements) {
        this.entityData.set(HAS_SUMMONED_REINFORCEMENTS, (Object)hasSummonedReinforcements);
    }

    public double getRunThreshold() {
        return 0.15;
    }

    public double getWalkThreshold() {
        return 0.01;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController((GeoAnimatable)this, "everything", 3, this::fullPredicate));
        controllers.add(new AnimationController((GeoAnimatable)this, "arms", 3, this::armsPredicate));
    }

    public boolean isIdle() {
        double movement = AnimationUtils.getMovementSpeed((LivingEntity)this);
        return this.swingTime <= 0 && !(movement > this.getWalkThreshold());
    }

    public PlayState fullPredicate(AnimationState<Hunter> state) {
        double movement = AnimationUtils.getMovementSpeed((LivingEntity)this);
        boolean isCurrentlyIdlingRandomly = false;
        if (this.hasReleasedGriffin() && !this.hasPlayedReleaseAnimation && !this.hasPlayedReinforcementsAnimation) {
            if (this.hasCalledReinforcements()) {
                this.hasPlayedReinforcementsAnimation = true;
                this.ambusherTickTimer.putAnimation(AMBUSH_AND_GRIFFIN_RELEASE, (Double)83.0);
                state.setAndContinue(AMBUSH_AND_GRIFFIN_RELEASE);
            } else {
                this.hasPlayedReleaseAnimation = true;
                this.ambusherTickTimer.putAnimation(ONLY_GRIFFIN_RELEASE, (Double)42.0);
                state.setAndContinue(ONLY_GRIFFIN_RELEASE);
            }
        } else {
            if (this.ambusherTickTimer.getDuration(ONLY_GRIFFIN_RELEASE) > 0.0 || this.ambusherTickTimer.getDuration(AMBUSH_AND_GRIFFIN_RELEASE) > 0.0) {
                return PlayState.CONTINUE;
            }
            if (this.isInWater()) {
                if (this.hasReleasedGriffin()) {
                    state.setAndContinue(SWIM_NO_GRIFFIN);
                } else {
                    state.setAndContinue(SWIM);
                }
            } else if (movement > this.getRunThreshold()) {
                if (this.hasReleasedGriffin()) {
                    state.setAndContinue(RUN_NO_GRIFFIN);
                } else {
                    state.setAndContinue(RUN);
                }
            } else if (movement > this.getWalkThreshold()) {
                if (this.hasReleasedGriffin()) {
                    state.setAndContinue(WALK_NO_GRIFFIN);
                } else {
                    state.setAndContinue(WALK);
                }
            } else if (this.hasReleasedGriffin()) {
                state.setAndContinue(IDLE_NO_GRIFFIN);
            } else if (this.hasNearbyDragonPlayer()) {
                state.setAndContinue(IDLE_AGGRESSIVE);
            } else {
                isCurrentlyIdlingRandomly = true;
                state.setAndContinue(this.getIdleAnim());
            }
        }
        if (!isCurrentlyIdlingRandomly && this.isRandomIdleAnimSet) {
            this.isRandomIdleAnimSet = false;
        }
        return PlayState.CONTINUE;
    }

    public PlayState armsPredicate(AnimationState<Hunter> state) {
        if (this.hasReleasedGriffin() && this.getGriffinReleaseReloadTimer() == -1 && this.getAmbushHornTimer() == -1) {
            if (this.getRangedAttackTimer() == 1) {
                this.ambusherTickTimer.putAnimation(CROSSBOW_SHOOT_AND_RELOAD_BLEND, (Double)60.0);
                return state.setAndContinue(CROSSBOW_SHOOT_AND_RELOAD_BLEND);
            }
            if (this.ambusherTickTimer.getDuration(CROSSBOW_SHOOT_AND_RELOAD_BLEND) > 0.0) {
                return PlayState.CONTINUE;
            }
            return state.setAndContinue(CROSSBOW_READY_BLEND);
        }
        return PlayState.STOP;
    }

    public RawAnimation getIdleAnim() {
        if (!this.isRandomIdleAnimSet) {
            this.currentIdleAnim = IDLE_ANIMS.pickRandomAnimation();
            this.isRandomIdleAnimSet = true;
        }
        return this.currentIdleAnim;
    }
}

